/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.EditableSchemesCombo;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesPanel<T extends Scheme, InfoComponent extends JComponent>
extends JPanel {
    private EditableSchemesCombo<T> mySchemesCombo;
    private AbstractSchemeActions<T> myActions;
    private JComponent myToolbar;
    protected InfoComponent myInfoComponent;
    protected static final Color HINT_FOREGROUND = JBColor.GRAY;
    protected static final Color ERROR_MESSAGE_FOREGROUND = Color.RED;
    protected static final int DEFAULT_VGAP = 8;

    public AbstractSchemesPanel() {
        this(8, null);
    }

    public AbstractSchemesPanel(int vGap) {
        this(vGap, null);
    }

    public AbstractSchemesPanel(int vGap, @Nullable JComponent rightCustomComponent) {
        this.setLayout(new BoxLayout(this, 3));
        this.createUIComponents(vGap, rightCustomComponent);
    }

    private void createUIComponents(int vGap, @Nullable JComponent rightCustomComponent) {
        JPanel verticalContainer = rightCustomComponent != null ? AbstractSchemesPanel.createVerticalContainer() : this;
        JPanel controlsPanel = this.createControlsPanel();
        verticalContainer.add(controlsPanel);
        IdeUICustomization.getInstance().customizeSchemePanel((JPanel)this, verticalContainer);
        verticalContainer.add(Box.createRigidArea((Dimension)new JBDimension(0, 12)));
        if (rightCustomComponent != null) {
            JPanel horizontalContainer = new JPanel();
            horizontalContainer.setLayout(new BoxLayout(horizontalContainer, 0));
            horizontalContainer.add(verticalContainer);
            horizontalContainer.add(Box.createHorizontalGlue());
            horizontalContainer.add(rightCustomComponent);
            this.add(horizontalContainer);
        }
        this.add(new JSeparator());
        if (vGap > 0) {
            this.add(Box.createVerticalGlue());
            this.add(Box.createRigidArea((Dimension)new JBDimension(0, vGap)));
        }
    }

    private static JPanel createVerticalContainer() {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        return container;
    }

    private JPanel createControlsPanel() {
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        String label2 = this.getComboBoxLabel();
        if (label2 != null) {
            controlsPanel.add(new JLabel(label2));
            controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        }
        this.myActions = this.createSchemeActions();
        this.mySchemesCombo = new EditableSchemesCombo(this);
        controlsPanel.add(this.mySchemesCombo.getComponent());
        this.myToolbar = this.createToolbar();
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        controlsPanel.add(this.myToolbar);
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(9, 0)));
        this.myInfoComponent = this.createInfoComponent();
        controlsPanel.add((Component)this.myInfoComponent);
        controlsPanel.add(Box.createHorizontalGlue());
        this.mySchemesCombo.getComponent().setMaximumSize(this.mySchemesCombo.getComponent().getPreferredSize());
        int height = this.mySchemesCombo.getComponent().getPreferredSize().height;
        controlsPanel.setMaximumSize(new Dimension(controlsPanel.getMaximumSize().width, height));
        return controlsPanel;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowSchemesActionsListAction(this.myActions.getActions()));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("NavBarToolbar", (ActionGroup)group, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(JBUI.Borders.empty((int)3));
        return toolbarComponent;
    }

    public final JComponent getToolbar() {
        return this.myToolbar;
    }

    protected abstract AbstractSchemeActions<T> createSchemeActions();

    public final T getSelectedScheme() {
        return this.mySchemesCombo.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme2) {
        this.mySchemesCombo.selectScheme(scheme2);
    }

    public final void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(0);
        }
        this.mySchemesCombo.resetSchemes(schemes);
    }

    public void disposeUIResources() {
        this.removeAll();
    }

    public final void editCurrentSchemeName(@NotNull BiConsumer<? super T, ? super String> newSchemeNameConsumer) {
        Object currentScheme;
        if (newSchemeNameConsumer == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(1);
        }
        if ((currentScheme = this.getSelectedScheme()) != null) {
            String currentName = currentScheme.getName();
            this.mySchemesCombo.startEdit(currentName, this.getModel().isProjectScheme(currentScheme), newName -> {
                if (newSchemeNameConsumer == null) {
                    AbstractSchemesPanel.$$$reportNull$$$0(8);
                }
                if (!newName.equals(currentName)) {
                    newSchemeNameConsumer.accept((Object)currentScheme, (String)newName);
                }
            });
        }
    }

    public final void editNewSchemeName(@NotNull String preferredName, boolean isProjectScheme, @NotNull Consumer<? super String> nameConsumer) {
        if (preferredName == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(2);
        }
        if (nameConsumer == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(3);
        }
        String name = SchemeNameGenerator.getUniqueName(preferredName, schemeName -> this.getModel().containsScheme((String)schemeName, isProjectScheme));
        this.mySchemesCombo.startEdit(name, isProjectScheme, nameConsumer);
    }

    public final void cancelEdit() {
        this.mySchemesCombo.cancelEdit();
    }

    public final void showInfo(@Nullable String message, @NotNull MessageType messageType) {
        if (messageType == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(4);
        }
        this.myToolbar.setVisible(false);
        this.showMessage(message, messageType);
    }

    protected abstract void showMessage(@Nullable String var1, @NotNull MessageType var2);

    public final void clearInfo() {
        this.myToolbar.setVisible(true);
        this.clearMessage();
    }

    protected abstract void clearMessage();

    public final AbstractSchemeActions<T> getActions() {
        return this.myActions;
    }

    @NotNull
    protected abstract InfoComponent createInfoComponent();

    @Nullable
    protected String getComboBoxLabel() {
        return this.getSchemeTypeName() + ":";
    }

    protected String getSchemeTypeName() {
        return ApplicationBundle.message((String)"editbox.scheme.type.name", (Object[])new Object[0]);
    }

    @NotNull
    public abstract SchemesModel<T> getModel();

    public final void updateOnCurrentSettingsChange() {
        this.mySchemesCombo.updateSelected();
    }

    protected int getIndent(@NotNull T scheme2) {
        if (scheme2 == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(5);
        }
        return 0;
    }

    protected abstract boolean supportsProjectSchemes();

    protected abstract boolean highlightNonDefaultSchemes();

    protected boolean hideDeleteActionIfUnavailable() {
        return true;
    }

    public abstract boolean useBoldForNonRemovableSchemes();

    public void showStatus(String message, MessageType messageType) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(5000L);
        Balloon balloon = balloonBuilder.createBalloon();
        Point pointOnComponent = new Point(this.myToolbar.getWidth() / 4, this.myToolbar.getHeight() / 4);
        balloon.show(new RelativePoint((Component)this.myToolbar, pointOnComponent), Balloon.Position.above);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    protected static void showMessage(@Nullable String message, @NotNull MessageType messageType, @NotNull JLabel infoComponent) {
        if (messageType == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(6);
        }
        if (infoComponent == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(7);
        }
        infoComponent.setText(message);
        Color foreground = messageType == MessageType.INFO ? HINT_FOREGROUND : (messageType == MessageType.ERROR ? ERROR_MESSAGE_FOREGROUND : messageType.getTitleForeground());
        infoComponent.setForeground(foreground);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSchemeNameConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConsumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSchemes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "editCurrentSchemeName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "editNewSchemeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$editCurrentSchemeName$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ShowSchemesActionsListAction
    extends NonTrivialActionGroup {
        ShowSchemesActionsListAction(Collection<? extends AnAction> actions) {
            this.setPopup(true);
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText("Show Scheme Actions");
            this.getTemplatePresentation().setDescription("Show Scheme Actions");
            this.addAll(actions);
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                ShowSchemesActionsListAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSchemesActionsListAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), true, null, Integer.MAX_VALUE);
            HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)popup2);
            Component component = e.getInputEvent().getComponent();
            if (component instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component);
            } else {
                popup2.showInCenterOf(component);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemesPanel$ShowSchemesActionsListAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

