/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JbXmlOutputter {
    private static final Format DEFAULT_FORMAT = JDOMUtil.createFormat((String)"\n");
    private final Format format;
    @Nullable
    private final JDOMUtil.ElementOutputFilter elementFilter;
    @Nullable
    private final ReplacePathToMacroMap macroMap;
    @Nullable
    private final PathMacroFilter macroFilter;

    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter) {
        if (lineSeparator == null) {
            JbXmlOutputter.$$$reportNull$$$0(0);
        }
        this.format = DEFAULT_FORMAT.getLineSeparator().equals(lineSeparator) ? DEFAULT_FORMAT : JDOMUtil.createFormat((String)lineSeparator);
        this.elementFilter = elementFilter;
        this.macroMap = macroMap;
        this.macroFilter = macroFilter;
    }

    public static void collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project, @NotNull Writer writer) throws IOException {
        if (element == null) {
            JbXmlOutputter.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JbXmlOutputter.$$$reportNull$$$0(2);
        }
        if (writer == null) {
            JbXmlOutputter.$$$reportNull$$$0(3);
        }
        PathMacroManager macroManager = PathMacroManager.getInstance(project);
        JbXmlOutputter xmlWriter = new JbXmlOutputter("\n", null, macroManager.getReplacePathMap(), macroManager.getMacroFilter());
        xmlWriter.output(element, writer);
    }

    @NotNull
    public static String collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project) throws IOException {
        if (element == null) {
            JbXmlOutputter.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JbXmlOutputter.$$$reportNull$$$0(5);
        }
        StringWriter writer = new StringWriter();
        JbXmlOutputter.collapseMacrosAndWrite(element, project, writer);
        String string = writer.toString();
        if (string == null) {
            JbXmlOutputter.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(out, this.format.getEncoding());
        List content = doc.getContent();
        for (Content obj : content) {
            if (obj instanceof Element) {
                this.printElement(out, doc.getRootElement(), 0);
            } else if (obj instanceof Comment) {
                JbXmlOutputter.printComment(out, (Comment)obj);
            } else if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)obj);
            } else if (obj instanceof DocType) {
                this.printDocType(out, doc.getDocType());
                this.writeLineSeparator(out);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        this.writeLineSeparator(out);
        out.flush();
    }

    private void writeLineSeparator(Writer out) throws IOException {
        if (this.format.getLineSeparator() != null) {
            out.write(this.format.getLineSeparator());
        }
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(out, doctype);
        out.flush();
    }

    public void output(@NotNull Element element, @NotNull Writer out) throws IOException {
        if (element == null) {
            JbXmlOutputter.$$$reportNull$$$0(7);
        }
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(8);
        }
        this.printElement(out, element, 0);
    }

    private void printDeclaration(Writer out, String encoding) throws IOException {
        if (!this.format.getOmitDeclaration()) {
            out.write("<?xml version=\"1.0\"");
            if (!this.format.getOmitEncoding()) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            this.writeLineSeparator(out);
        }
    }

    private void printDocType(Writer out, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (internalSubset != null && !internalSubset.isEmpty()) {
            out.write(" [");
            this.writeLineSeparator(out);
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
    }

    private static void printComment(Writer out, Comment comment) throws IOException {
        out.write("<!--");
        out.write(comment.getText());
        out.write("-->");
    }

    private void printProcessingInstruction(Writer out, ProcessingInstruction pi) throws IOException {
        String target2 = pi.getTarget();
        boolean piProcessed = false;
        if (!this.format.getIgnoreTrAXEscapingPIs()) {
            if (target2.equals("javax.xml.transform.disable-output-escaping")) {
                piProcessed = true;
            } else if (target2.equals("javax.xml.transform.enable-output-escaping")) {
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (rawData != null && !rawData.isEmpty()) {
                out.write("<?");
                out.write(target2);
                out.write(" ");
                out.write(rawData);
                out.write("?>");
            } else {
                out.write("<?");
                out.write(target2);
                out.write("?>");
            }
        }
    }

    private static void printEntityRef(Writer out, EntityRef entity) throws IOException {
        out.write("&");
        out.write(entity.getName());
        out.write(";");
    }

    private void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = this.format.getTextMode() == Format.TextMode.NORMALIZE ? cdata.getTextNormalize() : (this.format.getTextMode() == Format.TextMode.TRIM ? cdata.getText().trim() : cdata.getText());
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    private void printString(@NotNull Element parentElement, @NotNull Writer out, String str) throws IOException {
        if (parentElement == null) {
            JbXmlOutputter.$$$reportNull$$$0(9);
        }
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(10);
        }
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            str = Text.normalizeString((String)str);
        } else if (this.format.getTextMode() == Format.TextMode.TRIM) {
            str = str.trim();
        }
        if (this.macroMap != null) {
            str = this.macroMap.substitute(str, SystemInfoRt.isFileSystemCaseSensitive);
        }
        out.write(JbXmlOutputter.escapeElementEntities(str));
    }

    public void printElement(@NotNull Writer out, @NotNull Element element, int level) throws IOException {
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JbXmlOutputter.$$$reportNull$$$0(12);
        }
        if (this.elementFilter != null && !this.elementFilter.accept(element, level)) {
            return;
        }
        out.write(60);
        JbXmlOutputter.printQualifiedName(out, element);
        if (element.hasAttributes()) {
            this.printAttributes(out, element.getAttributes());
        }
        if (!this.writeContent(out, element, level)) {
            return;
        }
        out.write("</");
        JbXmlOutputter.printQualifiedName(out, element);
        out.write(62);
    }

    protected boolean writeContent(@NotNull Writer out, @NotNull Element element, int level) throws IOException {
        int size;
        List content;
        int start2;
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(13);
        }
        if (element == null) {
            JbXmlOutputter.$$$reportNull$$$0(14);
        }
        if ((start2 = this.skipLeadingWhite(content = element.getContent(), 0)) >= (size = content.size())) {
            out.write(" />");
            return false;
        }
        out.write(62);
        if (JbXmlOutputter.nextNonText(content, start2) < size) {
            this.newline(out);
            this.printContentRange(element, out, content, start2, size, level + 1);
            this.newline(out);
            this.indent(out, level);
        } else {
            this.printTextRange(element, out, content, start2, size);
        }
        return true;
    }

    private void printContentRange(@NotNull Element parentElement, @NotNull Writer out, @NotNull List<Content> content, int start2, int end, int level) throws IOException {
        if (parentElement == null) {
            JbXmlOutputter.$$$reportNull$$$0(15);
        }
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(16);
        }
        if (content == null) {
            JbXmlOutputter.$$$reportNull$$$0(17);
        }
        int index = start2;
        while (index < end) {
            boolean firstNode = index == start2;
            Content next = content.get(index);
            if (next instanceof Text || next instanceof EntityRef) {
                int first = this.skipLeadingWhite(content, index);
                if (first >= (index = JbXmlOutputter.nextNonText(content, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(parentElement, out, content, first, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Comment) {
                JbXmlOutputter.printComment(out, (Comment)next);
            } else if (next instanceof Element) {
                this.printElement(out, (Element)next, level);
            } else if (next instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)next);
            }
            ++index;
        }
    }

    private void printTextRange(@NotNull Element parentElement, @NotNull Writer out, @NotNull List<Content> content, int start2, int end) throws IOException {
        if (parentElement == null) {
            JbXmlOutputter.$$$reportNull$$$0(18);
        }
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(19);
        }
        if (content == null) {
            JbXmlOutputter.$$$reportNull$$$0(20);
        }
        if ((start2 = this.skipLeadingWhite(content, start2)) >= content.size()) {
            return;
        }
        end = this.skipTrailingWhite(content, end);
        String previous = null;
        for (int i = start2; i < end; ++i) {
            String next;
            Content node = content.get(i);
            if (node instanceof Text) {
                next = ((Text)node).getText();
            } else if (node instanceof EntityRef) {
                next = "&" + node.getValue() + ";";
            } else {
                throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
            }
            if (next == null || next.isEmpty()) continue;
            if (previous != null && (this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) && (JbXmlOutputter.endsWithWhite(previous) || JbXmlOutputter.startsWithWhite(next))) {
                out.write(32);
            }
            if (node instanceof CDATA) {
                this.printCDATA(out, (CDATA)node);
            } else if (node instanceof EntityRef) {
                JbXmlOutputter.printEntityRef(out, (EntityRef)node);
            } else {
                this.printString(parentElement, out, next);
            }
            previous = next;
        }
    }

    private void printAttributes(Writer out, List<Attribute> attributes) throws IOException {
        for (Attribute attribute : attributes) {
            out.write(32);
            JbXmlOutputter.printQualifiedName(out, attribute);
            out.write(61);
            out.write(34);
            String value = this.macroMap != null && (this.macroFilter == null || !this.macroFilter.skipPathMacros(attribute)) ? this.macroMap.getAttributeValue(attribute, this.macroFilter, SystemInfoRt.isFileSystemCaseSensitive, false) : attribute.getValue();
            out.write(JbXmlOutputter.escapeAttributeEntities(value));
            out.write(34);
        }
    }

    private void newline(Writer out) throws IOException {
        if (this.format.getIndent() != null) {
            this.writeLineSeparator(out);
        }
    }

    private void indent(Writer out, int level) throws IOException {
        if (StringUtil.isEmpty((String)this.format.getIndent())) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            out.write(this.format.getIndent());
        }
    }

    private int skipLeadingWhite(@NotNull List<Content> content, int start2) {
        int index;
        if (content == null) {
            JbXmlOutputter.$$$reportNull$$$0(21);
        }
        if (start2 < 0) {
            start2 = 0;
        }
        int size = content.size();
        if (this.format.getTextMode() == Format.TextMode.TRIM_FULL_WHITE || this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) {
            for (index = start2; index < size; ++index) {
                if (JbXmlOutputter.isAllWhitespace(content.get(index))) continue;
                return index;
            }
        }
        return index;
    }

    private int skipTrailingWhite(List<Content> content, int start2) {
        int index;
        int size = content.size();
        if (start2 > size) {
            start2 = size;
        }
        if (this.format.getTextMode() == Format.TextMode.TRIM_FULL_WHITE || this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) {
            for (index = start2; index >= 0 && JbXmlOutputter.isAllWhitespace(content.get(index - 1)); --index) {
            }
        }
        return index;
    }

    private static int nextNonText(List<Content> content, int start2) {
        if (start2 < 0) {
            start2 = 0;
        }
        int size = content.size();
        for (int index = start2; index < size; ++index) {
            Content node = content.get(index);
            if (node instanceof Text || node instanceof EntityRef) continue;
            return index;
        }
        return size;
    }

    private static boolean isAllWhitespace(Content obj) {
        if (!(obj instanceof Text)) {
            return false;
        }
        String str = ((Text)obj).getText();
        for (int i = 0; i < str.length(); ++i) {
            if (Verifier.isXMLWhitespace((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithWhite(String str) {
        return !StringUtil.isEmpty((String)str) && Verifier.isXMLWhitespace((char)str.charAt(0));
    }

    private static boolean endsWithWhite(String str) {
        return !StringUtil.isEmpty((String)str) && Verifier.isXMLWhitespace((char)str.charAt(str.length() - 1));
    }

    private static String escapeAttributeEntities(String str) {
        return JDOMUtil.escapeText((String)str, (boolean)false, (boolean)true);
    }

    protected static String escapeElementEntities(String str) {
        return JDOMUtil.escapeText((String)str, (boolean)false, (boolean)false);
    }

    private static void printQualifiedName(@NotNull Writer out, @NotNull Element e) throws IOException {
        if (out == null) {
            JbXmlOutputter.$$$reportNull$$$0(22);
        }
        if (e == null) {
            JbXmlOutputter.$$$reportNull$$$0(23);
        }
        if (!e.getNamespace().getPrefix().isEmpty()) {
            out.write(e.getNamespace().getPrefix());
            out.write(58);
        }
        out.write(e.getName());
    }

    private static void printQualifiedName(Writer out, Attribute a) throws IOException {
        String prefix = a.getNamespace().getPrefix();
        if (!StringUtil.isEmpty((String)prefix)) {
            out.write(prefix);
            out.write(58);
        }
        out.write(a.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/configurationStore/JbXmlOutputter";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/configurationStore/JbXmlOutputter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseMacrosAndWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collapseMacrosAndWrite";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "output";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "printElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printContentRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "printTextRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "skipLeadingWhite";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "printQualifiedName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

