/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J*\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0014J \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0014J\"\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006'"}, d2={"Lcom/intellij/configurationStore/ModuleStateStorageManager;", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "macroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/module/Module;)V", "isExternalSystemStorageEnabled", "", "()Z", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "elements", "", "rootAttributes", "", "", "createFileBasedStorage", "Lcom/intellij/openapi/components/StateStorage;", "path", "collapsedPath", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "rootTagName", "getOldStorageSpec", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "pathRenamed", "oldPath", "newPath", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "ModuleFileStorage", "intellij.platform.configurationStore.impl"})
public final class ModuleStateStorageManager
extends StateStorageManagerImpl {
    @Override
    @NotNull
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        return "$MODULE_FILE$";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pathRenamed(@NotNull String oldPath, @NotNull String newPath, @Nullable VFileEvent event) {
        Object requestor;
        VFileEvent vFileEvent;
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        try {
            super.pathRenamed(oldPath, newPath, event);
            vFileEvent = event;
        }
        catch (Throwable throwable) {
            Object requestor2;
            VFileEvent vFileEvent2 = event;
            Object object = requestor2 = vFileEvent2 != null ? vFileEvent2.getRequestor() : null;
            if (requestor2 == null || !(requestor2 instanceof StateStorage)) {
                ComponentManager componentManager = this.getComponentManager();
                if (componentManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.module.impl.ModuleEx");
                }
                ModuleEx module = (ModuleEx)componentManager;
                String string = module.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                String oldName = string;
                module.rename(ModulePathKt.getModuleNameByFilePath(newPath), false);
                ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
                if (!(moduleManager instanceof ModuleManagerImpl)) {
                    moduleManager = null;
                }
                ModuleManagerImpl moduleManagerImpl = (ModuleManagerImpl)moduleManager;
                if (moduleManagerImpl != null) {
                    moduleManagerImpl.fireModuleRenamedByVfsEvent(module, oldName);
                }
            }
            throw throwable;
        }
        Object object = requestor = vFileEvent != null ? vFileEvent.getRequestor() : null;
        if (requestor == null || !(requestor instanceof StateStorage)) {
            ComponentManager componentManager = this.getComponentManager();
            if (componentManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.module.impl.ModuleEx");
            }
            ModuleEx module = (ModuleEx)componentManager;
            String string = module.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
            String oldName = string;
            module.rename(ModulePathKt.getModuleNameByFilePath(newPath), false);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
            if (!(moduleManager instanceof ModuleManagerImpl)) {
                moduleManager = null;
            }
            ModuleManagerImpl moduleManagerImpl = (ModuleManagerImpl)moduleManager;
            if (moduleManagerImpl != null) {
                moduleManagerImpl.fireModuleRenamedByVfsEvent(module, oldName);
            }
        }
    }

    @Override
    protected void beforeElementLoaded(@NotNull Element element) {
        Iterator iterator;
        Iterator iterator2;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Element optionElement = new Element("component").setAttribute("name", "DeprecatedModuleOptionManager");
        Iterator iterator3 = iterator2 = (iterator = element.getAttributes().iterator());
        while (iterator3.hasNext()) {
            Attribute attribute;
            Attribute attribute2 = attribute = (Attribute)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)attribute2, (String)"attribute");
            if (!(Intrinsics.areEqual((Object)attribute2.getName(), (Object)"version") ^ true)) continue;
            iterator.remove();
            optionElement.addContent(new Element("option").setAttribute("key", attribute.getName()).setAttribute("value", attribute.getValue()));
        }
        element.addContent(optionElement);
    }

    @Override
    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Iterator<Element> componentIterator;
        Iterator<Element> iterator;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(rootAttributes, (String)"rootAttributes");
        Iterator<Element> iterator2 = iterator = (componentIterator = elements.iterator());
        while (iterator2.hasNext()) {
            Element component = iterator2.next();
            if (!Intrinsics.areEqual((Object)component.getAttributeValue("name"), (Object)"DeprecatedModuleOptionManager")) continue;
            componentIterator.remove();
            for (Element option : component.getChildren("option")) {
                String string = option.getAttributeValue("key");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"option.getAttributeValue(\"key\")");
                String string2 = option.getAttributeValue("value");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"option.getAttributeValue(\"value\")");
                rootAttributes.put(string, string2);
            }
        }
        rootAttributes.put("version", "4");
    }

    @Override
    public boolean isExternalSystemStorageEnabled() {
        ComponentManager componentManager = this.getComponentManager();
        if (componentManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.module.Module");
        }
        Project project = ((Module)componentManager).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"(componentManager as Module).project");
        return ProjectUtilCore.isExternalStorageEnabled((Project)project);
    }

    @Override
    @NotNull
    protected StateStorage createFileBasedStorage(@NotNull String path, @NotNull String collapsedPath, @NotNull RoamingType roamingType, @Nullable String rootTagName) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return new ModuleFileStorage(this, path2, collapsedPath, rootTagName, roamingType, this.getMacroSubstitutor(collapsedPath), (StreamProvider)(roamingType == RoamingType.DISABLED ? null : this.getCompoundStreamProvider()));
    }

    public ModuleStateStorageManager(@NotNull TrackingPathMacroSubstitutor macroSubstitutor, @NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)macroSubstitutor, (String)"macroSubstitutor");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        super("module", macroSubstitutor, (ComponentManager)module, null, 8, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/ModuleStateStorageManager$ModuleFileStorage;", "Lcom/intellij/configurationStore/StateStorageManagerImpl$MyFileStorage;", "storageManager", "Lcom/intellij/configurationStore/ModuleStateStorageManager;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Lcom/intellij/configurationStore/ModuleStateStorageManager;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/configurationStore/StreamProvider;)V", "loadLocalData", "Lorg/jdom/Element;", "intellij.platform.configurationStore.impl"})
    private static final class ModuleFileStorage
    extends StateStorageManagerImpl.MyFileStorage {
        @Override
        @Nullable
        protected Element loadLocalData() {
            this.setBlockSavingTheContent(false);
            VirtualFile virtualFile = this.getVirtualFile();
            if (virtualFile == null || !virtualFile.exists()) {
                if (this.getStorageDataRef().get() == null && !this.getStorageManager().isExternalSystemStorageEnabled()) {
                    throw (Throwable)new FileNotFoundException(ProjectBundle.message((String)"module.file.does.not.exist.error", (Object[])new Object[]{((Object)this.getFile()).toString()}));
                }
                return null;
            }
            if (virtualFile.getLength() == 0L) {
                this.processReadException(null);
            } else {
                ModuleFileStorage this_$iv = this;
                try {
                    CharBuffer charBuffer;
                    CharBuffer charBuffer2 = charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(virtualFile.contentsToByteArray()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)charBuffer2, (String)"charBuffer");
                    this.setLineSeparator(FileBasedStorageKt.detectLineSeparators(charBuffer2, this.isUseXmlProlog() ? null : LineSeparator.LF));
                    return JdomKt.loadElement((CharSequence)charBuffer);
                }
                catch (JDOMException e$iv) {
                    FileBasedStorage.access$processReadException(this_$iv, (Exception)((Object)e$iv));
                }
                catch (IOException e$iv) {
                    FileBasedStorage.access$processReadException(this_$iv, e$iv);
                }
            }
            return null;
        }

        public ModuleFileStorage(@NotNull ModuleStateStorageManager storageManager2, @NotNull Path file2, @NotNull String fileSpec, @Nullable String rootElementName, @NotNull RoamingType roamingType, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable StreamProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            super(storageManager2, file2, fileSpec, rootElementName, roamingType, pathMacroManager, provider);
        }

        public /* synthetic */ ModuleFileStorage(ModuleStateStorageManager moduleStateStorageManager, Path path, String string, String string2, RoamingType roamingType, PathMacroSubstitutor pathMacroSubstitutor, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                pathMacroSubstitutor = null;
            }
            if ((n & 0x40) != 0) {
                streamProvider = null;
            }
            this(moduleStateStorageManager, path, string, string2, roamingType, pathMacroSubstitutor, streamProvider);
        }
    }
}

