/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectConversionUtil {
    @NonNls
    public static final String PROJECT_FILES_BACKUP = "projectFilesBackup";
    @NonNls
    private static final String BACKUP_EXTENSION = "backup";

    private ProjectConversionUtil() {
    }

    public static File backupFile(File file2) throws IOException {
        String fileName = FileUtil.createSequentFileName((File)file2.getParentFile(), (String)file2.getName(), (String)BACKUP_EXTENSION);
        File backup = new File(file2.getParentFile(), fileName);
        FileUtil.copy((File)file2, (File)backup);
        return backup;
    }

    @NotNull
    public static File backupFiles(Collection<? extends File> files2, File parentDir) throws IOException {
        File backupDir = ProjectConversionUtil.getBackupDir(parentDir);
        ProjectConversionUtil.backupFiles(files2, parentDir, backupDir);
        File file2 = backupDir;
        if (file2 == null) {
            ProjectConversionUtil.$$$reportNull$$$0(0);
        }
        return file2;
    }

    public static void backupFiles(Collection<? extends File> files2, File parentDir, File backupDir) throws IOException {
        backupDir.mkdirs();
        for (File file2 : files2) {
            File target2;
            if (FileUtil.isAncestor((File)parentDir, (File)file2, (boolean)true)) {
                String relativePath = FileUtil.getRelativePath((File)parentDir, (File)file2);
                File target3 = new File(backupDir.getAbsolutePath() + File.separator + relativePath);
                FileUtil.createParentDirs((File)target3);
            } else {
                target2 = new File(backupDir, file2.getName());
            }
            FileUtil.copy((File)file2, (File)target2);
        }
    }

    @NotNull
    public static File getBackupDir(File parentDir) {
        String dirName = FileUtil.createSequentFileName((File)parentDir, (String)PROJECT_FILES_BACKUP, (String)"");
        File file2 = new File(parentDir, dirName);
        if (file2 == null) {
            ProjectConversionUtil.$$$reportNull$$$0(1);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/conversion/impl/ProjectConversionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "backupFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackupDir";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

