/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardFilter;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeStructure
extends AbstractTreeStructureBase {
    private final Project myProject;
    private final List<? extends RunDashboardGrouper> myGroupers;
    private final List<? extends RunDashboardFilter> myFilters;
    private final RunConfigurationsTreeRootNode myRootElement;

    public RunDashboardTreeStructure(@NotNull Project project, @NotNull List<? extends RunDashboardGrouper> groupers, @NotNull List<? extends RunDashboardFilter> filters) {
        if (project == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(0);
        }
        if (groupers == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myGroupers = groupers;
        this.myFilters = filters;
        this.myRootElement = new RunConfigurationsTreeRootNode();
    }

    @Override
    @Nullable
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    @NotNull
    public Object getRootElement() {
        RunConfigurationsTreeRootNode runConfigurationsTreeRootNode = this.myRootElement;
        if (runConfigurationsTreeRootNode == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(3);
        }
        return runConfigurationsTreeRootNode;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    private static Collection<? extends AbstractTreeNode> group(Project project, AbstractTreeNode parent, List<RunDashboardGroupingRule> rules, final List<RunConfigurationNode> nodes) {
        if (rules.isEmpty()) {
            return nodes;
        }
        ArrayList<RunDashboardGroupingRule> remaining = new ArrayList<RunDashboardGroupingRule>(rules);
        RunDashboardGroupingRule rule = (RunDashboardGroupingRule)remaining.remove(0);
        Map<Optional, List<RunConfigurationNode>> groups = nodes.stream().collect(Collectors.groupingBy(node -> Optional.ofNullable(rule.getGroup((AbstractTreeNode)node))));
        ArrayList result2 = new ArrayList();
        ArrayList ungroupedNodes = new ArrayList();
        groups.forEach((group, groupedNodes) -> {
            if (!group.isPresent() || !rule.shouldGroupSingleNodes() && groupedNodes.size() == 1) {
                ungroupedNodes.addAll(RunDashboardTreeStructure.group(project, parent, remaining, groupedNodes));
            } else {
                GroupingNode node = new GroupingNode(project, parent.getValue(), (RunDashboardGroup)group.get());
                node.addChildren(RunDashboardTreeStructure.group(project, node, remaining, groupedNodes));
                result2.add(node);
            }
        });
        if (rule instanceof RunConfigurationDashboardGroupingRule) {
            result2.addAll(ungroupedNodes);
            Collections.sort(result2, new Comparator<AbstractTreeNode>(){

                @Override
                public int compare(AbstractTreeNode n1, AbstractTreeNode n2) {
                    RunConfigurationNode first = this.getNode(n1);
                    RunConfigurationNode second = this.getNode(n2);
                    return nodes.indexOf((Object)first) - nodes.indexOf((Object)second);
                }

                private RunConfigurationNode getNode(AbstractTreeNode node) {
                    Object runConfigurationNode;
                    if (node instanceof GroupingNode) {
                        Optional child2 = node.getChildren().stream().findFirst();
                        assert (child2.isPresent());
                        runConfigurationNode = child2.get();
                    } else {
                        runConfigurationNode = node;
                    }
                    assert (runConfigurationNode instanceof RunConfigurationNode);
                    return (RunConfigurationNode)((Object)runConfigurationNode);
                }
            });
        } else {
            Collections.sort(result2, Comparator.comparing(node -> ((GroupingNode)((Object)node)).getGroup(), rule.getGroupComparator()));
            result2.addAll(ungroupedNodes);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class RunConfigurationsTreeRootNode
    extends AbstractTreeNode<Object> {
        public RunConfigurationsTreeRootNode() {
            super(RunDashboardTreeStructure.this.myProject, new Object());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
            List nodes = runDashboardManager.getRunConfigurations().stream().map(value -> new RunConfigurationNode(this.myProject, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)value, runDashboardManager.getContributor(((RunnerAndConfigurationSettings)value.first).getType()))).filter(node -> RunDashboardTreeStructure.this.myFilters.stream().allMatch(filter -> filter.isVisible((AbstractTreeNode<?>)node))).collect(Collectors.toList());
            List enabledRules = RunDashboardTreeStructure.this.myGroupers.stream().filter(RunDashboardGrouper::isEnabled).map(RunDashboardGrouper::getRule).collect(Collectors.toList());
            Collection collection = RunDashboardTreeStructure.group(this.myProject, this, enabledRules, nodes);
            if (collection == null) {
                RunConfigurationsTreeRootNode.$$$reportNull$$$0(0);
            }
            return collection;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                RunConfigurationsTreeRootNode.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure$RunConfigurationsTreeRootNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure$RunConfigurationsTreeRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

