/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class FeatureUsageEventFileAppender
extends FileAppender {
    protected long maxFileSize;
    private long nextRollover;
    private final Path myLogDirectory;

    public FeatureUsageEventFileAppender(@NotNull Layout layout, @NotNull Path dir, @NotNull String filename) throws IOException {
        if (layout == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(1);
        }
        if (filename == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(2);
        }
        super(layout, filename);
        this.maxFileSize = 0xA00000L;
        this.nextRollover = 0L;
        this.myLogDirectory = dir;
    }

    public static FeatureUsageEventFileAppender create(@NotNull Layout layout, @NotNull Path dir) throws IOException {
        if (layout == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(4);
        }
        File file2 = FeatureUsageEventFileAppender.nextFile(dir);
        return new FeatureUsageEventFileAppender(layout, dir, file2.getPath());
    }

    @NotNull
    public String getActiveLogName() {
        String string = StringUtil.isNotEmpty((String)this.fileName) ? PathUtil.getFileName((String)this.fileName) : "";
        if (string == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    @NotNull
    protected CountingQuietWriter getQuietWriter() {
        CountingQuietWriter countingQuietWriter = (CountingQuietWriter)this.qw;
        if (countingQuietWriter == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(6);
        }
        return countingQuietWriter;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, bufferedIO, bufferSize);
        if (append && this.qw instanceof CountingQuietWriter) {
            File f = new File(fileName);
            this.getQuietWriter().setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = this.getQuietWriter().getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
        }
    }

    public void rollOver() {
        this.nextRollover = this.getQuietWriter().getCount() + this.maxFileSize;
        try {
            File file2 = FeatureUsageEventFileAppender.nextFile(this.myLogDirectory);
            this.setFile(file2.getPath(), false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    @NotNull
    private static File nextFile(@NotNull Path dir) {
        if (dir == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(7);
        }
        File file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        while (file2.exists()) {
            file2 = dir.resolve(UUID.randomUUID() + ".log").toFile();
        }
        File file3 = file2;
        if (file3 == null) {
            FeatureUsageEventFileAppender.$$$reportNull$$$0(8);
        }
        return file3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/FeatureUsageEventFileAppender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/FeatureUsageEventFileAppender";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveLogName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuietWriter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nextFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

