/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.labels.DropDownLink;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelTestAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComponentPanelTestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null) {
            new ComponentPanelTest(project).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction", "actionPerformed"));
    }

    private static class ComponentPanelTest
    extends DialogWrapper {
        private static final HashSet<String> ALLOWED_VALUES = new HashSet<String>(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "abracadabra"));
        private final Alarm myAlarm = new Alarm(this.getDisposable());
        private ProgressTimerRequest progressTimerRequest;
        private JTabbedPane pane;

        private ComponentPanelTest(Project project) {
            super(project);
            this.init();
            this.setTitle("Component Panel Test Action");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            this.pane = new JBTabbedPane(1);
            this.pane.addTab("Component", this.createComponentPanel());
            this.pane.addTab("Component Grid", this.createComponentGridPanel());
            this.pane.addTab("Progress Grid", this.createProgressGridPanel());
            for (int i = 1; i <= 5; ++i) {
                String title = "Blank " + i;
                JLabel label2 = new JLabel(title);
                this.pane.addTab(title, (Component)JBUI.Panels.simplePanel((Component)label2));
            }
            this.pane.addChangeListener(e -> {
                if (this.pane.getSelectedIndex() == 2) {
                    this.myAlarm.addRequest((Runnable)this.progressTimerRequest, 200, ModalityState.any());
                } else {
                    this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest);
                }
            });
            BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)this.pane);
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            JCheckBox enabledCB = new JCheckBox("Enable TabPane", true);
            enabledCB.addActionListener(e -> this.pane.setEnabled(enabledCB.isSelected()));
            southPanel.add(enabledCB);
            southPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
            ComboBox placementCombo = new ComboBox((Object[])Placement.values());
            placementCombo.setSelectedIndex(0);
            placementCombo.addActionListener(arg_0 -> this.lambda$createCenterPanel$2((JComboBox)placementCombo, arg_0));
            southPanel.add((Component)placementCombo);
            southPanel.add(new Box.Filler((Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)0)));
            panel2.addToBottom((Component)southPanel);
            return panel2;
        }

        private JComponent createComponentPanel() {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, (Insets)JBUI.insets((int)5, (int)0), 0, 0);
            final JTextField text1 = new JTextField();
            new ComponentValidator(this.getDisposable()).withValidator(v -> {
                String tt = text1.getText();
                if (StringUtil.isNotEmpty((String)tt)) {
                    try {
                        Integer.parseInt(tt);
                        v.updateInfo(null);
                    }
                    catch (NumberFormatException nex) {
                        v.updateInfo(new ValidationInfo("Enter a number", (JComponent)text1).asWarning());
                    }
                } else {
                    v.updateInfo(null);
                }
            }).installOn((JComponent)text1);
            Dimension d = text1.getPreferredSize();
            text1.setPreferredSize(new Dimension(JBUI.scale((int)100), d.height));
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)text1).withLabel("&Textfield:").withComment("Textfield description").moveCommentRight().createPanel(), gc);
            final JTextField text2 = new JTextField();
            new ComponentValidator(this.getDisposable()).withValidator(v -> {
                String tt = text2.getText();
                v.updateInfo((ValidationInfo)(StringUtil.isEmpty((String)tt) || tt.length() < 5 ? new ValidationInfo("Message is too short.<br/>Should contain at least 5 symbols.", (JComponent)text2) : null));
            }).andStartOnFocusLost().installOn((JComponent)text2);
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)text2).withLabel("&Path:").createPanel(), gc);
            final ComponentPanel cp = ComponentPanel.getComponentPanel((JComponent)text2);
            text1.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String text = text1.getText();
                    if (cp != null) {
                        cp.setCommentText(text);
                    }
                    ComponentValidator.getInstance((JComponent)text1).ifPresent(v -> v.revalidate());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$1", "textChanged"));
                }
            });
            text2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ComponentValidator.getInstance((JComponent)text2).ifPresent(v -> v.revalidate());
                }
            });
            JCheckBox cb1 = new JCheckBox("Scroll tab layout");
            cb1.addActionListener(e -> this.pane.setTabLayoutPolicy(cb1.isSelected() ? 1 : 0));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb1).withComment("Set tabbed pane tabs layout property to SCROLL_TAB_LAYOUT").createPanel(), gc);
            JCheckBox cb2 = new JCheckBox("Full border");
            cb2.addActionListener(e -> this.pane.putClientProperty("JTabbedPane.hasFullBorder", cb2.isSelected()));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb2).withTooltip("Enable full border around the tabbed pane").createPanel(), gc);
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)new JButton("Abracadabra")).withComment("Abradabra comment").resizeX(false).createPanel(), gc);
            String[] items = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel(new JComboBox<String>(items)).withComment("Combobox comment").createPanel(), gc);
            final String[] columns = new String[]{"First column", "Second column"};
            final String[][] data = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"five", "5"}, {"six", "6"}, {"seven", "7"}, {"eight", "8"}, {"nine", "9"}, {"ten", "10"}, {"eleven", "11"}, {"twelve", "12"}, {"thirteen", "13"}, {"fourteen", "14"}, {"fifteen", "15"}, {"sixteen", "16"}};
            JBTable table = new JBTable((TableModel)new DefaultTableModel(){

                @Override
                public String getColumnName(int column) {
                    return columns[column];
                }

                @Override
                public int getRowCount() {
                    return data.length;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Object getValueAt(int row2, int col) {
                    return col == 0 ? data[row2][col] : Integer.valueOf(data[row2][col]);
                }

                @Override
                public boolean isCellEditable(int row2, int column) {
                    return true;
                }

                @Override
                public void setValueAt(Object value, int row2, int col) {
                    if (col == 0 && ALLOWED_VALUES.contains(value.toString()) || col == 1) {
                        data[row2][col] = value.toString();
                        this.fireTableCellUpdated(row2, col);
                    }
                }
            });
            final JTextField cellEditor = new JTextField();
            cellEditor.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
            cellEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    String op = ALLOWED_VALUES.contains(cellEditor.getText()) ? null : "error";
                    cellEditor.putClientProperty("JComponent.outline", op);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$4", "textChanged"));
                }
            });
            TableColumn col0 = table.getColumnModel().getColumn(0);
            col0.setCellEditor(new DefaultCellEditor(cellEditor));
            col0.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    Dimension editorSize = cellEditor.getPreferredSize();
                    size.height = Math.max(size.height, editorSize.height);
                    return size;
                }
            });
            ComboBox rightEditor = new ComboBox((Object[])Arrays.stream(data).map(i -> Integer.valueOf(i[1])).toArray(Integer[]::new));
            table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor((JComboBox<?>)rightEditor));
            JBScrollPane pane = new JBScrollPane((Component)table);
            pane.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
            pane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            BorderLayoutPanel mainPanel = JBUI.Panels.simplePanel((Component)UI.PanelFactory.panel((JComponent)pane).withLabel("Table label:").moveLabelOnTop().withComment("Table comment").resizeY(true).createPanel());
            mainPanel.addToTop((Component)topPanel);
            return mainPanel;
        }

        private JComponent createComponentGridPanel() {
            ComboboxWithBrowseButton cbb = new ComboboxWithBrowseButton(new JComboBox<String>(new String[]{"One", "Two", "Three", "Four"}));
            cbb.addActionListener(e -> System.out.println("Browse for combobox"));
            JBScrollPane pane = new JBScrollPane((Component)new JTextArea(3, 40));
            pane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            DropDownLink linkLabel = new DropDownLink((Object)"Drop down link label", Arrays.asList("Label 1", "Label 2 long long long long long long label", "Label 3", "Label 4", "Label 5", "Label 6"), t -> System.out.println("[" + t + "] selected"), false);
            JPanel p1 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Port:").withComment("Port comment")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Host:").withComment("Host comment")).add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"HTTP", "HTTPS", "FTP", "SSL"})).withLabel("P&rotocol:").withComment("Protocol comment").withTooltip("Protocol selection").withTooltipLink("Check here for more info", () -> System.out.println("More info"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new ComponentWithBrowseButton((JComponent)new JTextField(), e -> System.out.println("Browse for text"))).withLabel("&Text field:").withComment("Text field comment")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)cbb).withLabel("&Combobox selection:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox")).withComment("Checkbox comment text")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)pane).withLabel("Text area:").anchorLabelOn(UI.Anchor.Top).withComment("Text area comment").moveLabelOnTop().withTopRightComponent((JComponent)linkLabel)).createPanel();
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb1 = new JRadioButton("RadioButton 1");
            JRadioButton rb2 = new JRadioButton("RadioButton 2");
            JRadioButton rb3 = new JRadioButton("RadioButton 3");
            bg.add(rb1);
            bg.add(rb2);
            bg.add(rb3);
            rb1.setSelected(true);
            JPanel p2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 1")).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 2")).withComment("Comment 2")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 3")).withTooltip("Checkbox tooltip")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb1).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb2).withComment("Comment 2")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb3).withTooltip("RadioButton tooltip")).createPanel();
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            panel2.add(p1);
            panel2.add(Box.createVerticalStrut(JBUI.scale((int)5)));
            panel2.add(p2);
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createProgressGridPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            JProgressBar pb1 = new JProgressBar(0, 100);
            JProgressBar pb2 = new JProgressBar(0, 100);
            this.progressTimerRequest = new ProgressTimerRequest(pb1);
            ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)pb1);
            if (progressPanel != null) {
                progressPanel.setCommentText(Integer.toString(0));
            }
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb1).withLabel("Label 1.1").withCancel(() -> this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest)).andCancelText("Stop")).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb2).withLabel("Label 1.2").withPause(() -> System.out.println("Pause action #2")).withResume(() -> System.out.println("Resume action #2"))).resize().createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb1))).setCommentText("Long long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb2))).setCommentText("Short text");
            JProgressBar pb3 = new JProgressBar(0, 100);
            JProgressBar pb4 = new JProgressBar(0, 100);
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb3).withLabel("Label 2.1").moveLabelLeft().withCancel(() -> System.out.println("Cancel action #3"))).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb4).withTopSeparator().withLabel("Label 2.2").moveLabelLeft().withPause(() -> System.out.println("Pause action #4")).withResume(() -> System.out.println("Resume action #4"))).resize().createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb3))).setCommentText("Long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb4))).setCommentText("Short text");
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().andCancelAsButton().withCancel(() -> System.out.println("Cancel action #11"))).createPanel());
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private /* synthetic */ void lambda$createCenterPanel$2(JComboBox placementCombo, ActionEvent e) {
            Placement p = (Placement)((Object)placementCombo.getSelectedItem());
            if (p != null) {
                this.pane.setTabPlacement(p.placement());
            }
        }

        private class ProgressTimerRequest
        implements Runnable {
            private final JProgressBar myProgressBar;

            private ProgressTimerRequest(JProgressBar progressBar) {
                this.myProgressBar = progressBar;
            }

            @Override
            public void run() {
                if (this.canPlay()) {
                    int v = this.myProgressBar.getValue() + 1;
                    if (v > this.myProgressBar.getMaximum()) {
                        v = this.myProgressBar.getMinimum();
                    }
                    this.myProgressBar.setValue(v);
                    ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                    if (progressPanel != null) {
                        progressPanel.setCommentText(Integer.toString(v));
                    }
                    ComponentPanelTest.this.myAlarm.addRequest((Runnable)this, 200, ModalityState.any());
                }
            }

            private boolean canPlay() {
                ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                return progressPanel != null && progressPanel.getState() == ProgressPanel.State.PLAYING;
            }
        }
    }

    private static enum Placement {
        Top(1, "Top"),
        Bottom(3, "Bottom"),
        Left(2, "Left"),
        Right(4, "Right");

        private final String name;
        private final int placement;

        private Placement(int placement, String name) {
            this.name = name;
            this.placement = placement;
        }

        public String toString() {
            return this.name;
        }

        public int placement() {
            return this.placement;
        }
    }
}

