/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Nullable
    public Project guessProjectForFile(@Nullable VirtualFile file2) {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project == null && file2 != null) {
            project = ProjectLocatorImpl.getPreferredProject((VirtualFile)file2);
        }
        if (project != null && !project.isDisposed()) {
            return project;
        }
        if (file2 == null) {
            return null;
        }
        return (Project)ReadAction.compute(() -> {
            Project[] openProjects;
            ProjectManager projectManager2 = ProjectManager.getInstance();
            if (projectManager2 == null) {
                return null;
            }
            for (Project openProject : openProjects = projectManager2.getOpenProjects()) {
                if (!openProject.isInitialized() || openProject.isDisposed() || !ProjectRootManager.getInstance((Project)openProject).getFileIndex().isInContent(file2)) continue;
                return openProject;
            }
            return null;
        });
    }

    @NotNull
    public Collection<Project> getProjectsForFile(VirtualFile file2) {
        ProjectManager projectManager2 = ProjectManager.getInstance();
        if (projectManager2 == null || file2 == null) {
            List<Project> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Project[] openProjects = projectManager2.getOpenProjects();
        if (openProjects.length == 0) {
            List<Project> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(1);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        for (Project project : openProjects) {
            if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file2)) continue;
            result2.add(project);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
    }
}

