/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TreeItem;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithSelectedRevisionAction
extends AbstractVcsAction {
    private static final ColumnInfo<TreeNodeAdapter, String> BRANCH_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getBranchName();
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> REVISION_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getRevisionNumber().asString();
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> DATE_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.filter", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return DateFormatUtil.formatPrettyDateTime((Date)object.getRevision().getRevisionDate());
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> AUTHOR_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getAuthor();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> REVISION_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getRevisionNumber().asString();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> DATE_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            Date date = vcsFileRevision.getRevisionDate();
            return date == null ? "" : DateFormatUtil.formatPrettyDateTime((Date)date);
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> AUTHOR_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getAuthor();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> BRANCH_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getBranchName();
        }
    };

    @Override
    public void update(@NotNull VcsContext e, @NotNull Presentation presentation) {
        if (e == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(1);
        }
        AbstractShowDiffAction.updateDiffAction(presentation, e);
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = vcsContext.getSelectedFiles()[0];
        Project project = vcsContext.getProject();
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.notNull((Object)ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2));
        VcsCachingHistory.collectInBackground(vcs, VcsUtil.getFilePath((VirtualFile)file2), VcsBackgroundableActions.COMPARE_WITH, (Consumer<VcsHistorySession>)((Consumer)session2 -> {
            if (session2 == null) {
                return;
            }
            List revisions = session2.getRevisionList();
            HistoryAsTreeProvider treeHistoryProvider = session2.getHistoryAsTreeProvider();
            if (treeHistoryProvider != null) {
                CompareWithSelectedRevisionAction.showTreePopup(treeHistoryProvider.createTreeOn(revisions), file2, project, vcs.getDiffProvider());
            } else {
                CompareWithSelectedRevisionAction.showListPopup(revisions, project, (Consumer<? super VcsFileRevision>)((Consumer)revision -> DiffActionExecutor.showDiff(vcs.getDiffProvider(), revision.getRevisionNumber(), file2, project)), true);
            }
        }));
    }

    private static void showTreePopup(List<TreeItem<VcsFileRevision>> roots, VirtualFile file2, Project project, DiffProvider diffProvider) {
        TreeTableView treeTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)new TreeNodeAdapter(null, null, roots), new ColumnInfo[]{BRANCH_COLUMN, REVISION_COLUMN, DATE_COLUMN, AUTHOR_COLUMN}));
        Runnable runnable2 = () -> {
            int index = treeTable.getSelectionModel().getMinSelectionIndex();
            if (index == -1) {
                return;
            }
            VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
            if (revision != null) {
                DiffActionExecutor.showDiff(diffProvider, revision.getRevisionNumber(), file2, project);
            }
        };
        treeTable.setSelectionMode(0);
        new PopupChooserBuilder((JTable)treeTable).setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable2).setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel(treeTable)).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").createPopup().showCenteredInCurrentWindow(project);
        int lastRow = treeTable.getRowCount() - 1;
        if (lastRow < 0) {
            return;
        }
        treeTable.getSelectionModel().addSelectionInterval(lastRow, lastRow);
        treeTable.scrollRectToVisible(treeTable.getCellRect(lastRow, 0, true));
    }

    @Nullable
    private static VcsFileRevision getRevisionAt(TreeTableView treeTable, int index) {
        List items = treeTable.getItems();
        if (items.size() <= index) {
            return null;
        }
        return ((TreeNodeAdapter)items.get(index)).getRevision();
    }

    private static JPanel createCommentsPanel(final TreeTableView treeTable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                int index;
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                if ((index = treeTable.getSelectionModel().getMinSelectionIndex()) == -1) {
                    textArea.setText("");
                } else {
                    VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
                    if (revision != null) {
                        textArea.setText(revision.getCommitMessage());
                    } else {
                        textArea.setText("");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$9", "valueChanged"));
            }
        });
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        panel2.add((Component)textScrollPane, "Center");
        textScrollPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]), (boolean)false));
        return panel2;
    }

    private static JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setRows(5);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        return textArea;
    }

    public static void showListPopup(final List<VcsFileRevision> revisions, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer, boolean showComments) {
        ColumnInfo[] columns = new ColumnInfo[]{REVISION_TABLE_COLUMN, DATE_TABLE_COLUMN, AUTHOR_TABLE_COLUMN};
        for (VcsFileRevision revision : revisions) {
            if (revision.getBranchName() == null) continue;
            columns = new ColumnInfo[]{REVISION_TABLE_COLUMN, BRANCH_TABLE_COLUMN, DATE_TABLE_COLUMN, AUTHOR_TABLE_COLUMN};
            break;
        }
        final TableView table = new TableView(new ListTableModel(columns, revisions, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable2 = () -> {
            VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        new SpeedSearchBase<TableView>(table){

            @Override
            protected int getSelectedIndex() {
                return table.getSelectedRow();
            }

            @Override
            protected int convertIndexToModel(int viewIndex) {
                return table.convertRowIndexToModel(viewIndex);
            }

            @Override
            @NotNull
            protected Object[] getAllElements() {
                Object[] objectArray = revisions.toArray();
                if (objectArray == null) {
                    10.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Override
            protected String getElementText(Object element) {
                VcsFileRevision revision = (VcsFileRevision)element;
                return revision.getRevisionNumber().asString() + " " + revision.getBranchName() + " " + revision.getAuthor();
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                VcsFileRevision revision = (VcsFileRevision)element;
                TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TableView)this.myComponent).convertRowIndexToView(revisions.indexOf(revision))});
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$10", "getAllElements"));
            }
        };
        table.setMinimumSize((Dimension)new JBDimension(300, 50));
        PopupChooserBuilder builder2 = new PopupChooserBuilder((JTable)table);
        if (showComments) {
            builder2.setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel((TableView<VcsFileRevision>)table));
        }
        builder2.setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable2).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").setMinSize((Dimension)new JBDimension(300, 300));
        JBPopup popup2 = builder2.createPopup();
        popup2.showCenteredInCurrentWindow(project);
    }

    private static JPanel createCommentsPanel(final TableView<VcsFileRevision> table) {
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                VcsFileRevision revision;
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                if ((revision = (VcsFileRevision)table.getSelectedObject()) == null) {
                    textArea.setText("");
                } else {
                    textArea.setText(revision.getCommitMessage());
                    textArea.select(0, 0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$11", "valueChanged"));
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]));
        jPanel.add((Component)commentLabel, "North");
        commentLabel.setBorder(IdeBorderFactory.createBorder((int)11));
        textScrollPane.setBorder(null);
        jPanel.add((Component)textScrollPane, "Center");
        jPanel.setPreferredSize((Dimension)new JBDimension(300, 100));
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TreeNodeAdapter
    extends DefaultMutableTreeNode {
        private final TreeItem<VcsFileRevision> myRevision;

        TreeNodeAdapter(TreeNodeAdapter parent, TreeItem<VcsFileRevision> revision, List<TreeItem<VcsFileRevision>> children2) {
            if (parent != null) {
                parent.add(this);
            }
            this.myRevision = revision;
            for (TreeItem<VcsFileRevision> treeItem : children2) {
                new TreeNodeAdapter(this, treeItem, treeItem.getChildren());
            }
        }

        public VcsFileRevision getRevision() {
            return (VcsFileRevision)this.myRevision.getData();
        }
    }
}

