/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListsIndexes");
    private final Map<FilePath, Data> myMap;
    private final TreeSet<FilePath> myAffectedPaths;
    private final Set<Change> myChanges;

    public ChangeListsIndexes() {
        this.myMap = new HashMap<FilePath, Data>();
        this.myAffectedPaths = new TreeSet<FilePath>(HierarchicalFilePathComparator.SYSTEM_CASE_SENSITIVE);
        this.myChanges = new HashSet<Change>();
    }

    public ChangeListsIndexes(@NotNull ChangeListsIndexes idx) {
        if (idx == null) {
            ChangeListsIndexes.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<FilePath, Data>(idx.myMap);
        this.myAffectedPaths = new TreeSet<FilePath>((SortedSet<FilePath>)idx.myAffectedPaths);
        this.myChanges = new HashSet<Change>(idx.myChanges);
    }

    public void copyFrom(@NotNull ChangeListsIndexes idx) {
        if (idx == null) {
            ChangeListsIndexes.$$$reportNull$$$0(1);
        }
        this.myMap.clear();
        this.myAffectedPaths.clear();
        this.myChanges.clear();
        this.myMap.putAll(idx.myMap);
        this.myAffectedPaths.addAll(idx.myAffectedPaths);
        this.myChanges.addAll(idx.myChanges);
    }

    private void add(@NotNull FilePath file2, @NotNull FileStatus status, @Nullable AbstractVcs key, @NotNull VcsRevisionNumber number) {
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(2);
        }
        if (status == null) {
            ChangeListsIndexes.$$$reportNull$$$0(3);
        }
        if (number == null) {
            ChangeListsIndexes.$$$reportNull$$$0(4);
        }
        this.myMap.put(file2, new Data(status, key, number));
        this.myAffectedPaths.add(file2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status + " for " + file2);
        }
    }

    private void remove(FilePath file2) {
        this.myMap.remove(file2);
        this.myAffectedPaths.remove(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(5);
        }
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file2));
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        Data data;
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(6);
        }
        return (data = this.myMap.get(file2)) != null ? data.status : null;
    }

    public void changeAdded(@NotNull Change change, AbstractVcs key) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(7);
        }
        this.myChanges.add(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null && afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key, beforeRevision.getRevisionNumber());
            if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                this.add(beforeRevision.getFile(), FileStatus.DELETED, key, beforeRevision.getRevisionNumber());
            }
        } else if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key, VcsRevisionNumber.NULL);
        } else if (beforeRevision != null) {
            this.add(beforeRevision.getFile(), change.getFileStatus(), key, beforeRevision.getRevisionNumber());
        }
    }

    public void changeRemoved(@NotNull Change change) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(8);
        }
        this.myChanges.remove(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    @NotNull
    public Set<Change> getChanges() {
        Set<Change> set = this.myChanges;
        if (set == null) {
            ChangeListsIndexes.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        AbstractVcs vcs;
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(10);
        }
        if ((vcs = this.getVcsForRevision(change.getAfterRevision())) != null) {
            return vcs;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private AbstractVcs getVcsForRevision(@Nullable ContentRevision revision) {
        if (revision != null) {
            Data data = this.myMap.get(revision.getFile());
            return data != null ? data.vcs : null;
        }
        return null;
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<BaseRevision> toRemove2, Set<BaseRevision> toAdd, Set<BeforeAfter<BaseRevision>> toModify) {
        FilePath s;
        Map<FilePath, Data> oldMap = this.myMap;
        Map<FilePath, Data> newMap = newIndexes.myMap;
        for (Map.Entry<FilePath, Data> entry : oldMap.entrySet()) {
            s = entry.getKey();
            Data oldData = entry.getValue();
            Data newData = newMap.get(s);
            if (newData != null) {
                if (oldData.sameRevisions(newData)) continue;
                toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.createBaseRevision(s, oldData), (Object)ChangeListsIndexes.createBaseRevision(s, newData)));
                continue;
            }
            toRemove2.add(ChangeListsIndexes.createBaseRevision(s, oldData));
        }
        for (Map.Entry<FilePath, Data> entry : newMap.entrySet()) {
            s = entry.getKey();
            Data newData = entry.getValue();
            if (oldMap.containsKey(s)) continue;
            toAdd.add(ChangeListsIndexes.createBaseRevision(s, newData));
        }
    }

    @NotNull
    public ThreeState haveChangesUnder(@NotNull FilePath dir) {
        FilePath changeCandidate;
        if (dir == null) {
            ChangeListsIndexes.$$$reportNull$$$0(11);
        }
        if ((changeCandidate = this.myAffectedPaths.ceiling(dir)) == null) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ChangeListsIndexes.$$$reportNull$$$0(12);
            }
            return threeState;
        }
        ThreeState threeState = FileUtil.isAncestorThreeState((String)dir.getPath(), (String)changeCandidate.getPath(), (boolean)false);
        if (threeState == null) {
            ChangeListsIndexes.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    private static BaseRevision createBaseRevision(@NotNull FilePath path, @NotNull Data data) {
        if (path == null) {
            ChangeListsIndexes.$$$reportNull$$$0(14);
        }
        if (data == null) {
            ChangeListsIndexes.$$$reportNull$$$0(15);
        }
        return new BaseRevision(data.vcs, data.revision, path);
    }

    public void clear() {
        this.myMap.clear();
        this.myAffectedPaths.clear();
        this.myChanges.clear();
    }

    @NotNull
    public Set<FilePath> getAffectedPaths() {
        Set<FilePath> set = Collections.unmodifiableSet(this.myMap.keySet());
        if (set == null) {
            ChangeListsIndexes.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeAdded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeRemoved";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBaseRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        @NotNull
        public final FileStatus status;
        public final AbstractVcs vcs;
        @NotNull
        public final VcsRevisionNumber revision;

        Data(@NotNull FileStatus status, AbstractVcs vcs, @NotNull VcsRevisionNumber revision) {
            if (status == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.status = status;
            this.vcs = vcs;
            this.revision = revision;
        }

        public boolean sameRevisions(@NotNull Data data) {
            if (data == null) {
                Data.$$$reportNull$$$0(2);
            }
            return Comparing.equal((Object)this.vcs, (Object)data.vcs) && Comparing.equal((Object)this.revision, (Object)data.revision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sameRevisions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

