/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.availability;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.availability.PsiAvailabilityService;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAvailabilityServiceImpl
extends PsiAvailabilityService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.availability.PsiAvailabilityServiceImpl");
    private final Project myProject;
    private final PsiDocumentManager myDocumentManager;

    public PsiAvailabilityServiceImpl(Project project) {
        this.myProject = project;
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
    }

    @Override
    public boolean makePsiAvailable(final @NotNull Document document, @Nls @NotNull String progressTitle) {
        if (document == null) {
            PsiAvailabilityServiceImpl.$$$reportNull$$$0(0);
        }
        if (progressTitle == null) {
            PsiAvailabilityServiceImpl.$$$reportNull$$$0(1);
        }
        final Ref success2 = Ref.create((Object)false);
        new Task.Modal(this.myProject, progressTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Semaphore semaphore = new Semaphore(1);
                ApplicationManager.getApplication().invokeLater(() -> PsiAvailabilityServiceImpl.this.myDocumentManager.performWhenAllCommitted(() -> semaphore.up()));
                while (!semaphore.waitFor(50L)) {
                    indicator.checkCanceled();
                }
                success2.set(ReadAction.compute(() -> {
                    if (document == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return PsiAvailabilityServiceImpl.this.ensureParsed(document);
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/availability/PsiAvailabilityServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$2";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        return (Boolean)success2.get();
    }

    @Override
    public void performWhenPsiAvailable(@NotNull Document document, @NotNull Runnable callback2, @Nullable ProgressIndicator indicator) {
        if (document == null) {
            PsiAvailabilityServiceImpl.$$$reportNull$$$0(2);
        }
        if (callback2 == null) {
            PsiAvailabilityServiceImpl.$$$reportNull$$$0(3);
        }
        new MyTask(document, callback2, indicator).rescheduleIfNeeded();
    }

    private boolean ensureParsed(@NotNull Document document) {
        PsiFile baseFile;
        if (document == null) {
            PsiAvailabilityServiceImpl.$$$reportNull$$$0(4);
        }
        LOG.trace("ensureParsed");
        if (this.myDocumentManager.isCommitted(document) && (baseFile = this.myDocumentManager.getPsiFile(document)) != null) {
            for (PsiFile file2 : baseFile.getViewProvider().getAllFiles()) {
                ProgressManager.checkCanceled();
                file2.getNode().getFirstChildNode();
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/availability/PsiAvailabilityServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "makePsiAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performWhenPsiAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureParsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ParsedState {
        Obsolete,
        Uncommitted,
        NotParsed,
        Parsed;

    }

    private class MyTask {
        private final Document myDocument;
        private final long myOriginalStamp;
        private final Runnable myAction;
        private final ProgressIndicator myOriginalIndicator;

        private MyTask(Document document, Runnable action, ProgressIndicator indicator) {
            this.myDocument = document;
            this.myOriginalStamp = document.getModificationStamp();
            this.myAction = action;
            this.myOriginalIndicator = indicator == null ? new ProgressIndicatorBase() : indicator;
        }

        private boolean isObsolete(ProgressIndicator indicator) {
            return PsiAvailabilityServiceImpl.this.myProject.isDisposed() || indicator.isCanceled() || this.myDocument.getModificationStamp() != this.myOriginalStamp;
        }

        void rescheduleIfNeeded() {
            LOG.trace("rescheduleIfNeeded");
            switch (this.getParsedState(this.myOriginalIndicator)) {
                case Obsolete: {
                    return;
                }
                case Parsed: {
                    this.myAction.run();
                    return;
                }
            }
            PsiAvailabilityServiceImpl.this.myDocumentManager.performForCommittedDocument(this.myDocument, () -> ApplicationManager.getApplication().invokeLater(() -> {
                switch (this.getParsedState(this.myOriginalIndicator)) {
                    case Obsolete: {
                        return;
                    }
                    case Uncommitted: {
                        this.rescheduleIfNeeded();
                        return;
                    }
                    case NotParsed: {
                        break;
                    }
                    case Parsed: {
                        this.myAction.run();
                        return;
                    }
                }
                LOG.trace("scheduling background task");
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(new SensitiveProgressWrapper(this.myOriginalIndicator), new ReadTask(){

                    @Override
                    @Nullable
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (MyTask.this.isObsolete(indicator)) {
                            return null;
                        }
                        if (PsiAvailabilityServiceImpl.this.ensureParsed(MyTask.this.myDocument)) {
                            return new ReadTask.Continuation(() -> {
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                switch (MyTask.this.getParsedState(indicator)) {
                                    case Obsolete: {
                                        break;
                                    }
                                    case Uncommitted: 
                                    case NotParsed: {
                                        MyTask.this.rescheduleIfNeeded();
                                        break;
                                    }
                                    case Parsed: {
                                        MyTask.this.myAction.run();
                                    }
                                }
                            });
                        }
                        return null;
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        MyTask.this.rescheduleIfNeeded();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "indicator";
                        objectArray2[1] = "com/intellij/psi/availability/PsiAvailabilityServiceImpl$MyTask$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "performInReadAction";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onCanceled";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$performInReadAction$0";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }));
        }

        ParsedState getParsedState(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            if (this.isObsolete(indicator)) {
                return ParsedState.Obsolete;
            }
            PsiFile baseFile = PsiAvailabilityServiceImpl.this.myDocumentManager.getPsiFile(this.myDocument);
            if (baseFile == null) {
                return ParsedState.Obsolete;
            }
            if (PsiAvailabilityServiceImpl.this.myDocumentManager.isUncommited(this.myDocument)) {
                return ParsedState.Uncommitted;
            }
            for (PsiFile file2 : baseFile.getViewProvider().getAllFiles()) {
                if (file2.getNode() == null || file2.getNode().isParsed()) continue;
                return ParsedState.NotParsed;
            }
            return ParsedState.Parsed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/availability/PsiAvailabilityServiceImpl$MyTask", "getParsedState"));
        }
    }
}

