/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private final Map<RemoteServer<?>, ServerConnection> myConnections = new HashMap();
    private final ServerConnectionEventDispatcher myEventDispatcher = new ServerConnectionEventDispatcher();

    @NotNull
    public <C extends ServerConfiguration> ServerConnection getOrCreateConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ServerConnection connection = this.myConnections.get(server);
        if (connection == null) {
            connection = this.doCreateConnection(server, this);
            this.myConnections.put(server, connection);
            this.myEventDispatcher.fireConnectionCreated(connection);
        }
        ServerConnection serverConnection = connection;
        if (serverConnection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(1);
        }
        return serverConnection;
    }

    @NotNull
    public <C extends ServerConfiguration> ServerConnection createTemporaryConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(2);
        }
        ServerConnection serverConnection = this.doCreateConnection(server, null);
        if (serverConnection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(3);
        }
        return serverConnection;
    }

    private <C extends ServerConfiguration> ServerConnection doCreateConnection(@NotNull RemoteServer<C> server, ServerConnectionManagerImpl manager) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(4);
        }
        ServerTaskExecutorImpl executor = new ServerTaskExecutorImpl();
        return new ServerConnectionImpl(server, server.getType().createConnector(server, (ServerTaskExecutor)executor), manager, this.getEventDispatcher());
    }

    @Nullable
    public <C extends ServerConfiguration> ServerConnection getConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(5);
        }
        return this.myConnections.get(server);
    }

    public void removeConnection(RemoteServer<?> server) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myConnections.remove(server);
    }

    public ServerConnectionEventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    @NotNull
    public Collection<ServerConnection> getConnections() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<ServerConnection> collection = Collections.unmodifiableCollection(this.myConnections.values());
        if (collection == null) {
            ServerConnectionManagerImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryConnection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateConnection";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryConnection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConnection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

