/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ExpandableEditorSupport
extends ExpandableSupport<EditorTextField> {
    public ExpandableEditorSupport(@NotNull EditorTextField field) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(0);
        }
        super((JComponent)((Object)field), null, null);
        field.addSettingsProvider(editor -> {
            if (field == null) {
                ExpandableEditorSupport.$$$reportNull$$$0(9);
            }
            this.initFieldEditor(editor, field.getBackground());
            this.updateFieldFolding(editor);
        });
    }

    protected void initPopupEditor(@NotNull EditorEx editor, Color background) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(1);
        }
        JLabel label2 = ExpandableSupport.createLabel((ExtendableTextComponent.Extension)this.createCollapseExtension());
        label2.setBorder((Border)JBUI.Borders.empty((int)5, (int)3, (int)5, (int)7));
        editor.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        editor.getScrollPane().setHorizontalScrollBarPolicy(30);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.getScrollPane().getVerticalScrollBar().setBackground(background);
        editor.getScrollPane().getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label2);
        editor.getScrollPane().setViewportBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        label2.setOpaque(true);
    }

    protected void initFieldEditor(@NotNull EditorEx editor, Color background) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(2);
        }
        editor.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        ExtendableTextComponent.Extension extension = this.createExpandExtension();
        ExtendableEditorSupport.setupExtension(editor, background, extension);
    }

    protected void updateFieldFolding(@NotNull EditorEx editor) {
        if (editor == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(3);
        }
        FoldingModelEx model = editor.getFoldingModel();
        CharSequence text = editor.getDocument().getCharsSequence();
        model.runBatchFoldingOperation(() -> {
            model.clearFoldRegions();
            for (int i = 0; i < text.length(); ++i) {
                FoldRegion region;
                if (text.charAt(i) != '\n' || (region = model.createFoldRegion(i, i + 1, " \u23ce ", null, true)) == null) continue;
                region.setExpanded(false);
            }
        });
    }

    @NotNull
    protected ExpandableSupport.Content prepare(final @NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(4);
        }
        if (onShow == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(5);
        }
        final EditorTextField popup2 = new EditorTextField((String)onShow.fun((Object)field.getText()));
        Color background = field.getBackground();
        popup2.setBackground(background);
        popup2.setOneLineMode(false);
        popup2.setPreferredSize(new Dimension(field.getWidth(), 5 * field.getHeight()));
        popup2.addSettingsProvider(editor -> {
            if (field == null) {
                ExpandableEditorSupport.$$$reportNull$$$0(8);
            }
            this.initPopupEditor(editor, background);
            ExpandableEditorSupport.copyCaretPosition(editor, field.getEditor());
        });
        ExpandableSupport.Content content = new ExpandableSupport.Content(){

            @NotNull
            public JComponent getContentComponent() {
                EditorTextField editorTextField = popup2;
                if (editorTextField == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorTextField;
            }

            public JComponent getFocusableComponent() {
                return popup2;
            }

            public void cancel(@NotNull Function<? super String, String> onHide) {
                if (onHide == null) {
                    1.$$$reportNull$$$0(1);
                }
                field.setText((String)onHide.fun((Object)popup2.getText()));
                Editor editor = field.getEditor();
                if (editor != null) {
                    ExpandableEditorSupport.copyCaretPosition(editor, popup2.getEditor());
                }
                if (editor instanceof EditorEx) {
                    ExpandableEditorSupport.this.updateFieldFolding((EditorEx)editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onHide";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cancel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (content == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(6);
        }
        return content;
    }

    private static void copyCaretPosition(@NotNull Editor destination, Editor source) {
        if (destination == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(7);
        }
        if (source == null) {
            return;
        }
        try {
            destination.getCaretModel().setCaretsAndSelections(source.getCaretModel().getCaretsAndSelections());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ExpandableEditorSupport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initPopupEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initFieldEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateFieldFolding";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyCaretPosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepare$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

