/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ElementProducer;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionModelEditor<T, E extends CollectionItemEditor<T>>
implements ElementProducer<T> {
    protected static final Logger LOG = Logger.getInstance(CollectionModelEditor.class);
    protected final E itemEditor;
    protected final ModelHelper helper;

    protected CollectionModelEditor(@NotNull E itemEditor) {
        if (itemEditor == null) {
            CollectionModelEditor.$$$reportNull$$$0(0);
        }
        this.helper = new ModelHelper();
        this.itemEditor = itemEditor;
    }

    public T createElement() {
        return (T)ReflectionUtil.newInstance(this.itemEditor.getItemClass());
    }

    public boolean canCreateElement() {
        return true;
    }

    @NotNull
    protected abstract List<T> getItems();

    public void reset(@NotNull List<T> originalItems) {
        if (originalItems == null) {
            CollectionModelEditor.$$$reportNull$$$0(1);
        }
        this.helper.reset(originalItems);
    }

    public final boolean isModified() {
        List<T> items = this.getItems();
        OrderedSet oldItems = this.helper.originalItems;
        if (items.size() != oldItems.size()) {
            return true;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            if (items.get(i).equals(oldItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public void processModifiedItems(final @NotNull PairProcessor<T, T> processor2) {
        if (processor2 == null) {
            CollectionModelEditor.$$$reportNull$$$0(2);
        }
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                return processor2.process(newItem, oldItem);
            }
        });
    }

    @NotNull
    public final T getMutable(@NotNull T item) {
        if (item == null) {
            CollectionModelEditor.$$$reportNull$$$0(3);
        }
        Object t = this.helper.getMutable(item, -1);
        if (t == null) {
            CollectionModelEditor.$$$reportNull$$$0(4);
        }
        return t;
    }

    protected boolean isEditable(@NotNull T item) {
        if (item == null) {
            CollectionModelEditor.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        if (oldItem == null) {
            CollectionModelEditor.$$$reportNull$$$0(6);
        }
        if (newItem == null) {
            CollectionModelEditor.$$$reportNull$$$0(7);
        }
        List<T> items = this.getItems();
        items.set(index == -1 ? ContainerUtil.indexOfIdentity(items, oldItem) : index, newItem);
    }

    protected final boolean areSelectedItemsRemovable(@NotNull ListSelectionModel selectionMode) {
        if (selectionMode == null) {
            CollectionModelEditor.$$$reportNull$$$0(8);
        }
        int minSelectionIndex = selectionMode.getMinSelectionIndex();
        int maxSelectionIndex = selectionMode.getMaxSelectionIndex();
        if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
            return false;
        }
        List<T> items = this.getItems();
        for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
            if (!this.itemEditor.isRemovable(items.get(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalItems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/CollectionModelEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/CollectionModelEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processModifiedItems";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMutable";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "silentlyReplaceItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areSelectedItemsRemovable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ModelHelper {
        final OrderedSet<T> originalItems = new OrderedSet(ContainerUtil.identityStrategy());
        private final THashMap<T, T> modifiedToOriginal = ContainerUtil.newIdentityTroveMap();
        private final THashMap<T, T> originalToModified = ContainerUtil.newIdentityTroveMap();

        protected ModelHelper() {
        }

        public void reset(@Nullable List<T> newOriginalItems) {
            if (newOriginalItems != null) {
                this.originalItems.clear();
                this.originalItems.addAll(newOriginalItems);
            }
            this.modifiedToOriginal.clear();
            this.originalToModified.clear();
        }

        public void remove(@NotNull T item) {
            Object original;
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(0);
            }
            if ((original = this.modifiedToOriginal.remove(item)) != null) {
                this.originalToModified.remove(original);
            }
        }

        public boolean isMutable(@NotNull T item) {
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(1);
            }
            return this.modifiedToOriginal.containsKey(item) || !this.originalItems.contains(item);
        }

        @NotNull
        public T getMutable(@NotNull T item, int index) {
            if (item == null) {
                ModelHelper.$$$reportNull$$$0(2);
            }
            if (this.isMutable(item) || !CollectionModelEditor.this.isEditable(item)) {
                Object t = item;
                if (t == null) {
                    ModelHelper.$$$reportNull$$$0(3);
                }
                return t;
            }
            Object mutable = this.originalToModified.get(item);
            if (mutable == null) {
                mutable = CollectionModelEditor.this.itemEditor.clone(item, false);
                this.modifiedToOriginal.put(mutable, item);
                this.originalToModified.put(item, mutable);
                CollectionModelEditor.this.silentlyReplaceItem(item, mutable, index);
            }
            Object object = mutable;
            if (object == null) {
                ModelHelper.$$$reportNull$$$0(4);
            }
            return object;
        }

        public boolean hasModifiedItems() {
            return !this.modifiedToOriginal.isEmpty();
        }

        public void process(@NotNull TObjectObjectProcedure<T, T> procedure) {
            if (procedure == null) {
                ModelHelper.$$$reportNull$$$0(5);
            }
            this.modifiedToOriginal.forEachEntry(procedure);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/CollectionModelEditor$ModelHelper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "procedure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/CollectionModelEditor$ModelHelper";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isMutable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMutable";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

