/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDocumentationProvider
implements DocumentationProvider {
    private static final Key<XmlElementDescriptor> DESCRIPTOR_KEY = Key.create((String)"Original element");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.documentation.XmlDocumentationProvider");
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String BASE_SITEPOINT_URL = "http://reference.sitepoint.com/html/";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof SchemaPrefix) {
            return ((SchemaPrefix)element).getQuickNavigateInfo();
        }
        if (element instanceof XmlEntityDecl) {
            XmlAttributeValue value = ((XmlEntityDecl)element).getValueElement();
            return value != null ? value.getText() : null;
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (element instanceof XmlTag) {
            XmlTag declaration;
            XmlTag tag = (XmlTag)element;
            MyPsiElementProcessor processor2 = new MyPsiElementProcessor();
            XmlUtil.processXmlElements((XmlElement)tag, processor2, true);
            if (processor2.url == null && (declaration = XmlDocumentationProvider.getComplexOrSimpleTypeDefinition(element, originalElement)) != null) {
                XmlUtil.processXmlElements((XmlElement)declaration, processor2, true);
            }
            return processor2.url != null ? Collections.singletonList(processor2.url) : null;
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (element instanceof XmlElementDecl) {
            PsiElement curElement = XmlUtil.findPreviousComment(element);
            if (curElement != null) {
                return this.formatDocFromComment(curElement, ((XmlElementDecl)element).getNameElement().getText());
            }
        } else {
            if (element instanceof XmlTag) {
                PsiElement comment;
                XmlTag declaration;
                XmlTag tag = (XmlTag)element;
                MyPsiElementProcessor processor2 = new MyPsiElementProcessor();
                String name = tag.getAttributeValue(NAME_ATTR_NAME);
                String typeName = null;
                if (originalElement != null && originalElement.getParent() instanceof XmlAttributeValue) {
                    XmlTag enumerationTag;
                    XmlAttributeValue value = (XmlAttributeValue)originalElement.getParent();
                    String toSearch = value.getValue();
                    if ("enumeration".equals(tag.getLocalName())) {
                        enumerationTag = tag;
                        name = enumerationTag.getAttributeValue("value");
                    } else {
                        enumerationTag = XmlDocumentationProvider.findEnumerationValue(toSearch, tag);
                        name = toSearch;
                    }
                    if (enumerationTag != null) {
                        XmlUtil.processXmlElements((XmlElement)enumerationTag, processor2, true);
                        if (processor2.result != null) {
                            typeName = XmlBundle.message((String)"xml.javadoc.enumeration.value.message", (Object[])new Object[0]);
                        }
                    }
                }
                if (processor2.result == null) {
                    XmlUtil.processXmlElements((XmlElement)tag, processor2, true);
                }
                if (processor2.result == null && (declaration = XmlDocumentationProvider.getComplexOrSimpleTypeDefinition(element, originalElement)) != null) {
                    XmlUtil.processXmlElements((XmlElement)declaration, processor2, true);
                    name = declaration.getAttributeValue(NAME_ATTR_NAME);
                    typeName = XmlBundle.message((String)"xml.javadoc.complex.type.message", (Object[])new Object[0]);
                }
                if (processor2.result == null && (comment = XmlUtil.findPreviousComment(element)) != null) {
                    return this.formatDocFromComment(comment, ((XmlTag)element).getName());
                }
                String doc = this.generateDoc(processor2.result, name, typeName, processor2.version);
                if (doc != null && originalElement != null) {
                    doc = doc + XmlDocumentationProvider.generateHtmlAdditionalDocTemplate(originalElement);
                }
                return doc;
            }
            if (element instanceof XmlAttributeDecl) {
                PsiElement prevSibling;
                PsiElement parent = element.getParent();
                PsiElement previousComment = XmlUtil.findPreviousComment(parent);
                String referenceName = ((XmlAttributeDecl)element).getNameElement().getText();
                if (previousComment instanceof PsiComment && ((prevSibling = previousComment.getPrevSibling()) == null || prevSibling instanceof PsiWhiteSpace && prevSibling.getText().indexOf(10) >= 0)) {
                    return this.formatDocFromComment(previousComment, referenceName);
                }
                return this.findDocRightAfterElement(parent, referenceName);
            }
            if (element instanceof XmlEntityDecl) {
                XmlEntityDecl entityDecl = (XmlEntityDecl)element;
                return this.findDocRightAfterElement(element, entityDecl.getName());
            }
        }
        return null;
    }

    private static XmlTag findEnumerationValue(String text, XmlTag tag) {
        Ref enumerationTag = new Ref();
        Processor processor2 = xmlTag -> {
            if (text.equals(xmlTag.getAttributeValue("value"))) {
                enumerationTag.set(xmlTag);
            }
            return true;
        };
        XmlUtil.processEnumerationValues(tag, (Processor<? super XmlTag>)processor2);
        if (enumerationTag.get() == null) {
            TypeDescriptor type;
            XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(tag, null);
            TypeDescriptor typeDescriptor = type = elementDescriptor != null ? elementDescriptor.getType() : null;
            if (type instanceof ComplexTypeDescriptor) {
                XmlUtil.processEnumerationValues(((ComplexTypeDescriptor)type).getDeclaration(), (Processor<? super XmlTag>)processor2);
            }
        }
        return (XmlTag)enumerationTag.get();
    }

    static String generateHtmlAdditionalDocTemplate(@NotNull PsiElement element) {
        if (element == null) {
            XmlDocumentationProvider.$$$reportNull$$$0(0);
        }
        StringBuilder buf = new StringBuilder();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            HtmlTagDescriptor descriptor;
            boolean append;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                append = true;
            } else {
                FileViewProvider provider = containingFile.getViewProvider();
                Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
                boolean bl = append = language == XHTMLLanguage.INSTANCE;
            }
            if (tag != null && (descriptor = HtmlDescriptorsTable.getTagDescriptor(tag.getName())) != null && append) {
                buf.append("<br>");
                buf.append(XmlBundle.message((String)"html.quickdoc.additional.template", (Object[])new Object[]{descriptor.getHelpRef(), BASE_SITEPOINT_URL + tag.getName()}));
            }
        }
        return buf.toString();
    }

    public String findDocRightAfterElement(PsiElement parent, String referenceName) {
        PsiElement uncleElement = parent.getNextSibling();
        if (uncleElement instanceof PsiWhiteSpace && uncleElement.getText().indexOf(10) == -1) {
            uncleElement = uncleElement.getNextSibling();
        }
        if (uncleElement instanceof PsiComment) {
            return this.formatDocFromComment(uncleElement, referenceName);
        }
        return null;
    }

    private String formatDocFromComment(PsiElement curElement, String name) {
        String text = curElement.getText();
        text = text.substring("<!--".length(), text.length() - "-->".length()).trim();
        text = XmlDocumentationProvider.escapeDocumentationTextText(text);
        return this.generateDoc(text, name, null, null);
    }

    private static XmlTag getComplexOrSimpleTypeDefinition(PsiElement element, PsiElement originalElement) {
        TypeDescriptor type;
        XmlAttributeDescriptor attributeDescriptor;
        XmlAttribute contextAttribute;
        XmlElementDescriptor descriptor = (XmlElementDescriptor)element.getUserData(DESCRIPTOR_KEY);
        XmlTag contextTag = null;
        if (descriptor == null && originalElement != null && (contextAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlAttribute.class)) != null && (attributeDescriptor = contextAttribute.getDescriptor()) instanceof XmlAttributeDescriptorImpl) {
            TypeDescriptor type2;
            XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType((XmlTag)attributeDescriptor.getDeclaration(), contextAttribute.getParent());
            TypeDescriptor typeDescriptor = type2 = elementDescriptor != null ? elementDescriptor.getType((XmlElement)contextAttribute) : null;
            if (type2 instanceof ComplexTypeDescriptor) {
                return ((ComplexTypeDescriptor)type2).getDeclaration();
            }
        }
        if (descriptor == null && originalElement != null && (contextTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class)) != null) {
            descriptor = contextTag.getDescriptor();
        }
        if (descriptor instanceof XmlElementDescriptorImpl && (type = ((XmlElementDescriptorImpl)descriptor).getType((XmlElement)contextTag)) instanceof ComplexTypeDescriptor) {
            return ((ComplexTypeDescriptor)type).getDeclaration();
        }
        return null;
    }

    protected String generateDoc(String str, String name, String typeName, String version) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(str.length() + 20);
        DocumentationUtil.formatEntityName((String)(typeName == null ? XmlBundle.message((String)"xml.javadoc.tag.name.message", (Object[])new Object[0]) : typeName), (String)name, (StringBuilder)buf);
        String indent = "  ";
        StringBuilder builder2 = buf.append(XmlBundle.message((String)"xml.javadoc.description.message", (Object[])new Object[0])).append("  ").append(":&nbsp;").append(str);
        if (version != null) {
            builder2.append("<br>").append(XmlBundle.message((String)"xml.javadoc.version.message", (Object[])new Object[0])).append("  ").append(":&nbsp;").append(version);
        }
        return builder2.toString();
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof XmlExtension.TagInfo) {
            return ((XmlExtension.TagInfo)object).getDeclaration();
        }
        PsiElement originalElement = element;
        boolean isAttrCompletion = element instanceof XmlAttribute;
        if (!isAttrCompletion && element instanceof XmlToken) {
            IElementType tokenType = ((XmlToken)element).getTokenType();
            if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || tokenType == XmlTokenType.XML_TAG_END) {
                isAttrCompletion = true;
            } else if (element.getParent() instanceof XmlAttribute) {
                isAttrCompletion = true;
            }
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false)) instanceof XmlTag) {
            PsiElement declaration;
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor elementDescriptor;
            XmlTag xmlTag = (XmlTag)element;
            if (isAttrCompletion && object instanceof String && (elementDescriptor = xmlTag.getDescriptor()) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor((String)object, xmlTag)) != null && (declaration = attributeDescriptor.getDeclaration()) != null) {
                return declaration;
            }
            if (object == null) {
                return null;
            }
            try {
                XmlTag rootTag;
                PsiElement parent;
                StringBuilder tagText = new StringBuilder(object.toString());
                String namespacePrefix = XmlUtil.findPrefixByQualifiedName(object.toString());
                String namespace = xmlTag.getNamespaceByPrefix(namespacePrefix);
                if (namespace != null && namespace.length() > 0) {
                    tagText.append(" xmlns");
                    if (namespacePrefix.length() > 0) {
                        tagText.append(":").append(namespacePrefix);
                    }
                    tagText.append("=\"").append(namespace).append("\"");
                }
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)xmlTag.getProject()).createTagFromText((CharSequence)("<" + tagText + "/>"));
                XmlElementDescriptor parentDescriptor = xmlTag.getDescriptor();
                XmlElementDescriptor xmlElementDescriptor = elementDescriptor = parentDescriptor != null ? parentDescriptor.getElementDescriptor(tagFromText, xmlTag) : null;
                if (elementDescriptor == null && (parent = xmlTag.getParent()) instanceof XmlTag) {
                    parentDescriptor = ((XmlTag)parent).getDescriptor();
                    XmlElementDescriptor xmlElementDescriptor2 = elementDescriptor = parentDescriptor != null ? parentDescriptor.getElementDescriptor(tagFromText, (XmlTag)parent) : null;
                }
                if (elementDescriptor instanceof AnyXmlElementDescriptor) {
                    XmlNSDescriptor nsDescriptor = xmlTag.getNSDescriptor(xmlTag.getNamespaceByPrefix(namespacePrefix), true);
                    elementDescriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(tagFromText) : null;
                }
                PsiFile containingFile = xmlTag.getContainingFile();
                XmlFile xmlFile = XmlUtil.getContainingFile((PsiElement)xmlTag);
                if (xmlFile != containingFile && (rootTag = xmlFile.getDocument().getRootTag()) != null) {
                    XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(rootTag.getNamespaceByPrefix(namespacePrefix), true);
                    XmlElementDescriptor xmlElementDescriptor3 = elementDescriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(tagFromText) : null;
                }
                if (elementDescriptor != null) {
                    PsiElement declaration2 = elementDescriptor.getDeclaration();
                    if (declaration2 != null) {
                        declaration2.putUserData(DESCRIPTOR_KEY, (Object)elementDescriptor);
                    }
                    return declaration2;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (object instanceof String && originalElement != null) {
            XmlAttributeDescriptor descriptor;
            XmlAttribute attribute;
            PsiElement result2 = XmlDocumentationProvider.findDeclWithName((String)object, originalElement);
            if (result2 == null && element instanceof XmlTag && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlAttribute.class, (boolean)false)) != null && (descriptor = attribute.getDescriptor()) != null && descriptor.getDeclaration() instanceof XmlTag) {
                result2 = XmlDocumentationProvider.findEnumerationValue((String)object, (XmlTag)descriptor.getDeclaration());
            }
            return result2;
        }
        if (object instanceof XmlElementDescriptor) {
            return ((XmlElementDescriptor)object).getDeclaration();
        }
        return null;
    }

    public static PsiElement findDeclWithName(final String name, @NotNull PsiElement element) {
        XmlFile xmlFile;
        if (element == null) {
            XmlDocumentationProvider.$$$reportNull$$$0(1);
        }
        XmlFile containingXmlFile = XmlUtil.getContainingFile(element);
        XmlTag nearestTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        XmlFile xmlFile2 = xmlFile = nearestTag != null && containingXmlFile != null ? XmlUtil.findDescriptorFile(nearestTag, containingXmlFile) : containingXmlFile;
        if (xmlFile != null) {
            final PsiElement[] result2 = new PsiElement[1];
            XmlUtil.processXmlElements((XmlElement)xmlFile, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    XmlElementDecl entityDecl;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlEntityDecl) {
                        XmlEntityDecl entityDecl2 = (XmlEntityDecl)element;
                        if (entityDecl2.isInternalReference() && name.equals(entityDecl2.getName())) {
                            result2[0] = entityDecl2;
                            return false;
                        }
                    } else if (element instanceof XmlElementDecl && name.equals((entityDecl = (XmlElementDecl)element).getName())) {
                        result2[0] = entityDecl;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/documentation/XmlDocumentationProvider$1", "execute"));
                }
            }, true);
            return result2[0];
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static String escapeDocumentationTextText(String result2) {
        return StringUtil.escapeXml((String)result2).replaceAll("&apos;", "'").replaceAll("\n", "<br>\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/xml/util/documentation/XmlDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHtmlAdditionalDocTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findDeclWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPsiElementProcessor
    implements PsiElementProcessor {
        String result;
        String version;
        String url;
        @NonNls
        public static final String DOCUMENTATION_ELEMENT_LOCAL_NAME = "documentation";
        @NonNls
        private static final String CDATA_PREFIX = "<![CDATA[";
        @NonNls
        private static final String CDATA_SUFFIX = "]]>";

        private MyPsiElementProcessor() {
        }

        public boolean execute(@NotNull PsiElement element) {
            if (element == null) {
                MyPsiElementProcessor.$$$reportNull$$$0(0);
            }
            if (element instanceof XmlTag && ((XmlTag)element).getLocalName().equals(DOCUMENTATION_ELEMENT_LOCAL_NAME)) {
                String s;
                XmlTag tag = (XmlTag)element;
                this.result = tag.getValue().getText().trim();
                boolean withCData = false;
                if (this.result.startsWith(CDATA_PREFIX)) {
                    this.result = this.result.substring(CDATA_PREFIX.length());
                    withCData = true;
                }
                this.result = StringUtil.trimEnd((String)this.result, (String)CDATA_SUFFIX);
                this.result = this.result.trim();
                if (withCData) {
                    this.result = XmlDocumentationProvider.escapeDocumentationTextText(this.result);
                }
                if ((s = tag.getAttributeValue("source")) != null) {
                    if (s.startsWith("http:")) {
                        this.url = s;
                    } else if ("version".equals(s)) {
                        this.version = this.result;
                        this.result = null;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/documentation/XmlDocumentationProvider$MyPsiElementProcessor", "execute"));
        }
    }
}

