/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.CaretSpecificDataContext;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaUsageTriggerCollector;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCompletionContributor
extends CompletionContributor {
    private static final String BUILTIN_USAGE_KEY = "json.schema.builtin.completion";
    private static final String SCHEMA_USAGE_KEY = "json.schema.schema.completion";
    private static final String USER_USAGE_KEY = "json.schema.user.completion";
    private static final String REMOTE_USAGE_KEY = "json.schema.remote.completion";

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement parent;
        PsiElement position;
        VirtualFile file2;
        if (parameters == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)(position = parameters.getPosition()))) == null) {
            return;
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(position.getProject());
        if (!service2.isApplicableToFile(file2)) {
            return;
        }
        JsonSchemaObject rootSchema = service2.getSchemaObject(file2);
        if (rootSchema == null) {
            return;
        }
        PsiElement positionParent = position.getParent();
        if (positionParent != null && (parent = positionParent.getParent()) instanceof JsonProperty && "$ref".equals(((JsonProperty)parent).getName()) && service2.isSchemaFile(file2)) {
            return;
        }
        VirtualFile schemaFile = rootSchema.getSchemaFile();
        JsonSchemaCompletionContributor.updateStat(service2.getSchemaProvider(schemaFile), schemaFile);
        JsonSchemaCompletionContributor.doCompletion(parameters, result2, rootSchema);
    }

    public static void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull JsonSchemaObject rootSchema) {
        if (parameters == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(3);
        }
        if (rootSchema == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(4);
        }
        JsonSchemaCompletionContributor.doCompletion(parameters, result2, rootSchema, true);
    }

    public static void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull JsonSchemaObject rootSchema, boolean stop2) {
        if (parameters == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(6);
        }
        if (rootSchema == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(7);
        }
        PsiElement completionPosition = parameters.getOriginalPosition() != null ? parameters.getOriginalPosition() : parameters.getPosition();
        new Worker(rootSchema, parameters.getPosition(), completionPosition, (Consumer<LookupElement>)result2).work();
        if (stop2) {
            result2.stopHere();
        }
    }

    @NotNull
    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition) {
        if (schema == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(8);
        }
        if (position == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(9);
        }
        if (originalPosition == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(10);
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        new Worker(schema, position, originalPosition, (Consumer<LookupElement>)((Consumer)element -> result2.add((LookupElement)element))).work();
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void updateStat(@Nullable JsonSchemaFileProvider provider, VirtualFile schemaFile) {
        if (provider == null) {
            if (schemaFile instanceof HttpVirtualFile) {
                FUSApplicationUsageTrigger usageTrigger = FUSApplicationUsageTrigger.getInstance();
                usageTrigger.trigger(JsonSchemaUsageTriggerCollector.class, REMOTE_USAGE_KEY);
            }
            return;
        }
        SchemaType schemaType = provider.getSchemaType();
        FUSApplicationUsageTrigger usageTrigger = FUSApplicationUsageTrigger.getInstance();
        switch (schemaType) {
            case schema: {
                usageTrigger.trigger(JsonSchemaUsageTriggerCollector.class, SCHEMA_USAGE_KEY);
                break;
            }
            case userSchema: {
                usageTrigger.trigger(JsonSchemaUsageTriggerCollector.class, USER_USAGE_KEY);
                break;
            }
            case embeddedSchema: {
                usageTrigger.trigger(JsonSchemaUsageTriggerCollector.class, BUILTIN_USAGE_KEY);
                break;
            }
            case remoteSchema: {
                usageTrigger.trigger(JsonSchemaUsageTriggerCollector.class, REMOTE_USAGE_KEY);
            }
        }
    }

    private static void insertPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<Object> values, JsonSchemaType type, String comma, JsonLikePsiWalker walker, boolean insertColon) {
        if (!walker.quotesForStringLiterals() && defaultValue != null) {
            defaultValue = StringUtil.unquoteString((String)defaultValue);
        }
        boolean isNumber = type != null && (JsonSchemaType._integer.equals((Object)type) || JsonSchemaType._number.equals((Object)type)) || type == null && (defaultValue != null && !StringUtil.isQuotedString((String)defaultValue) || values != null && ContainerUtil.and(values, v -> !(v instanceof String)));
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        boolean hasQuotes = isNumber || !walker.quotesForStringLiterals();
        String colonWs = insertColon ? ": " : " ";
        String stringToInsert = colonWs + (hasDefaultValue ? defaultValue : (hasQuotes ? "" : "\"\"")) + comma;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
        if (!hasQuotes || hasDefaultValue) {
            SelectionModel model = editor.getSelectionModel();
            int caretStart = model.getSelectionStart();
            int newOffset = caretStart + (hasDefaultValue ? defaultValue.length() : 1);
            if (hasDefaultValue && !hasQuotes) {
                --newOffset;
            }
            model.setSelection(hasQuotes ? caretStart : caretStart + 1, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        if (!walker.invokeEnterBeforeObjectAndArray() && !stringToInsert.equals(colonWs + comma)) {
            JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
        }
        if (hasValues) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    public static void formatInsertedString(@NotNull InsertionContext context, int offset) {
        if (context == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(12);
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCompletion";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatInsertedString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final PsiElement myOriginalPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myWrapInQuotes;
        private final boolean myInsideStringLiteral;
        private final Set<LookupElement> myVariants;
        private final JsonLikePsiWalker myWalker;

        Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            if (rootSchema == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (position == null) {
                Worker.$$$reportNull$$$0(1);
            }
            if (originalPosition == null) {
                Worker.$$$reportNull$$$0(2);
            }
            if (resultConsumer == null) {
                Worker.$$$reportNull$$$0(3);
            }
            this.myRootSchema = rootSchema;
            this.myPosition = position;
            this.myOriginalPosition = originalPosition;
            this.myResultConsumer = resultConsumer;
            this.myVariants = new HashSet<LookupElement>();
            this.myWalker = JsonLikePsiWalker.getWalker(this.myPosition, this.myRootSchema);
            this.myWrapInQuotes = this.myWalker != null && this.myWalker.isNameQuoted() && !(position.getParent() instanceof JsonStringLiteral);
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
        }

        public void work() {
            if (this.myWalker == null) {
                return;
            }
            PsiElement checkable = this.myWalker.goUpToCheckable(this.myPosition);
            if (checkable == null) {
                return;
            }
            ThreeState isName = this.myWalker.isName(checkable);
            List<JsonSchemaVariantsTreeBuilder.Step> position = this.myWalker.findPosition(checkable, isName == ThreeState.NO);
            if (position == null || position.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(this.myRootSchema, false, position).resolve();
            HashSet knownNames = ContainerUtil.newHashSet();
            schemas.forEach(schema -> {
                if (isName != ThreeState.NO) {
                    boolean insertComma = this.myWalker.hasPropertiesBehindAndNoComma(this.myPosition);
                    boolean hasValue = this.myWalker.isPropertyWithValue(checkable);
                    Set<String> properties = this.myWalker.getPropertyNamesOfParentObject(this.myOriginalPosition, this.myPosition);
                    JsonPropertyAdapter adapter = this.myWalker.getParentPropertyAdapter(this.myOriginalPosition);
                    Map<String, JsonSchemaObject> schemaProperties = schema.getProperties();
                    this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, schemaProperties, knownNames);
                    this.addIfThenElsePropertyNameVariants((JsonSchemaObject)schema, insertComma, hasValue, (Collection<String>)properties, adapter, knownNames);
                }
                if (isName != ThreeState.YES) {
                    this.suggestValues((JsonSchemaObject)schema, isName == ThreeState.NO);
                }
            });
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        private void addIfThenElsePropertyNameVariants(@NotNull JsonSchemaObject schema, boolean insertComma, boolean hasValue, @NotNull Collection<String> properties, @Nullable JsonPropertyAdapter adapter, Set<String> knownNames) {
            JsonPropertyAdapter propertyAdapter;
            if (schema == null) {
                Worker.$$$reportNull$$$0(4);
            }
            if (properties == null) {
                Worker.$$$reportNull$$$0(5);
            }
            if (schema.getIf() == null) {
                return;
            }
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(this.myPosition, schema);
            JsonPropertyAdapter jsonPropertyAdapter = propertyAdapter = walker == null ? null : walker.getParentPropertyAdapter(this.myPosition);
            if (propertyAdapter == null) {
                return;
            }
            JsonObjectValueAdapter object = propertyAdapter.getParentObject();
            if (object == null) {
                return;
            }
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(JsonComplianceCheckerOptions.RELAX_ENUM_CHECK);
            checker.checkByScheme(object, schema.getIf());
            if (checker.isCorrect()) {
                JsonSchemaObject then = schema.getThen();
                if (then != null) {
                    this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, then.getProperties(), knownNames);
                }
            } else {
                JsonSchemaObject schemaElse = schema.getElse();
                if (schemaElse != null) {
                    this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, schemaElse.getProperties(), knownNames);
                }
            }
        }

        private void addAllPropertyVariants(boolean insertComma, boolean hasValue, Collection<String> properties, JsonPropertyAdapter adapter, Map<String, JsonSchemaObject> schemaProperties, Set<String> knownNames) {
            schemaProperties.keySet().stream().filter(name -> !properties.contains(name) && !knownNames.contains(name) || adapter != null && name.equals(adapter.getName())).forEach(name -> {
                knownNames.add((String)name);
                this.addPropertyVariant((String)name, (JsonSchemaObject)schemaProperties.get(name), hasValue, insertComma);
            });
        }

        private void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            block3: {
                block4: {
                    block2: {
                        this.suggestValuesForSchemaVariants(schema.getAnyOf(), isSurelyValue);
                        this.suggestValuesForSchemaVariants(schema.getOneOf(), isSurelyValue);
                        this.suggestValuesForSchemaVariants(schema.getAllOf(), isSurelyValue);
                        if (schema.getEnum() == null) break block2;
                        for (Object o : schema.getEnum()) {
                            if (this.myInsideStringLiteral && !(o instanceof String)) continue;
                            this.addValueVariant(o.toString(), null);
                        }
                        break block3;
                    }
                    if (!isSurelyValue) break block3;
                    JsonSchemaType type = schema.guessType();
                    this.suggestSpecialValues(type);
                    if (type == null) break block4;
                    this.suggestByType(schema, type);
                    break block3;
                }
                if (schema.getTypeVariants() == null) break block3;
                for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                    this.suggestByType(schema, schemaType);
                }
            }
        }

        private void suggestSpecialValues(@Nullable JsonSchemaType type) {
            if (JsonSchemaVersion.isSchemaSchemaId(this.myRootSchema.getId()) && type == JsonSchemaType._string) {
                JsonPropertyAdapter propertyAdapter = this.myWalker.getParentPropertyAdapter(this.myOriginalPosition);
                if (propertyAdapter == null || !"required".equals(propertyAdapter.getName())) {
                    return;
                }
                PsiElement checkable = this.myWalker.goUpToCheckable(this.myPosition);
                if (!(checkable instanceof JsonStringLiteral) && !(checkable instanceof JsonReferenceExpression)) {
                    return;
                }
                JsonObject propertiesObject = JsonRequiredPropsReferenceProvider.findPropertiesObject(checkable);
                if (propertiesObject == null) {
                    return;
                }
                PsiElement parent = checkable.getParent();
                HashSet items = parent instanceof JsonArray ? ((JsonArray)parent).getValueList().stream().filter(v -> v instanceof JsonStringLiteral).map(v -> ((JsonStringLiteral)v).getValue()).collect(Collectors.toSet()) : ContainerUtil.newHashSet();
                propertiesObject.getPropertyList().stream().map(p -> p.getName()).filter(n -> !items.contains(n)).forEach(n -> this.addStringVariant((String)n));
            }
        }

        private void suggestByType(JsonSchemaObject schema, JsonSchemaType type) {
            if (JsonSchemaType._string.equals((Object)type)) {
                this.addPossibleStringValue(schema);
            }
            if (this.myInsideStringLiteral) {
                return;
            }
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addPossibleBooleanValue(type);
            } else if (JsonSchemaType._null.equals((Object)type)) {
                this.addValueVariant("null", null);
            } else if (JsonSchemaType._array.equals((Object)type)) {
                String value = this.myWalker.getDefaultArrayValue();
                this.addValueVariant(value, null, this.myWalker.defaultArrayValueDescription(), Worker.createArrayOrObjectLiteralInsertHandler(this.myWalker.invokeEnterBeforeObjectAndArray(), value.length()));
            } else if (JsonSchemaType._object.equals((Object)type)) {
                String value = this.myWalker.getDefaultObjectValue();
                this.addValueVariant(value, null, this.myWalker.defaultObjectValueDescription(), Worker.createArrayOrObjectLiteralInsertHandler(this.myWalker.invokeEnterBeforeObjectAndArray(), value.length()));
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            Object defaultValue = schema.getDefault();
            String defaultValueString = defaultValue == null ? null : defaultValue.toString();
            this.addStringVariant(defaultValueString);
        }

        private void addStringVariant(String defaultValueString) {
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String normalizedValue = defaultValueString;
                boolean shouldQuote = this.myWalker.quotesForStringLiterals();
                boolean isQuoted = StringUtil.isQuotedString((String)normalizedValue);
                if (shouldQuote && !isQuoted) {
                    normalizedValue = StringUtil.wrapWithDoubleQuote((String)normalizedValue);
                } else if (!shouldQuote && isQuoted) {
                    normalizedValue = StringUtil.unquoteString((String)normalizedValue);
                }
                this.addValueVariant(normalizedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list2, boolean isSurelyValue) {
            if (list2 != null && list2.size() > 0) {
                for (JsonSchemaObject schemaObject : list2) {
                    this.suggestValues(schemaObject, isSurelyValue);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key, @Nullable String description) {
            if (key == null) {
                Worker.$$$reportNull$$$0(6);
            }
            this.addValueVariant(key, description, null, null);
        }

        private void addValueVariant(@NotNull String key, @Nullable String description, @Nullable String altText, @Nullable InsertHandler<LookupElement> handler2) {
            if (key == null) {
                Worker.$$$reportNull$$$0(7);
            }
            LookupElementBuilder builder2 = LookupElementBuilder.create((String)(!this.myWrapInQuotes ? StringUtil.unquoteString((String)key) : key));
            if (altText != null) {
                builder2 = builder2.withPresentableText(altText);
            }
            if (description != null) {
                builder2 = builder2.withTypeText(description);
            }
            if (handler2 != null) {
                builder2 = builder2.withInsertHandler(handler2);
            }
            this.myVariants.add((LookupElement)builder2);
        }

        private void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue, boolean insertComma) {
            Object type;
            if (key == null) {
                Worker.$$$reportNull$$$0(8);
            }
            if (jsonSchemaObject == null) {
                Worker.$$$reportNull$$$0(9);
            }
            Collection<JsonSchemaObject> variants = new JsonSchemaResolver(jsonSchemaObject).resolve();
            jsonSchemaObject = (JsonSchemaObject)ObjectUtils.coalesce((Object)ContainerUtil.getFirstItem(variants), (Object)jsonSchemaObject);
            key = !this.myWrapInQuotes ? key : StringUtil.wrapWithDoubleQuote((String)key);
            LookupElementBuilder builder2 = LookupElementBuilder.create((String)key);
            String typeText = JsonSchemaDocumentationProvider.getBestDocumentation(true, jsonSchemaObject);
            if (!StringUtil.isEmptyOrSpaces((String)typeText)) {
                String text = StringUtil.removeHtmlTags((String)typeText);
                int firstSentenceMark = text.indexOf(". ");
                builder2 = builder2.withTypeText(firstSentenceMark == -1 ? text : text.substring(0, firstSentenceMark + 1), true);
            } else {
                type = jsonSchemaObject.getTypeDescription(true);
                if (type != null) {
                    builder2 = builder2.withTypeText(type, true);
                }
            }
            builder2 = builder2.withIcon(Worker.getIcon(jsonSchemaObject.guessType()));
            if (Worker.hasSameType(variants)) {
                boolean hasValues;
                type = jsonSchemaObject.guessType();
                List<Object> values = jsonSchemaObject.getEnum();
                Object defaultValue = jsonSchemaObject.getDefault();
                boolean bl = hasValues = !ContainerUtil.isEmpty(values);
                builder2 = type != null || hasValues || defaultValue != null ? builder2.withInsertHandler(!hasValues || values.stream().map(v -> v.getClass()).distinct().count() == 1L ? this.createPropertyInsertHandler(jsonSchemaObject, hasValue, insertComma) : this.createDefaultPropertyInsertHandler(true, insertComma)) : builder2.withInsertHandler(this.createDefaultPropertyInsertHandler(false, insertComma));
            } else if (!hasValue) {
                builder2 = builder2.withInsertHandler(this.createDefaultPropertyInsertHandler(false, insertComma));
            }
            this.myVariants.add((LookupElement)builder2);
        }

        @NotNull
        private static Icon getIcon(@Nullable JsonSchemaType type) {
            if (type == null) {
                Icon icon = AllIcons.Nodes.Property;
                if (icon == null) {
                    Worker.$$$reportNull$$$0(10);
                }
                return icon;
            }
            switch (type) {
                case _object: {
                    Icon icon = AllIcons.Json.Object;
                    if (icon == null) {
                        Worker.$$$reportNull$$$0(11);
                    }
                    return icon;
                }
                case _array: {
                    Icon icon = AllIcons.Json.Array;
                    if (icon == null) {
                        Worker.$$$reportNull$$$0(12);
                    }
                    return icon;
                }
            }
            Icon icon = AllIcons.Nodes.Property;
            if (icon == null) {
                Worker.$$$reportNull$$$0(13);
            }
            return icon;
        }

        private static boolean hasSameType(@NotNull Collection<JsonSchemaObject> variants) {
            if (variants == null) {
                Worker.$$$reportNull$$$0(14);
            }
            return variants.stream().map(JsonSchemaObject::guessType).filter(Objects::nonNull).distinct().count() <= 1L;
        }

        private static InsertHandler<LookupElement> createArrayOrObjectLiteralInsertHandler(final boolean newline, final int insertedTextSize) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Editor editor = context.getEditor();
                    if (!newline) {
                        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)-1);
                    } else {
                        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)(-insertedTextSize));
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
                        Worker.invokeEnterHandler(editor);
                        EditorActionUtil.moveCaretToLineEnd(editor, false, false);
                    }
                    AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(editor, null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private InsertHandler<LookupElement> createDefaultPropertyInsertHandler(final boolean hasValue, final boolean insertComma) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    if (context == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project = context.getProject();
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    String stringToInsert = ": 1" + (insertComma ? "," : "");
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                    JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                    int offset = editor.getCaretModel().getOffset();
                    context.getDocument().deleteString(offset, offset + 1);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$2";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue, final boolean insertComma) {
            Object defaultValue;
            if (jsonSchemaObject == null) {
                Worker.$$$reportNull$$$0(15);
            }
            JsonSchemaType type = jsonSchemaObject.guessType();
            final List<Object> values = jsonSchemaObject.getEnum();
            if (type == null && values != null && !values.isEmpty()) {
                type = Worker.detectType(values);
            }
            final String defaultValueAsString = (defaultValue = jsonSchemaObject.getDefault()) == null || defaultValue instanceof JsonSchemaObject ? null : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : String.valueOf(defaultValue));
            final JsonSchemaType finalType = type;
            InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    block20: {
                        boolean insertColon;
                        String comma;
                        Editor editor;
                        block19: {
                            if (context == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            if (item == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            ApplicationManager.getApplication().assertWriteAccessAllowed();
                            editor = context.getEditor();
                            Project project = context.getProject();
                            String stringToInsert = null;
                            String string = comma = insertComma ? "," : "";
                            if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                                return;
                            }
                            PsiElement element = context.getFile().findElementAt(editor.getCaretModel().getOffset());
                            boolean bl = insertColon = element == null || !":".equals(element.getText());
                            if (!insertColon) {
                                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
                            }
                            if (finalType == null) break block19;
                            switch (finalType) {
                                case _object: {
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(insertColon ? ": " : " "), (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
                                    boolean hadEnter = false;
                                    boolean invokeEnter = myWalker.invokeEnterBeforeObjectAndArray();
                                    if (insertColon && invokeEnter) {
                                        Worker.invokeEnterHandler(editor);
                                        hadEnter = true;
                                    }
                                    if (insertColon) {
                                        stringToInsert = myWalker.getDefaultObjectValue() + comma;
                                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter ? 0 : 1));
                                    }
                                    if (hadEnter || !insertColon) {
                                        EditorActionUtil.moveCaretToLineEnd(editor, false, false);
                                    }
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                    if (!hadEnter && stringToInsert != null) {
                                        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                    }
                                    if (stringToInsert != null && !invokeEnter) {
                                        Worker.invokeEnterHandler(editor);
                                        break;
                                    }
                                    break block20;
                                }
                                case _boolean: {
                                    String value = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                    stringToInsert = (insertColon ? ": " : " ") + value + comma;
                                    SelectionModel model = editor.getSelectionModel();
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(stringToInsert.length() - comma.length()));
                                    JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                    int start2 = editor.getSelectionModel().getSelectionStart();
                                    model.setSelection(start2 - value.length(), start2);
                                    AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                                    break;
                                }
                                case _array: {
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(insertColon ? ": " : " "), (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
                                    boolean hadEnter = false;
                                    if (insertColon && myWalker.invokeEnterBeforeObjectAndArray()) {
                                        Worker.invokeEnterHandler(editor);
                                        hadEnter = true;
                                    }
                                    if (insertColon) {
                                        stringToInsert = myWalker.getDefaultArrayValue() + comma;
                                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter ? 0 : 1));
                                    }
                                    if (hadEnter) {
                                        EditorActionUtil.moveCaretToLineEnd(editor, false, false);
                                    }
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                    if (stringToInsert != null) {
                                        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                        break;
                                    }
                                    break block20;
                                }
                                case _string: 
                                case _integer: {
                                    JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, finalType, comma, myWalker, insertColon);
                                    break;
                                }
                            }
                            break block20;
                        }
                        JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, null, comma, myWalker, insertColon);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$3";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (insertHandler == null) {
                Worker.$$$reportNull$$$0(16);
            }
            return insertHandler;
        }

        private static void invokeEnterHandler(Editor editor) {
            EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorEnter");
            Caret caret = editor.getCaretModel().getCurrentCaret();
            handler2.execute(editor, caret, (DataContext)new CaretSpecificDataContext(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), caret));
        }

        private boolean handleInsideQuotesInsertion(@NotNull InsertionContext context, @NotNull Editor editor, boolean hasValue) {
            if (context == null) {
                Worker.$$$reportNull$$$0(17);
            }
            if (editor == null) {
                Worker.$$$reportNull$$$0(18);
            }
            if (this.myInsideStringLiteral) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = context.getFile().findElementAt(offset);
                int tailOffset = context.getTailOffset();
                int guessEndOffset = tailOffset + 1;
                if (element instanceof LeafPsiElement) {
                    if (Worker.handleIncompleteString(editor, element)) {
                        return false;
                    }
                    int endOffset = element.getTextRange().getEndOffset();
                    if (endOffset > tailOffset) {
                        context.getDocument().deleteString(tailOffset, endOffset - 1);
                    }
                }
                if (hasValue) {
                    return true;
                }
                editor.getCaretModel().moveToOffset(guessEndOffset);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            return false;
        }

        private static boolean handleIncompleteString(@NotNull Editor editor, @NotNull PsiElement element) {
            JsonValue nameElement;
            PsiElement prevSibling;
            if (editor == null) {
                Worker.$$$reportNull$$$0(19);
            }
            if (element == null) {
                Worker.$$$reportNull$$$0(20);
            }
            if (((LeafPsiElement)element).getElementType() == TokenType.WHITE_SPACE && (prevSibling = element.getPrevSibling()) instanceof JsonProperty && !(nameElement = ((JsonProperty)prevSibling).getNameElement()).getText().endsWith("\"")) {
                editor.getCaretModel().moveToOffset(nameElement.getTextRange().getEndOffset());
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\"", (boolean)false, (boolean)true, (int)1);
                return true;
            }
            return false;
        }

        @Nullable
        private static JsonSchemaType detectType(List<Object> values) {
            JsonSchemaType type = null;
            for (Object value : values) {
                JsonSchemaType newType = null;
                if (value instanceof Integer) {
                    newType = JsonSchemaType._integer;
                }
                if (type != null && !type.equals((Object)newType)) {
                    return null;
                }
                type = newType;
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootSchema";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonSchemaObject";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPropertyInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addIfThenElsePropertyNameVariants";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addValueVariant";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyVariant";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSameType";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createPropertyInsertHandler";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsideQuotesInsertion";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "handleIncompleteString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

