/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.RowLayout;

public final class ResultLayout<T>
implements Serializable {
    @NotNull
    public final Kind kind;
    public final boolean sorted;
    @NotNull
    public final RowLayout<?> row;
    public final int initialCapacity;

    ResultLayout(@NotNull Kind kind, boolean sorted, @NotNull RowLayout row) {
        this.kind = kind;
        this.sorted = sorted;
        this.row = row;
        this.initialCapacity = 1024;
    }

    ResultLayout(@NotNull Kind kind, boolean sorted, @NotNull RowLayout<?> row, int initialCapacity) {
        this.kind = kind;
        this.sorted = sorted;
        this.row = row;
        this.initialCapacity = initialCapacity;
    }

    public boolean isPortable() {
        return this.row.isPortable();
    }

    public ResultLayout<List<Object[]>> makeIntermediateLayout() {
        return new ResultLayout<List<Object[]>>(Kind.LIST, false, this.row.makeIntermediateLayout());
    }

    public String toString() {
        switch (this.kind) {
            case EXISTENCE: {
                return "existence";
            }
        }
        return this.kind.name() + " of " + this.row.toString();
    }

    public static enum Kind {
        EXISTENCE,
        SINGLE_ROW,
        ARRAY,
        ARRAY_OF_PRIMITIVES,
        LIST,
        SET,
        MAP;

    }
}

