/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteCassandraConnectionImpl;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Cassandra;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class CassandraJdbcHelper
extends JdbcHelperImpl {
    public CassandraJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Cassandra.RDBMS, version, connection);
    }

    public CassandraJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CassandraJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(0);
        }
        CassandraIntermediateFacade cassandraIntermediateFacade = new CassandraIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)CassandraExceptionRecognizer.INSTANCE);
        if (cassandraIntermediateFacade == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(1);
        }
        return cassandraIntermediateFacade;
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setTime(idx, time);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(4);
        }
        if (!JdbcNativeUtil.detectString(product, "Cassandra")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CassandraJdbcHelper.create(delegate);
    }

    @NotNull
    private static JdbcHelperImpl create(@NotNull Connection delegate) throws Exception {
        if (delegate == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(5);
        }
        String versionStr = JdbcNativeUtil.getString(delegate, "select release_version from system.local");
        JdbcNativeUtil.logInfo("release_version: " + versionStr);
        CassandraJdbcHelper cassandraJdbcHelper = new CassandraJdbcHelper(CassandraJdbcHelper.extractVersion(versionStr), delegate);
        if (cassandraJdbcHelper == null) {
            CassandraJdbcHelper.$$$reportNull$$$0(6);
        }
        return cassandraJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsLike() {
        return false;
    }

    @Override
    public RemoteConnection wrap(Connection connection) {
        return new RemoteCassandraConnectionImpl(connection, (JdbcHelperImpl)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/CassandraJdbcHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CassandraJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

