/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import icons.VuejsIcons;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.VueAttributeDescriptor;
import org.jetbrains.vuejs.codeInsight.VueComponentDetailsProvider;
import org.jetbrains.vuejs.codeInsight.VueComponents;
import org.jetbrains.vuejs.codeInsight.VueElementDescriptor;
import org.jetbrains.vuejs.codeInsight.completion.VueEventAttrCompletionProvider;
import org.jetbrains.vuejs.index.VueIndexKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J1\u0010\u0016\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J#\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/vuejs/codeInsight/completion/VueEventAttrCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addBindCompletions", "", "attr", "Lcom/intellij/psi/xml/XmlAttribute;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addCompletions", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "addEventCompletions", "tag", "Lcom/intellij/psi/xml/XmlTag;", "prefix", "", "addModifierCompletions", "lastDotIndex", "", "doAddModifierCompletions", "usedModifiers", "", "modifiers", "", "(Lcom/intellij/codeInsight/completion/CompletionResultSet;Ljava/util/Collection;[Ljava/lang/String;)V", "getUsedModifiers", "isEventFromGroup", "", "eventGroup", "([Ljava/lang/String;Ljava/lang/String;)Z", "Companion", "intellij.vuejs"})
final class VueEventAttrCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final String[] KEY_MODIFIERS;
    private static final String[] KEY_EVENTS;
    private static final String[] MOUSE_BUTTON_MODIFIERS;
    private static final String[] MOUSE_BUTTON_EVENTS;
    private static final String[] SYSTEM_MODIFIERS;
    private static final String[] MOUSE_EVENTS;
    private static final String[] EVENT_MODIFIERS;
    public static final Companion Companion;

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parameters.position");
        Project project = psiElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"parameters.position.project");
        if (!VueIndexKt.hasVue(project)) {
            return;
        }
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameters.position");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof XmlAttribute)) {
            psiElement3 = null;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)psiElement3;
        if (xmlAttribute == null) {
            return;
        }
        XmlAttribute attr = xmlAttribute;
        String string = attr.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attr.name");
        String attrName = string;
        if (StringsKt.startsWith$default((String)attrName, (String)"v-on:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attrName, (String)"@", (boolean)false, (int)2, null)) {
            this.addEventCompletions(attr, result);
            return;
        }
        if (StringsKt.startsWith$default((String)attrName, (String)"v-bind:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attrName, (String)":", (boolean)false, (int)2, null)) {
            this.addBindCompletions(attr, result);
            return;
        }
        InsertHandler insertHandler2 = (InsertHandler)new InsertHandler<LookupElement>(parameters){
            final /* synthetic */ CompletionParameters $parameters;

            public final void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)insertionContext, (String)"insertionContext");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                insertionContext.setLaterRunnable(new Runnable(this){
                    final /* synthetic */ addCompletions.insertHandler.1 this$0;

                    public final void run() {
                        CodeCompletionHandlerBase codeCompletionHandlerBase = new CodeCompletionHandlerBase(CompletionType.BASIC);
                        PsiFile psiFile = this.this$0.$parameters.getOriginalFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"parameters.originalFile");
                        codeCompletionHandlerBase.invokeCompletion(psiFile.getProject(), this.this$0.$parameters.getEditor());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$parameters = completionParameters;
            }
        };
        result.addElement((LookupElement)LookupElementBuilder.create((String)"v-on:").withIcon(VuejsIcons.Vue).withInsertHandler(insertHandler2));
        result.addElement((LookupElement)LookupElementBuilder.create((String)"v-bind:").withIcon(VuejsIcons.Vue).withInsertHandler(insertHandler2));
    }

    private final void addEventCompletions(XmlAttribute attr, CompletionResultSet result) {
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        Intrinsics.checkExpressionValueIsNotNull((Object)prefixMatcher, (String)"result.prefixMatcher");
        String string = prefixMatcher.getPrefix();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.prefixMatcher.prefix");
        String prefix = string;
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)prefix, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDotIndex < 0) {
            CompletionResultSet completionResultSet = Intrinsics.areEqual((Object)prefix, (Object)"v-on:") ? result.withPrefixMatcher("") : result;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet, (String)"if (prefix == \"v-on:\") r\u2026ixMatcher(\"\") else result");
            CompletionResultSet newResult = completionResultSet;
            this.addEventCompletions(attr.getParent(), newResult, StringsKt.startsWith$default((String)prefix, (String)"@", (boolean)false, (int)2, null) ? "@" : "");
        } else {
            this.addModifierCompletions(result, prefix, lastDotIndex);
        }
    }

    private final void addEventCompletions(XmlTag tag, CompletionResultSet result, String prefix) {
        XmlTag xmlTag = tag;
        Object object = xmlTag != null ? xmlTag.getDescriptor() : null;
        if (!(object instanceof HtmlElementDescriptorImpl)) {
            object = null;
        }
        HtmlElementDescriptorImpl htmlElementDescriptorImpl = (HtmlElementDescriptorImpl)object;
        XmlElementDescriptor xmlElementDescriptor = htmlElementDescriptorImpl != null ? (XmlElementDescriptor)htmlElementDescriptorImpl : HtmlNSDescriptorImpl.guessTagForCommonAttributes((XmlTag)tag);
        if (xmlElementDescriptor == null) {
            return;
        }
        XmlElementDescriptor descriptor = xmlElementDescriptor;
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = descriptor.getAttributesDescriptors(tag);
        int n = xmlAttributeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String name;
            XmlAttributeDescriptor attrDescriptor;
            XmlAttributeDescriptor xmlAttributeDescriptor = attrDescriptor = xmlAttributeDescriptorArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttributeDescriptor, (String)"attrDescriptor");
            String string2 = name = xmlAttributeDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            if (!StringsKt.startsWith$default((String)string2, (String)"on", (boolean)false, (int)2, null)) continue;
            String string3 = name;
            int n2 = "on".length();
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            CompletionResultSet completionResultSet = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
            completionResultSet.addElement((LookupElement)LookupElementBuilder.create((String)stringBuilder.append(string).toString()).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        }
    }

    private final void addModifierCompletions(CompletionResultSet result, String prefix, int lastDotIndex) {
        String string = prefix;
        int n = lastDotIndex + 1;
        CompletionResultSet completionResultSet = result;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string3;
        CompletionResultSet completionResultSet2 = completionResultSet.withPrefixMatcher(string4);
        Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet2, (String)"result.withPrefixMatcher\u2026string(lastDotIndex + 1))");
        CompletionResultSet newResult = completionResultSet2;
        Collection<String> usedModifiers = this.getUsedModifiers(prefix, lastDotIndex);
        this.doAddModifierCompletions(newResult, usedModifiers, EVENT_MODIFIERS);
        if (this.isEventFromGroup(KEY_EVENTS, prefix)) {
            this.doAddModifierCompletions(newResult, usedModifiers, KEY_MODIFIERS);
        }
        if (this.isEventFromGroup(MOUSE_BUTTON_EVENTS, prefix)) {
            this.doAddModifierCompletions(newResult, usedModifiers, MOUSE_BUTTON_MODIFIERS);
        }
        if (this.isEventFromGroup(KEY_EVENTS, prefix) || this.isEventFromGroup(MOUSE_EVENTS, prefix)) {
            this.doAddModifierCompletions(newResult, usedModifiers, SYSTEM_MODIFIERS);
        }
    }

    private final Collection<String> getUsedModifiers(String prefix, int lastDotIndex) {
        SmartList usedModifiers = new SmartList();
        String string = prefix;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, lastDotIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substring = string3;
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)substring, (char)'.', (int)0, (boolean)false, (int)6, null);
        while (dotIndex > 0) {
            String string4;
            String string5 = substring;
            int n2 = dotIndex + 1;
            SmartList smartList = usedModifiers;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
            smartList.add((Object)string4);
            string5 = substring;
            n2 = 0;
            String string7 = string5;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n2, dotIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            dotIndex = StringsKt.lastIndexOf$default((CharSequence)substring, (char)'.', (int)0, (boolean)false, (int)6, null);
        }
        return (Collection)usedModifiers;
    }

    private final boolean isEventFromGroup(String[] eventGroup, String prefix) {
        String string;
        block1: {
            String[] stringArray;
            String[] stringArray2;
            String string2 = StringUtil.trimStart((String)prefix, (String)"@");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.trimStart(prefix, \"@\")");
            String trimmedPrefix = string2;
            for (String string3 : stringArray2 = (stringArray = eventGroup)) {
                String it = string3;
                if (!StringsKt.startsWith$default((String)trimmedPrefix, (String)(it + '.'), (boolean)false, (int)2, null)) continue;
                string = string3;
                break block1;
            }
            string = null;
        }
        return string != null;
    }

    private final void doAddModifierCompletions(CompletionResultSet result, Collection<String> usedModifiers, String[] modifiers) {
        String[] $receiver$iv;
        for (String element$iv : $receiver$iv = modifiers) {
            String it = element$iv;
            if (usedModifiers.contains(it)) continue;
            result.addElement((LookupElement)LookupElementBuilder.create((String)it));
        }
    }

    private final void addBindCompletions(XmlAttribute attr, CompletionResultSet result) {
        VueElementDescriptor vueElementDescriptor;
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        Intrinsics.checkExpressionValueIsNotNull((Object)prefixMatcher, (String)"result.prefixMatcher");
        String string = prefixMatcher.getPrefix();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.prefixMatcher.prefix");
        String prefix = string;
        CompletionResultSet completionResultSet = Intrinsics.areEqual((Object)prefix, (Object)"v-bind:") ? result.withPrefixMatcher("") : result;
        Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet, (String)"if (prefix == \"v-bind:\")\u2026ixMatcher(\"\") else result");
        CompletionResultSet newResult = completionResultSet;
        String lookupItemPrefix = StringsKt.startsWith$default((String)prefix, (String)":", (boolean)false, (int)2, null) ? ":" : "";
        newResult.addElement((LookupElement)LookupElementBuilder.create((String)(lookupItemPrefix + "is")).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        newResult.addElement((LookupElement)LookupElementBuilder.create((String)(lookupItemPrefix + "key")).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        for (XmlAttributeDescriptor attribute : VueElementDescriptor.Companion.getDefaultHtmlAttributes(attr.getParent())) {
            newResult.addElement((LookupElement)LookupElementBuilder.create((String)(lookupItemPrefix + attribute.getName())).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        }
        XmlTag xmlTag = attr.getParent();
        Object object = xmlTag != null ? xmlTag.getDescriptor() : null;
        if (!(object instanceof VueElementDescriptor)) {
            object = null;
        }
        if ((vueElementDescriptor = (VueElementDescriptor)object) == null || (vueElementDescriptor = vueElementDescriptor.getDeclaration()) == null) {
            return;
        }
        VueElementDescriptor jsElement = vueElementDescriptor;
        JSObjectLiteralExpression obj = VueComponents.Companion.findComponentDescriptor((JSImplicitElement)jsElement);
        VueComponentDetailsProvider vueComponentDetailsProvider = VueComponentDetailsProvider.Companion.getINSTANCE();
        Project project = attr.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"attr.project");
        for (VueAttributeDescriptor attribute : vueComponentDetailsProvider.getAttributes(obj, project, true, true)) {
            newResult.addElement((LookupElement)LookupElementBuilder.create((String)(lookupItemPrefix + attribute.getName())).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
        }
    }

    static {
        Companion = new Companion(null);
        KEY_MODIFIERS = new String[]{"enter", "tab", "delete", "esc", "space", "up", "down", "left", "right"};
        KEY_EVENTS = new String[]{"keydown", "keypress", "keyup"};
        MOUSE_BUTTON_MODIFIERS = new String[]{"left", "right", "middle"};
        MOUSE_BUTTON_EVENTS = new String[]{"click", "dblclick", "mousedown", "mouseup"};
        SYSTEM_MODIFIERS = new String[]{"ctrl", "alt", "shift", "meta", "exact"};
        MOUSE_EVENTS = new String[]{"click", "contextmenu", "dblclick", "mousedown", "mouseenter", "mouseleave", "mousemove", "mouseout", "mouseover", "mouseup", "show", "drag", "dragend", "dragenter", "dragleave", "dragover", "dragstart", "drop"};
        EVENT_MODIFIERS = new String[]{"stop", "prevent", "capture", "self", "once", "passive"};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/codeInsight/completion/VueEventAttrCompletionProvider$Companion;", "", "()V", "EVENT_MODIFIERS", "", "", "[Ljava/lang/String;", "KEY_EVENTS", "KEY_MODIFIERS", "MOUSE_BUTTON_EVENTS", "MOUSE_BUTTON_MODIFIERS", "MOUSE_EVENTS", "SYSTEM_MODIFIERS", "intellij.vuejs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

