/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramActionsListener;
import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.Utils;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphComponent;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlFileEditorImpl
extends UserDataHolderBase
implements DiagramFileEditor,
PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uml.UmlFileEditorImpl");
    private final UmlGraphComponent myPanel;
    private DiagramBuilder myBuilder;
    private final Graph2D myGraph;
    private final Object myElement;
    @NonNls
    private static final String NAME = "UML";
    private final DiagramState myState;
    private DiagramState myStateFromFile;
    private boolean initialized;
    private boolean fitOnStartupFlag = false;
    private final VirtualFile myFile;
    private final DiagramProvider myProvider;
    private DocumentReference myDocumentReference;
    private boolean myInitIsDone;
    private MessageBusConnection myBusConnection;
    private final Graph2DSelectionListener myListener;

    public UmlFileEditorImpl(Object element, boolean initialized, VirtualFile file, Project project) {
        this.initialized = initialized || ApplicationManager.getApplication().isUnitTestMode();
        this.myInitIsDone = initialized;
        this.myFile = file;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myDocumentReference = DocumentReferenceManager.getInstance().create(this.myFile);
        });
        this.myProvider = this.getProvider(file);
        assert (this.myProvider != null);
        Object object = this.myElement = element == null ? UmlFileEditorImpl.getFromFileState(this.myStateFromFile, project) : element;
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).setPresentableName(this.myProvider.getElementManager().getElementTitle(this.myElement));
        }
        DiagramBuilder diagramBuilder = this.myBuilder = file instanceof UmlVirtualFileSystem.UmlVirtualFile ? ((UmlVirtualFileSystem.UmlVirtualFile)file).getBuilder() : null;
        if (this.myBuilder == null || this.myBuilder.getEditor() != null) {
            DiagramBuilder prevBuilder = this.myBuilder;
            this.myBuilder = UmlGraphBuilderFactory.create(project, this.myProvider, this.myElement, this.myFile);
            if (prevBuilder != null && prevBuilder.getEditor() != null && !ReopenInfo.isContains(file)) {
                ReopenInfo.apply(prevBuilder, this.myBuilder, element);
                SwingUtilities.invokeLater(() -> {
                    prevBuilder.update(false, true);
                    prevBuilder.getView().fitContent();
                    prevBuilder.getGraph().updateViews();
                });
            }
        }
        ReopenInfo.apply(file, this.myBuilder, element);
        DiagramPresentationModel presentationModel = this.myBuilder.getPresentationModel();
        DiagramState fromFile = null;
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && ((UmlVirtualFileSystem.UmlVirtualFile)file).getState() != null) {
            fromFile = this.myState = ((UmlVirtualFileSystem.UmlVirtualFile)file).getState();
        } else {
            this.myState = presentationModel.getPresentation();
            if (this.myElement != null) {
                this.myState.setOriginalFQN(this.myProvider.getVfsResolver().getQualifiedName(this.myElement));
            }
            if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
                ((UmlVirtualFileSystem.UmlVirtualFile)file).setState(this.myState);
            }
        }
        this.myGraph = this.myBuilder.getGraph();
        this.myBuilder.setEditor((DiagramFileEditor)this);
        presentationModel.registerActions();
        ActionToolbar toolbar = UmlGraphComponent.createToolbarPanel(UmlActions.createToolbarActions(this.myBuilder));
        toolbar.setTargetComponent(this.myBuilder.getView().getJComponent());
        this.myPanel = new UmlGraphComponent(this.myBuilder, toolbar);
        Disposer.register((Disposable)this, (Disposable)this.myPanel);
        GraphViewUtil.addDataProvider((Graph2DView)this.myBuilder.getView(), (DataProvider)this);
        DataManager.registerDataProvider((JComponent)toolbar.getComponent(), (DataProvider)this);
        this.myBusConnection = project.getMessageBus().connect();
        this.myBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)UmlFileEditorImpl.createFileEditorListener(project, this.myFile, this.myBuilder));
        if (fromFile != null) {
            this.myStateFromFile = fromFile;
            this.myInitIsDone = false;
        }
        if (!this.myBuilder.getDataModel().isModelInitializationFinished()) {
            this.myBuilder.getDataModel().setupScopeManager(element, false);
            this.myBuilder.getDataModel().setModelInitializationFinished();
        }
        if (this.myStateFromFile != null) {
            this.setLayoutFromState(this.myStateFromFile);
            Runnable fileStateInitializer = () -> this.setUmlState(this.myStateFromFile);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                fileStateInitializer.run();
            } else {
                ApplicationManager.getApplication().invokeLater(fileStateInitializer);
            }
        }
        this.initialized = UmlVirtualFileSystem.isInitialized(file);
        this.myListener = UmlFileEditorImpl.createSelectionListener(this.myBuilder);
        this.myBuilder.getGraph().addGraph2DSelectionListener(this.myListener);
        if (this.isEditable()) {
            new DiagramListener(project, new ExternalChangeListener());
        }
    }

    @NotNull
    public static HintUpdateSupply createHintUpdateSupply(@NotNull JComponent canvasComponent) {
        if (canvasComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(0);
        }
        HintUpdateSupply hintUpdateSupply = new HintUpdateSupply(canvasComponent){

            @Nullable
            protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                return null;
            }
        };
        if (hintUpdateSupply == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(1);
        }
        return hintUpdateSupply;
    }

    @NotNull
    private static Graph2DSelectionListener createSelectionListener(final @NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(2);
        }
        JComponent canvasComponent = builder.getView().getCanvasComponent();
        final HintUpdateSupply supply = UmlFileEditorImpl.createHintUpdateSupply(canvasComponent);
        Graph2DSelectionListener graph2DSelectionListener = new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent _graph2DSelectionEvent) {
                if (!supply.shouldUpdateHint()) {
                    return;
                }
                for (Node node : GraphViewUtil.getSelectedNodes((Graph2D)builder.getGraph())) {
                    Object element;
                    DiagramNode diagramNode = builder.getNodeObject(node);
                    if (diagramNode == null || !((element = diagramNode.getIdentifyingElement()) instanceof PsiElement)) continue;
                    supply.updateHint((PsiElement)element);
                    return;
                }
            }
        };
        if (graph2DSelectionListener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(3);
        }
        return graph2DSelectionListener;
    }

    @NotNull
    public static FileEditorManagerListener createFileEditorListener(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull DiagramBuilder builder) {
        if (project == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(4);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(6);
        }
        FileEditorManagerListener fileEditorManagerListener = new FileEditorManagerListener(){
            long count;
            {
                this.count = builder.getDataModel().getModificationTracker().getModificationCount();
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (Comparing.equal((Object)event.getNewFile(), (Object)file) && this.count != builder.getDataModel().getModificationCount()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (builder == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        builder.update(false, true);
                    }, project.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$selectionChanged$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (fileEditorManagerListener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(7);
        }
        return fileEditorManagerListener;
    }

    @Nullable
    private static Object getFromFileState(DiagramState state, Project project) {
        DiagramProvider provider = DiagramProvider.findByID((String)state.getProviderID());
        return provider == null ? null : provider.getVfsResolver().resolveElementByFQN(state.getOriginalFQN(), project);
    }

    @Nullable
    public DiagramProvider getProvider(VirtualFile file) {
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            DiagramProvider umlProvider = ((UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider();
            if (umlProvider != null) {
                try {
                    return (DiagramProvider)umlProvider.getClass().newInstance();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else if (file.getFileSystem() instanceof LocalFileSystem) {
            try {
                this.myStateFromFile = DiagramState.read((InputStream)file.getInputStream());
                return DiagramProvider.findByID((String)this.myStateFromFile.getProviderID());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public boolean isEditable() {
        return !(this.myFile instanceof UmlVirtualFileSystem.UmlVirtualFile) && "uml".equalsIgnoreCase(this.myFile.getExtension());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((Graph2DView)this.myGraph.getCurrentView()).getCanvasComponent();
    }

    @NonNls
    @NotNull
    public String getName() {
        if (NAME == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(9);
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(10);
        }
        this.myState.update(this.myBuilder, false);
        DiagramState diagramState = this.myState;
        if (diagramState == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(11);
        }
        return diagramState;
    }

    public synchronized void setState(@NotNull FileEditorState editorState) {
        if (editorState == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(12);
        }
        if (!this.initialized && editorState instanceof DiagramState) {
            this.setUmlState((DiagramState)editorState);
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized && this.myInitIsDone;
    }

    private void setLayoutFromState(@NotNull DiagramState state) {
        DiagramExtras extras;
        if (state == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(13);
        }
        if ((extras = this.myProvider.getExtras()).useDefaultLayouter()) {
            return;
        }
        Project project = this.myBuilder.getProject();
        Layouter layouter = extras.getCustomLayouter(this.myBuilder.getPresentationModel().getSettings(), project);
        if (layouter != null) {
            return;
        }
        layouter = Utils.getLayouter((GraphSettings)this.myBuilder.getPresentationModel().getSettings(), (DiagramLayout)state.getLayout());
        this.myBuilder.getPresentationModel().getSettings().setCurrentLayouter(layouter);
    }

    public void setUmlState(DiagramState editorState) {
        DiagramNode umlNode;
        DiagramVisibilityManager visibilityManager;
        DiagramState state;
        DiagramState diagramState = state = this.myStateFromFile == null ? editorState : this.myStateFromFile;
        if (state == null) {
            return;
        }
        DiagramDataModel model = this.myBuilder.getDataModel();
        HashMap<String, DiagramNode> cache = new HashMap<String, DiagramNode>();
        DiagramVfsResolver resolver = this.myProvider.getVfsResolver();
        for (DiagramNode node : new ArrayList(model.getNodes())) {
            cache.put(resolver.getQualifiedName(node.getIdentifyingElement()), node);
            model.removeNode(node);
        }
        DiagramScopeManager scopeManager = model.getScopeManager();
        if (scopeManager != null) {
            String currentScope = state.getCurrentScope();
            scopeManager.setCurrentScope(currentScope);
        }
        if ((visibilityManager = model.getVisibilityManager()) != null) {
            String visibility = state.getCurrentVisibility();
            for (VisibilityLevel visibilityLevel : visibilityManager.getVisibilityLevels()) {
                if (!visibilityLevel.getName().equals(visibility)) continue;
                visibilityManager.setCurrentVisibilityLevel(visibilityLevel);
                break;
            }
        }
        model.refreshDataModel();
        model.removeAll();
        Project project = this.myBuilder.getProject();
        this.myState.copyFrom(state);
        for (VisibilityLevel visibilityLevel : state.getFQNs()) {
            umlNode = (DiagramNode)cache.get(visibilityLevel);
            if (umlNode == null) {
                Object cl = resolver.resolveElementByFQN((String)visibilityLevel, project);
                if (cl == null) continue;
                cache.put((String)visibilityLevel, model.addElement(cl));
                continue;
            }
            cache.put((String)visibilityLevel, model.addElement(umlNode.getIdentifyingElement()));
        }
        model.refreshDataModel();
        UmlFileEditorImpl.updateCache(model, cache, resolver);
        for (Map.Entry entry : state.getNotes().entrySet()) {
            DiagramNode node = (DiagramNode)cache.get(entry.getKey());
            if (node == null) continue;
            model.addNote(node, (String)entry.getValue());
        }
        this.myBuilder.updateGraph();
        for (Node node : GraphViewUtil.getSelectedNodes((Graph2D)this.myBuilder.getGraph())) {
            this.myBuilder.getGraph().setSelected(node, false);
        }
        for (String string : state.getSelectedNodes()) {
            Node node;
            umlNode = (DiagramNode)cache.get(string);
            if (umlNode == null || (node = this.myBuilder.getNode(umlNode)) == null) continue;
            this.myGraph.setSelected(node, true);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myBuilder.getPresentationModel().update());
        Runnable layoutInitializer = () -> {
            this.myBuilder.getView().setZoom(state.getZoom());
            this.myBuilder.getView().setCenter(state.getCenter().getX(), state.getCenter().getY());
            HashMap<DiagramNode, String> fqnCache = new HashMap<DiagramNode, String>();
            for (DiagramNode node : this.myBuilder.getNodeObjects()) {
                String fqn;
                if (node instanceof DiagramNoteNode) {
                    fqn = resolver.getQualifiedName(((DiagramNoteNode)node).getIdentifyingElement().getIdentifyingElement());
                    try {
                        Couple pair = (Couple)state.getNotesCoord().get(fqn);
                        this.myBuilder.getGraph().setLocation(this.myBuilder.getNode(node), ((Double)pair.first).doubleValue(), ((Double)pair.second).doubleValue());
                    }
                    catch (Exception pair) {}
                    continue;
                }
                fqn = resolver.getQualifiedName(node.getIdentifyingElement());
                if (fqn != null) {
                    fqnCache.put(node, fqn);
                }
                try {
                    double x = Double.parseDouble(state.getNodeX(fqn));
                    double y = Double.parseDouble(state.getNodeY(fqn));
                    this.myBuilder.getGraph().setLocation(this.myBuilder.getNode(node), x, y);
                }
                catch (Exception exception) {}
            }
            state.updateEdges(this.myBuilder, this.myGraph, fqnCache, false);
            this.myInitIsDone = true;
        };
        layoutInitializer.run();
        this.myStateFromFile = null;
    }

    private static void updateCache(DiagramDataModel model, Map<String, DiagramNode> cache, DiagramVfsResolver resolver) {
        for (DiagramNode node : model.getNodes()) {
            String fqn = resolver.getQualifiedName(node.getIdentifyingElement());
            if (!cache.containsKey(fqn)) continue;
            cache.put(fqn, node);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (!this.fitOnStartupFlag) {
            if (this.myElement != null) {
                this.myBuilder.getGraph().updateViews();
                ((Graph2DView)this.myGraph.getCurrentView()).fitContent();
            } else {
                this.myBuilder.updateGraph();
            }
            this.fitOnStartupFlag = true;
        }
        this.findAndSelectOriginNode();
    }

    private void findAndSelectOriginNode() {
        if (DiagramAction.getSelectedNodes((DiagramBuilder)this.myBuilder).size() > 0) {
            return;
        }
        for (Node node : this.myGraph.getNodeArray()) {
            DiagramNode umlNode = this.myBuilder.getNodeObject(node);
            if (umlNode == null || umlNode.getIdentifyingElement() != this.myElement) continue;
            this.myGraph.setSelected(node, true);
            return;
        }
        if (this.myGraph.N() > 0) {
            this.myGraph.setSelected(this.myGraph.firstNode(), true);
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(14);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(15);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        throw new UnsupportedOperationException("getCurrentLocation is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return GraphViewUtil.createStructureViewBuilder((Overview)GraphManager.getGraphManager().createOverview(this.myBuilder.getView()));
    }

    public void dispose() {
        if (this.myBusConnection != null) {
            this.myBusConnection.disconnect();
        }
        this.myBuilder.getGraph().removeGraph2DSelectionListener(this.myListener);
        ReopenInfo.copyIfNeeded(this.myFile, this.myBuilder);
        Disposer.dispose((Disposable)this.myBuilder);
        Disposer.dispose((Disposable)this.myPanel);
    }

    @NonNls
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        List selectedNodes;
        if (dataId == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(16);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myBuilder.getProject();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        if (FileChooserKeys.DELETE_ACTION_AVAILABLE.is(dataId)) {
            return false;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selectedNodes = DiagramAction.getSelectedNodes((DiagramBuilder)this.myBuilder)).size() > 0) {
            Point point = UmlUtils.getNodeCoordinatesOnScreen(this.myBuilder.getNode((DiagramNode)selectedNodes.get(0)), this.myBuilder.getView());
            SwingUtilities.convertPointFromScreen(point, this.myBuilder.getView().getCanvasComponent());
            return UmlUtils.getPointBeneathHeader(point, this.myBuilder);
        }
        return UmlFileEditorImpl.getData(dataId, this.myBuilder);
    }

    @NonNls
    @Nullable
    public static Object getData(@NonNls @NotNull String dataId, @NonNls DiagramBuilder myBuilder) {
        Object selectedElement;
        if (dataId == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(17);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return myBuilder.getProject();
        }
        DiagramProvider provider = myBuilder.getProvider();
        Graph2D myGraph = myBuilder.getGraph();
        DiagramExtras extras = provider.getExtras();
        List list = GraphViewUtil.getSelectedNodes((Graph2D)myGraph);
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        for (Node node : list) {
            DiagramNode umlNode = myBuilder.getNodeObject(node);
            if (umlNode == null || umlNode instanceof DiagramNoteNode) continue;
            nodes.add(umlNode);
        }
        Object data = extras.getData(dataId, nodes, myBuilder);
        if (data != null) {
            return data;
        }
        DiagramNodeEditorManager manager = DiagramNodeEditorManager.getInstance();
        NodeCellEditor editor = manager.getCurrentCellEditor();
        DiagramNode selectedNode = list.size() == 1 ? myBuilder.getNodeObject((Node)list.get(0)) : null;
        Object object = selectedElement = selectedNode == null ? null : selectedNode.getIdentifyingElement();
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (editor != null) {
                return manager.getData(dataId);
            }
            return selectedElement instanceof PsiElement && ((PsiElement)selectedElement).isValid() ? selectedElement : null;
        }
        if (SelectInContext.DATA_KEY.is(dataId)) {
            if (selectedElement instanceof PsiElement) {
                PsiDirectory[] directories;
                PsiFile psiFile = ((PsiElement)selectedElement).getContainingFile();
                if (psiFile != null) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null) {
                        return new FileSelectInContext(myBuilder.getProject(), virtualFile, null);
                    }
                } else if (selectedElement instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)selectedElement).getDirectories()).length > 0) {
                    return new FileSelectInContext(myBuilder.getProject(), directories[0].getVirtualFile(), null);
                }
            }
        } else {
            if (DiagramDataKeys.BUILDER.is(dataId)) {
                return myBuilder;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                if (editor != null) {
                    return manager.getData(dataId);
                }
                Object element = UmlFileEditorImpl.getData(CommonDataKeys.PSI_ELEMENT.getName(), myBuilder);
                if (element instanceof PsiElement) {
                    return ((PsiElement)element).getContainingFile();
                }
            } else {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    if (editor != null) {
                        return manager.getData(dataId);
                    }
                    return null;
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return "reference.uml.class.diagram";
                }
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    Graph2DView view = myBuilder.getView();
                    Component c = view.getComponent();
                    Point p = SwingUtilities.getRoot(c).getLocationOnScreen();
                    if (nodes.size() == 1) {
                        Point np = UmlUtils.getNodeCoordinatesOnScreen((Node)list.get(0), view);
                        np = UmlUtils.getPointBeneathHeader(np, myBuilder);
                        return new Rectangle(np.x - p.x, np.y - p.y, 0, 0);
                    }
                    Point sp = c.getLocationOnScreen();
                    return new Rectangle(sp.x - p.x + c.getWidth() / 3, sp.y - p.y + c.getHeight() * 3 / 7, 0, 0);
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    NodeCellEditor cellEditor = DiagramNodeEditorManager.getInstance().getCurrentCellEditor();
                    if (cellEditor != null) {
                        return DiagramNodeEditorManager.getInstance().getData(dataId);
                    }
                    ArrayList<NavigatablePsiElement> elements = new ArrayList<NavigatablePsiElement>();
                    for (Node node : list) {
                        Object element;
                        DiagramNode umlNode = myBuilder.getNodeObject(node);
                        if (umlNode == null || !((element = umlNode.getIdentifyingElement()) instanceof NavigatablePsiElement)) continue;
                        elements.add((NavigatablePsiElement)element);
                    }
                    if (!elements.isEmpty()) {
                        return elements.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
                    }
                }
            }
        }
        return null;
    }

    public DiagramBuilder getBuilder() {
        return this.myBuilder;
    }

    public Object getOriginalElement() {
        return this.myElement;
    }

    public VirtualFile getOriginalVirtualFile() {
        return this.myFile;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return this.myDocumentReference == null ? Collections.emptyList() : Arrays.asList(this.myDocumentReference);
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvasComponent";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintUpdateSupply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectionListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileEditorListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHintUpdateSupply";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSelectionListener";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditorListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutFromState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExternalChangeListener
    implements Disposable,
    VirtualFileListener {
        private boolean myHandleEvent = true;

        ExternalChangeListener() {
            UmlFileEditorImpl.this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)this);
            Disposer.register((Disposable)UmlFileEditorImpl.this.myPanel, (Disposable)this);
        }

        public void dispose() {
            UmlFileEditorImpl.this.myFile.getFileSystem().removeVirtualFileListener((VirtualFileListener)this);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                ExternalChangeListener.$$$reportNull$$$0(0);
            }
            if (!UmlFileEditorImpl.this.myFile.equals(event.getFile()) || !this.myHandleEvent) {
                return;
            }
            try {
                UmlFileEditorImpl.this.setUmlState(DiagramState.read((InputStream)UmlFileEditorImpl.this.myFile.getInputStream()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/UmlFileEditorImpl$ExternalChangeListener", "contentsChanged"));
        }
    }

    private class DiagramListener
    implements DiagramActionsListener,
    Disposable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ExternalChangeListener myExternalListener;

        DiagramListener(@NotNull Project project, ExternalChangeListener externalListener) {
            if (project == null) {
                DiagramListener.$$$reportNull$$$0(0);
            }
            if (externalListener == null) {
                DiagramListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myExternalListener = externalListener;
            DiagramActionsManager.getInstance((Project)project).addListener((DiagramActionsListener)this);
            Disposer.register((Disposable)UmlFileEditorImpl.this.myPanel, (Disposable)this);
        }

        public void dispose() {
            DiagramActionsManager.getInstance((Project)this.myProject).removeListener((DiagramActionsListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(DiagramBuilder builder, DiagramState oldState, PsiFile ... files) {
            if (builder == UmlFileEditorImpl.this.myBuilder) {
                try {
                    this.myExternalListener.myHandleEvent = false;
                    UmlFileEditorImpl.this.myFile.putUserData(UndoConstants.FORCE_RECORD_UNDO, (Object)Boolean.TRUE);
                    UmlFileEditorImpl.this.myState.update(UmlFileEditorImpl.this.myBuilder, false);
                    UmlFileEditorImpl.this.myState.saveTo(UmlFileEditorImpl.this.myFile, this.myProject);
                }
                finally {
                    UmlFileEditorImpl.this.myFile.putUserData(UndoConstants.FORCE_RECORD_UNDO, null);
                    this.myExternalListener.myHandleEvent = true;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "externalListener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/uml/UmlFileEditorImpl$DiagramListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

