/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.debug;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshDebugStrategy
extends PhpDebugStrategy {
    private final Project myProject;
    private final String myInterpreterId;
    private PhpPathMapper myMapper;
    private final PhpRemoteSdkAdditionalData mySshConnectionData;

    public PhpRemoteSshDebugStrategy(@NotNull Project project, @NotNull String interpreterId, @NotNull PhpRemoteSdkAdditionalData data, @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (project == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(0);
        }
        if (interpreterId == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(1);
        }
        if (data == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(2);
        }
        if (mappings == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myInterpreterId = interpreterId;
        this.mySshConnectionData = data;
        this.myMapper = PhpPathMapper.create(mappings);
    }

    @Nullable
    public PhpPathMapper getPathMapper() {
        return this.myMapper;
    }

    public void onCannotFindLocalPath(final @NotNull XCompositeNode node, final @NotNull String remoteFilePath, final Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(4);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(5);
        }
        this.mySshConnectionData.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder credentials) {
                node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.vagrant.cannot.find.path.mapping", remoteFilePath), null);
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder credentials) {
                String deployment = PhpRemoteSshDebugStrategy.this.mySshConnectionData.getRemoteConnectionPresentableName();
                node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.deployment.cannot.find.path.mapping", remoteFilePath, deployment) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditDeploymentMappingsHyperlink(PhpRemoteSshDebugStrategy.this.myProject, PhpRemoteSshDebugStrategy.this.mySshConnectionData, reloader));
            }
        }, new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder credentials) {
                node.setErrorMessage(PhpRemoteSdkBundle.message("remote.interpreter.ssh.cannot.find.path.mapping", remoteFilePath) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditDeploymentMappingsHyperlink(PhpRemoteSshDebugStrategy.this.myProject, PhpRemoteSshDebugStrategy.this.mySshConnectionData, reloader));
            }
        }});
    }

    public void onCannotFindLocalFile(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull String localPath, Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(6);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(7);
        }
        if (localPath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(8);
        }
        node.setErrorMessage(PhpBundle.message((String)"debug.process.cannot.find.local.file", (Object[])new Object[]{remoteFilePath, localPath}) + "\n", null);
    }

    public void onScriptOutsideProject(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull VirtualFile localFile, @NotNull Runnable reloader) {
        if (node == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(9);
        }
        if (remoteFilePath == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(10);
        }
        if (localFile == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(11);
        }
        if (reloader == null) {
            PhpRemoteSshDebugStrategy.$$$reportNull$$$0(12);
        }
        node.setMessage(PhpBundle.message((String)"debug.process.script.outside.project", (Object[])new Object[]{remoteFilePath}), UIUtil.getBalloonWarningIcon(), SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "onScriptOutsideProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class PhpEditDeploymentMappingsHyperlink
    extends XDebuggerTreeNodeHyperlink {
        private final Project myProject;
        private final PhpSdkAdditionalData mySdkAdditionalData;
        private final Runnable myReloader;

        PhpEditDeploymentMappingsHyperlink(@NotNull Project project, PhpSdkAdditionalData data, Runnable reloader) {
            if (project == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(1);
            }
            super(PhpRemoteSdkBundle.message("remote.interpreter.deployment.debug.edit.path.mappings", new Object[0]));
            this.myProject = project;
            this.mySdkAdditionalData = data;
            this.myReloader = reloader;
        }

        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                PhpEditDeploymentMappingsHyperlink.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        public void onClick(MouseEvent event) {
            DeploymentConfigurable configurable = new DeploymentConfigurable(this.myProject);
            boolean ok = PhpUiUtil.editConfigurable((Project)this.myProject, (Configurable)configurable);
            if (ok) {
                PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    PathMappingSettings newMappings = remoteInterpreterManager.createPathMappings(this.myProject, this.mySdkAdditionalData);
                    PhpRemoteSshDebugStrategy.this.myMapper = (PhpPathMapper)new PhpRemotePathMapper(newMappings.getPathMappings());
                }
                this.myReloader.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy$PhpEditDeploymentMappingsHyperlink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/remote/debug/PhpRemoteSshDebugStrategy$PhpEditDeploymentMappingsHyperlink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

