/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.phpunit.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.phpunit.coverage.PhpRemoteCoverageResultManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpSshCoverageResultManager
extends PhpRemoteCoverageResultManager {
    private static final Logger LOG = Logger.getInstance(PhpSshCoverageResultManager.class);
    private String myLocalCoverage;
    private String myTargetCoverage;

    public PhpSshCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (sdkData == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(0);
        }
        super(sdkData);
    }

    @NotNull
    public String processCoverageFile(@NotNull String localPath) {
        if (localPath == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(1);
        }
        this.myLocalCoverage = localPath;
        String string = this.myTargetCoverage = this.mySdkData.getHelpersPath() + "/" + FileUtil.sanitizeFileName((String)PathUtil.getFileName((String)localPath));
        if (string == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void copyFromRemote(@NotNull Project project) {
        if (project == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)this.myTargetCoverage) || StringUtil.isEmpty((String)this.myLocalCoverage)) {
            LOG.warn("Can not find target coverage report file: [" + this.myLocalCoverage + ", " + this.myTargetCoverage + "]");
            return;
        }
        List filesToTransfer = ContainerUtil.newSmartList((Object)new PathMappingSettings.PathMapping(this.myLocalCoverage, this.myTargetCoverage));
        try {
            new PhpRemoteTransfer(project, null, this.mySdkData.getRemoteSdkCredentials(project, false)).downloadFromRemote(filesToTransfer);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/phpunit/coverage/PhpSshCoverageResultManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/phpunit/coverage/PhpSshCoverageResultManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCoverageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCoverageFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

