/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HostConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<String> PREDEFINED_NETWORKS = Arrays.asList("bridge", "host", "none");
    @JsonProperty(value="Binds")
    private Binds binds;
    @JsonProperty(value="BlkioWeight")
    private Integer blkioWeight;
    @JsonProperty(value="BlkioWeightDevice")
    private List<Object> blkioWeightDevice;
    @JsonProperty(value="BlkioDeviceReadBps")
    private List<Object> blkioDeviceReadBps;
    @JsonProperty(value="BlkioDeviceReadIOps")
    private List<Object> blkioDeviceReadIOps;
    @JsonProperty(value="BlkioDeviceWriteBps")
    private List<Object> blkioDeviceWriteBps;
    @JsonProperty(value="BlkioDeviceWriteIOps")
    private List<Object> blkioDeviceWriteIOps;
    @JsonProperty(value="MemorySwappiness")
    private Integer memorySwappiness;
    @JsonProperty(value="CapAdd")
    private Capability[] capAdd;
    @JsonProperty(value="CapDrop")
    private Capability[] capDrop;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="CpuPeriod")
    private Integer cpuPeriod;
    @JsonProperty(value="CpuShares")
    private Integer cpuShares;
    @JsonProperty(value="CpuQuota")
    private Integer cpuQuota;
    @JsonProperty(value="CpusetCpus")
    private String cpusetCpus;
    @JsonProperty(value="CpusetMems")
    private String cpusetMems;
    @JsonProperty(value="Devices")
    private Device[] devices;
    @JsonProperty(value="DiskQuota")
    private Long diskQuota;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="DnsSearch")
    private String[] dnsSearch;
    @JsonProperty(value="ExtraHosts")
    private String[] extraHosts;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="LogConfig")
    private LogConfig logConfig;
    @JsonProperty(value="LxcConf")
    private LxcConf[] lxcConf;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="MemoryReservation")
    private Long memoryReservation;
    @JsonProperty(value="KernelMemory")
    private Long kernelMemory;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;
    @JsonProperty(value="AutoRemove")
    private Boolean autoRemove;
    @JsonProperty(value="OomScoreAdj")
    private Boolean oomScoreAdj;
    @JsonProperty(value="PortBindings")
    private Ports portBindings;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="ReadonlyRootfs")
    private Boolean readonlyRootfs;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="Ulimits")
    private Ulimit[] ulimits;
    @JsonProperty(value="VolumesFrom")
    private VolumesFrom[] volumesFrom;
    @JsonProperty(value="PidMode")
    private String pidMode;
    @JsonProperty(value="SecurityOpt")
    private List<String> securityOpts;
    @JsonProperty(value="CgroupParent")
    private String cgroupParent;
    @JsonProperty(value="VolumeDriver")
    private String volumeDriver;
    @JsonProperty(value="ShmSize")
    private Long shmSize;
    @JsonProperty(value="PidsLimit")
    private Long pidsLimit;
    @JsonProperty(value="Runtime")
    private String runtime;
    @JsonProperty(value="Tmpfs")
    private Map<String, String> tmpFs;

    @JsonIgnore
    public Bind[] getBinds() {
        return this.binds == null ? new Bind[]{} : this.binds.getBinds();
    }

    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    public Capability[] getCapAdd() {
        return this.capAdd;
    }

    public Capability[] getCapDrop() {
        return this.capDrop;
    }

    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public String getCpusetMems() {
        return this.cpusetMems;
    }

    public Device[] getDevices() {
        return this.devices;
    }

    public Long getDiskQuota() {
        return this.diskQuota;
    }

    public String[] getDns() {
        return this.dns;
    }

    public String[] getDnsSearch() {
        return this.dnsSearch;
    }

    public String[] getExtraHosts() {
        return this.extraHosts;
    }

    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.logConfig == null ? new LogConfig() : this.logConfig;
    }

    public LxcConf[] getLxcConf() {
        return this.lxcConf;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Ports getPortBindings() {
        return this.portBindings;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public Ulimit[] getUlimits() {
        return this.ulimits;
    }

    public VolumesFrom[] getVolumesFrom() {
        return this.volumesFrom;
    }

    @CheckForNull
    public String getPidMode() {
        return this.pidMode;
    }

    @CheckForNull
    public List<Object> getBlkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    @CheckForNull
    public List<Object> getBlkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    @CheckForNull
    public List<Object> getBlkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    @CheckForNull
    public List<Object> getBlkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    @CheckForNull
    public List<Object> getBlkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    @CheckForNull
    public Boolean getOomScoreAdj() {
        return this.oomScoreAdj;
    }

    @CheckForNull
    public Integer getCpuQuota() {
        return this.cpuQuota;
    }

    @CheckForNull
    public Long getKernelMemory() {
        return this.kernelMemory;
    }

    @CheckForNull
    public Long getMemoryReservation() {
        return this.memoryReservation;
    }

    @CheckForNull
    public Integer getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @CheckForNull
    public Boolean getOomKillDisable() {
        return this.oomKillDisable;
    }

    @CheckForNull
    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    @CheckForNull
    public List<String> getSecurityOpts() {
        return this.securityOpts;
    }

    @CheckForNull
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    @CheckForNull
    public Long getShmSize() {
        return this.shmSize;
    }

    @CheckForNull
    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    @CheckForNull
    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    @CheckForNull
    public Map<String, String> getTmpFs() {
        return this.tmpFs;
    }

    @JsonIgnore
    public boolean isUserDefinedNetwork() {
        return this.networkMode != null && !PREDEFINED_NETWORKS.contains(this.networkMode) && !this.networkMode.startsWith("container:");
    }

    public String getRuntime() {
        return this.runtime;
    }

    @JsonIgnore
    public void setBinds(Bind ... binds) {
        this.binds = new Binds(binds);
    }

    @JsonIgnore
    public void setLinks(Link ... links) {
        this.links = new Links(links);
    }

    public HostConfig withBinds(Binds binds) {
        this.binds = binds;
        return this;
    }

    public HostConfig withBlkioDeviceReadBps(List<Object> blkioDeviceReadBps) {
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        return this;
    }

    public HostConfig withBlkioDeviceReadIOps(List<Object> blkioDeviceReadIOps) {
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteBps(List<Object> blkioDeviceWriteBps) {
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteIOps(List<Object> blkioDeviceWriteIOps) {
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        return this;
    }

    public HostConfig withBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return this;
    }

    public HostConfig withBlkioWeightDevice(List<Object> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
        return this;
    }

    public HostConfig withCapAdd(Capability[] capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public HostConfig withCapDrop(Capability[] capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public HostConfig withCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    public HostConfig withContainerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
        return this;
    }

    public HostConfig withCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    public HostConfig withCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    public HostConfig withCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    public HostConfig withCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return this;
    }

    public HostConfig withCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    public HostConfig withDevices(Device[] devices) {
        this.devices = devices;
        return this;
    }

    public HostConfig withDiskQuota(Long diskQuota) {
        this.diskQuota = diskQuota;
        return this;
    }

    public HostConfig withDns(String[] dns) {
        this.dns = dns;
        return this;
    }

    public HostConfig withDnsSearch(String[] dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public HostConfig withExtraHosts(String[] extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    public HostConfig withKernelMemory(Long kernelMemory) {
        this.kernelMemory = kernelMemory;
        return this;
    }

    public HostConfig withLinks(Links links) {
        this.links = links;
        return this;
    }

    public HostConfig withLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public HostConfig withLxcConf(LxcConf[] lxcConf) {
        this.lxcConf = lxcConf;
        return this;
    }

    public HostConfig withMemory(Long memory) {
        this.memory = memory;
        return this;
    }

    public HostConfig withMemoryReservation(Long memoryReservation) {
        this.memoryReservation = memoryReservation;
        return this;
    }

    public HostConfig withMemorySwap(Long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    public HostConfig withMemorySwappiness(Integer memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return this;
    }

    public HostConfig withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public HostConfig withOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return this;
    }

    public HostConfig withAutoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    public HostConfig withOomScoreAdj(Boolean oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
        return this;
    }

    public HostConfig withPidMode(String pidMode) {
        this.pidMode = pidMode;
        return this;
    }

    public HostConfig withPortBindings(Ports portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    @CheckForNull
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public HostConfig withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @CheckForNull
    public Boolean getPublishAllPorts() {
        return this.publishAllPorts;
    }

    public HostConfig withPublishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        return this;
    }

    @CheckForNull
    public Boolean getReadonlyRootfs() {
        return this.readonlyRootfs;
    }

    public HostConfig withReadonlyRootfs(Boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
        return this;
    }

    public HostConfig withRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public HostConfig withSecurityOpts(List<String> securityOpts) {
        this.securityOpts = securityOpts;
        return this;
    }

    public HostConfig withShmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    public HostConfig withUlimits(Ulimit[] ulimits) {
        this.ulimits = ulimits;
        return this;
    }

    public HostConfig withVolumeDriver(String volumeDriver) {
        this.volumeDriver = volumeDriver;
        return this;
    }

    public HostConfig withVolumesFrom(VolumesFrom[] volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public HostConfig withPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return this;
    }

    public HostConfig withRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    public HostConfig withTmpFs(Map<String, String> tmpFs) {
        this.tmpFs = tmpFs;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

