/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class P4RootsInformationHolder
implements P4RootsInformation {
    private final MultiMap<P4Connection, VcsException> myExceptions;
    private final Map<P4Connection, PerforceClientRootsChecker.WrongRoots> myWrongRootsMap;
    private final Set<P4Connection> myNotAuthorized;

    public P4RootsInformationHolder(MultiMap<P4Connection, VcsException> exceptions, Map<P4Connection, PerforceClientRootsChecker.WrongRoots> wrongRootsMap, Set<P4Connection> notAuthorized) {
        this.myNotAuthorized = notAuthorized;
        this.myExceptions = new MultiMap();
        this.myExceptions.putAllValues(exceptions);
        this.myWrongRootsMap = new HashMap<P4Connection, PerforceClientRootsChecker.WrongRoots>(wrongRootsMap);
    }

    @Override
    public MultiMap<P4Connection, VcsException> getErrors() {
        return this.myExceptions;
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.myExceptions.isEmpty() || !this.myWrongRootsMap.isEmpty();
    }

    @Override
    public boolean hasNotAuthorized() {
        return !this.myNotAuthorized.isEmpty();
    }

    @Override
    public Map<P4Connection, PerforceClientRootsChecker.WrongRoots> getMap() {
        return this.myWrongRootsMap;
    }

    @Override
    public Set<P4Connection> getNotAuthorized() {
        return this.myNotAuthorized;
    }
}

