/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.TimeoutException;

public class Util {
    public static final long TIMEOUT_INFINITE = -1L;

    private Util() {
    }

    public static void showBalloon(Project project, String toolWindowId, MessageType type, String text) {
        ApplicationManager.getApplication().invokeLater(() -> ToolWindowManager.getInstance((Project)project).notifyByBalloon(toolWindowId, type, text));
    }

    public static void showBalloonError(Project project, String toolWindowId, String text) {
        Util.showBalloon(project, toolWindowId, MessageType.ERROR, text);
    }

    public static void showBalloonWarning(Project project, String toolWindowId, String text) {
        Util.showBalloon(project, toolWindowId, MessageType.WARNING, text);
    }

    public static String getPermissionsAsString(int permissons) {
        StringBuilder buf = new StringBuilder(10);
        buf.append(Util.test(permissons, 256) ? (char)'r' : '-');
        buf.append(Util.test(permissons, 128) ? (char)'w' : '-');
        buf.append(Util.test(permissons, 64) ? (char)'x' : '-');
        buf.append(Util.test(permissons, 32) ? (char)'r' : '-');
        buf.append(Util.test(permissons, 16) ? (char)'w' : '-');
        buf.append(Util.test(permissons, 8) ? (char)'x' : '-');
        buf.append(Util.test(permissons, 4) ? (char)'r' : '-');
        buf.append(Util.test(permissons, 2) ? (char)'w' : '-');
        buf.append(Util.test(permissons, 1) ? (char)'x' : '-');
        return buf.toString();
    }

    static String toOctalString(int permissions) {
        return String.format("%03o", permissions);
    }

    public static boolean test(int value, int mask) {
        return (value & mask) == mask;
    }

    public static <T> T runWithTimeout(long timeout, Computable<T> computable) throws TimeoutException {
        if (timeout <= 0L) {
            return (T)computable.compute();
        }
        Ref result = new Ref();
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                result.set(computable.compute());
            }
            finally {
                s.up();
            }
        });
        if (!s.waitFor(timeout)) {
            throw new TimeoutException();
        }
        return (T)result.get();
    }
}

