/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.application.Topics;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.UriUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerSettingsUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.AdvancedOptionsForm;
import com.jetbrains.plugins.webDeployment.ui.BrowseMountedFolderActionListener;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.Util;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.concurrent.TimeoutException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerConfigForm
implements UnnamedConfigurable,
Iconable {
    private static final Logger LOG = Logger.getInstance(WebServerConfigForm.class);
    private static final long VALIDATE_TIMEOUT = 200L;
    private static final long CHECK_PASSPHRASE_TIMEOUT_MS = 100L;
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myPortField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JCheckBox mySavePasswordCheckBox;
    private MultiLineLabel myMessageLabel;
    private JButton myTestConnectionButton;
    private JCheckBox myAnonymousCheckBox;
    private TextFieldWithBrowseButton myUrlField;
    private JLabel myPasswordLabel;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JLabel myPrivateKeyFileLabel;
    private JPasswordField myPassphraseField;
    private JLabel myPassphraseLabel;
    private JComboBox<AuthType> myAuthTypeCombo;
    private JLabel myAuthTypeLabel;
    private JCheckBox mySavePassphraseCheckbox;
    private JComboBox<AccessType> myAccessTypeCombo;
    private JLabel myHostLabel;
    private JLabel myRootFolderLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myRootFolderField;
    private JButton myAutodetectButton;
    private TextFieldWithBrowseButton myMountedFolderField;
    private JLabel myMountedFolderLabel;
    private JLabel myPortLabel;
    private JLabel myUsernameLabel;
    private JLabel myAccessTypeLabel;
    private HoverHyperlinkLabel myFixLink;
    private JLabel myAccessTypeDescriptionLabel;
    private JBCheckBox myProjectLevelCheckBox;
    private JPanel myUploadPanel;
    private AdvancedOptionsForm myAdvancedOptionsForm;
    private HideableTitledPanel myAdvancedSettingsPanel;
    private JPanel mySftpsSpacer;
    private boolean mySlowValidationTimedOut;
    private SettingsDeployable myItem;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final EventDispatcher<AccessTypeChangeListener> myAccessTypeEventDispatcher;
    private AccessType myPreviousAccessType;
    private String myForbiddenChildPath;
    private String myPreviousHostValue;
    private boolean myMuted;
    private final Disposable myDisposable;

    public WebServerConfigForm(SettingsDeployable item, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myAccessTypeEventDispatcher = EventDispatcher.create(AccessTypeChangeListener.class);
        this.myDisposable = Disposer.newDisposable((String)this.getClass().getName());
        this.myItem = item;
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myProjectLevelCheckBox.setVisible(project != null && !project.isDefault() && !this.myItem.isInGroup());
        this.updateAccessTypes(new AccessType[0]);
        this.myAccessTypeCombo.addActionListener(e -> {
            AccessType newAccessType = this.getSelectedAccessType();
            if (newAccessType == this.myPreviousAccessType) {
                return;
            }
            this.updateOnAccessTypeChange();
            this.myPreviousAccessType = newAccessType;
            ((AccessTypeChangeListener)this.myAccessTypeEventDispatcher.getMulticaster()).changed();
        });
        this.myAccessTypeCombo.setRenderer((ListCellRenderer<AccessType>)((Object)new AccessTypeComboRenderer()));
        this.myAnonymousCheckBox.addActionListener(e -> this.updateOnAnonymousChange());
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                WebServerConfigForm.this.fireChanged();
            }
        });
        this.myTestConnectionButton.addActionListener(e -> {
            String title = WDBundle.message("test.connection", this.getCurrentState().getAccessType().getTitle());
            this.testConnection(title, false, project);
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                WebServerConfigForm.this.updateNeedsPassphrase();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$2", "textChanged"));
            }
        });
        this.myPrivateKeyFileField.addActionListener(WebServerConfigForm.createBrowseListenerForPrivateKey(this.myPrivateKeyFileField));
        this.myAuthTypeCombo.setModel((ComboBoxModel<AuthType>)new CollectionComboBoxModel(Arrays.asList(AuthType.values()), (Object)AuthType.PASSWORD));
        this.myAuthTypeCombo.addActionListener(e -> this.updateOnAuthTypeChange());
        this.myAuthTypeCombo.setRenderer((ListCellRenderer<AuthType>)new ColoredListCellRenderer<AuthType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends AuthType> list, AuthType value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (value == AuthType.KEY_PAIR) {
                    this.append("Key pair ").append("OpenSSH or PuTTY", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value.getDisplayName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$3", "customizeCellRenderer"));
            }
        });
        this.myRootFolderLabel.setLabelFor(this.myRootFolderField.getTextField());
        this.myRootFolderField.addActionListener(e -> {
            WebServerConfig.RemotePath path;
            SettingsDeployable server = this.getCurrentState();
            if (!AuthHelper.ensureAuthSpecified(project, server, false, ConnectionOwnerFactory.createConnectionOwner((Component)this.myContentPane))) {
                return;
            }
            String title = WDBundle.message("choose.root.path", server.getName(), server.getHost());
            WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(this.myRootFolderField.getText());
            Project project1 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myRootFolderField));
            ServerBrowserDialog d = project1 != null ? new ServerBrowserDialog(project1, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)this.myRootFolderField, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath);
            d.show();
            this.updateAuth(server);
            if (d.isOK() && (path = d.getPath()) != null) {
                this.myRootFolderField.setText(path.path);
            }
        });
        this.myAutodetectButton.addActionListener(e -> {
            String homePath = this.testConnection(WDBundle.message("autodetect.root.path", new Object[0]), true, project);
            if (homePath != null) {
                this.myRootFolderField.setText(homePath);
            }
            FUSApplicationUsageTrigger.getInstance().trigger(ServerSettingsUsageTriggerCollector.class, "deploymentServerSettingsUI.AutodetectPathClick");
        });
        this.myUrlField.addActionListener(e -> {
            String text = this.myUrlField.getText();
            if (PublishUtils.validateUrl(text) == null) {
                BrowserUtil.browse((String)text);
            }
        });
        this.myUrlField.getButton().setText("Browse");
        this.myMountedFolderField.addBrowseFolderListener((TextBrowseFolderListener)new BrowseMountedFolderActionListener(new FileChooserDescriptor(false, true, false, true, false, false), null){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                WebServerConfigForm.this.mySlowValidationTimedOut = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$4", "onFileChosen"));
            }
        });
        this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                String url = StringUtil.trimStart((String)StringUtil.notNullize((String)WebServerConfigForm.this.myUrlField.getText()), (String)"http://");
                String newHost = WebServerConfigForm.this.myHostField.getText();
                if (!WebServerConfigForm.this.myMuted && Comparing.equal((String)url, (String)WebServerConfigForm.this.myPreviousHostValue)) {
                    String urlFieldContent = newHost.startsWith("http://") || newHost.startsWith("https://") ? newHost : "http://" + newHost;
                    WebServerConfigForm.this.myUrlField.setText(urlFieldContent);
                }
                WebServerConfigForm.this.myPreviousHostValue = newHost;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$5", "textChanged"));
            }
        });
        this.getFixLink().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                        WebServerConfigForm.this.updateWarning(true);
                    }, WDBundle.message("validating.server", new Object[0]), false, null, (JComponent)WebServerConfigForm.this.myContentPane);
                }
            }
        });
        boolean passwordSafeSaves = WebServerConfigForm.showSaveCheckboxed();
        this.mySavePasswordCheckBox.setVisible(passwordSafeSaves);
        this.mySavePassphraseCheckbox.setVisible(passwordSafeSaves);
        if (!passwordSafeSaves) {
            this.myItem.updateCredentialsFromPasswordSafe();
        }
        this.myProjectLevelCheckBox.addActionListener(event -> FUSApplicationUsageTrigger.getInstance().trigger(ServerSettingsUsageTriggerCollector.class, "deploymentServerSettingsUI.ProjectIDELevelCheckBoxClick"));
        Topics.subscribe((Topic)PasswordSafeSettings.TOPIC, (Disposable)this.myDisposable, (Object)new PasswordSafeSettingsListener(){

            public void typeChanged(@NotNull ProviderType oldValue, @NotNull ProviderType newValue) {
                boolean phrase;
                boolean word;
                if (oldValue == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (newValue == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (oldValue == newValue) {
                    return;
                }
                if (newValue != ProviderType.KEYCHAIN) {
                    word = false;
                    phrase = false;
                } else {
                    AccessType type = WebServerConfigForm.this.getSelectedAccessType();
                    if (type == AccessType.FTP || type == AccessType.FTPS) {
                        word = true;
                        phrase = false;
                    } else if (type == AccessType.SFTP) {
                        Object myAuthTypeComboSelectedItem = WebServerConfigForm.this.myAuthTypeCombo.getSelectedItem();
                        word = myAuthTypeComboSelectedItem == AuthType.PASSWORD;
                        phrase = myAuthTypeComboSelectedItem == AuthType.KEY_PAIR;
                    } else {
                        word = false;
                        phrase = false;
                    }
                }
                WebServerConfigForm.this.mySavePasswordCheckBox.setVisible(word);
                if (!word) {
                    WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                }
                WebServerConfigForm.this.mySavePassphraseCheckbox.setVisible(phrase);
                if (!phrase) {
                    WebServerConfigForm.this.mySavePassphraseCheckbox.setSelected(false);
                }
            }

            public void credentialStoreCleared() {
                WebServerConfigForm.this.myUsernameField.setText(null);
                WebServerConfigForm.this.myPassphraseField.setText(null);
                WebServerConfigForm.this.mySavePassphraseCheckbox.setSelected(false);
                WebServerConfigForm.this.myPasswordField.setText(null);
                WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                WebServerConfigForm.this.myItem.updateCredentialsFromPasswordSafe();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newValue";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$7";
                objectArray[2] = "typeChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean showSaveCheckboxed() {
        return !PasswordSafe.getInstance().isMemoryOnly();
    }

    @NotNull
    public static ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createBrowseListenerForPrivateKey(@NotNull TextFieldWithBrowseButton privateKeyFileField) {
        if (privateKeyFileField == null) {
            WebServerConfigForm.$$$reportNull$$$0(0);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
        descriptor.setHideIgnored(false);
        descriptor.withShowHiddenFiles(true);
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseFolderActionListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(WDBundle.message("choose.private.key", new Object[0]), "", (ComponentWithBrowseButton)privateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initial = super.getInitialFile();
                if (initial != null) {
                    return initial;
                }
                return this.getSshHome();
            }

            @Nullable
            private VirtualFile getSshHome() {
                String userHome = SystemProperties.getUserHome();
                if (StringUtil.isEmpty((String)userHome)) {
                    return null;
                }
                File file = new File(userHome, ".ssh");
                if (!file.exists()) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        };
        if (browseFolderActionListener == null) {
            WebServerConfigForm.$$$reportNull$$$0(1);
        }
        return browseFolderActionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuth(@NotNull SettingsDeployable server) {
        if (server == null) {
            WebServerConfigForm.$$$reportNull$$$0(2);
        }
        this.myMuted = true;
        try {
            String password;
            Credentials credentials = server.getCredentials();
            String string = password = credentials == null ? null : credentials.getPasswordAsString();
            if (server.getAccessType() == AccessType.SFTP && server.getAuthType() == AuthType.KEY_PAIR) {
                this.myPassphraseField.setText(password);
            } else if (server.getAccessType().isProtocolBased()) {
                this.myPasswordField.setText(password);
            }
            String username = credentials == null ? null : credentials.getUserName();
            this.myUsernameField.setText(username);
        }
        finally {
            this.myMuted = false;
        }
    }

    public void fireChanged() {
        if (!this.myMuted) {
            SettingsDeployable effective = this.updateUi();
            ((Listener)this.myEventDispatcher.getMulticaster()).changed(effective);
        }
    }

    public void updateAccessTypes(AccessType ... accessTypes) {
        EnumComboBoxModel comboModel;
        if (accessTypes.length == 0) {
            comboModel = new EnumComboBoxModel(AccessType.class);
        } else {
            ArrayList<AccessType> list = new ArrayList<AccessType>();
            for (AccessType accessType : AccessType.values()) {
                if (!ArrayUtil.contains((Object)((Object)accessType), (Object[])accessTypes)) continue;
                list.add(accessType);
            }
            comboModel = new CollectionComboBoxModel(list, list.get(0));
        }
        this.myAccessTypeCombo.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeLabel.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeCombo.setModel((ComboBoxModel<AccessType>)comboModel);
        this.updateOnAccessTypeChange();
        this.updateOnAuthTypeChange();
    }

    public void setItem(SettingsDeployable item) {
        this.myItem = item;
        this.reset();
    }

    @Nullable
    private String testConnection(String title, boolean detectHomePath, Project project) {
        SettingsDeployable serverConfig = this.getCurrentState();
        if (!AuthHelper.ensureAuthSpecified(project, serverConfig, false, ConnectionOwnerFactory.createConnectionOwner((Component)this.myContentPane))) {
            return null;
        }
        try {
            String homePath = PublishUtils.testConnection(serverConfig, this.myContentPane, title, false);
            if (!detectHomePath) {
                Messages.showInfoMessage((String)WDBundle.message("connection.to.successful", serverConfig.getHost()), (String)title);
            }
            if (!serverConfig.isAnonymous()) {
                Credentials credentials = serverConfig.getCredentials();
                String password = credentials == null ? null : credentials.getPasswordAsString();
                boolean isStorePassword = !serverConfig.isPassMemoryOnly();
                this.myUsernameField.setText(credentials == null ? null : credentials.getUserName());
                if (serverConfig.getAccessType() == AccessType.SFTP && serverConfig.getAuthType() == AuthType.KEY_PAIR) {
                    this.myPassphraseField.setText(password);
                    this.mySavePassphraseCheckbox.setSelected(isStorePassword);
                } else {
                    this.myPasswordField.setText(password);
                    this.mySavePasswordCheckBox.setSelected(isStorePassword);
                }
            }
            return homePath;
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((String)WDBundle.message("connection.to.failed", serverConfig.getHost(), StringUtil.capitalize((String)PublishUtils.getMessage(e, false))), (String)title);
            return null;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    private void updateNeedsPassphrase() {
        boolean needsPassphrase;
        String privateKeyPath = this.myPrivateKeyFileField.getText();
        if (StringUtil.isEmpty((String)privateKeyPath)) {
            boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
            this.myPasswordField.setEnabled(!isAnonymous);
            this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
            return;
        }
        try {
            needsPassphrase = (Boolean)Util.runWithTimeout(100L, () -> WebServerConfigForm.needsKeyPassphrase(privateKeyPath));
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to check key for passphrase: " + privateKeyPath);
            needsPassphrase = true;
        }
        if (needsPassphrase) {
            if (!this.myPassphraseField.isEnabled()) {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(true);
                this.mySavePassphraseCheckbox.setEnabled(true);
            }
        } else {
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setEnabled(false);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.mySavePassphraseCheckbox.setEnabled(false);
        }
    }

    private static boolean needsKeyPassphrase(@NotNull String privateKeyPath) {
        if (privateKeyPath == null) {
            WebServerConfigForm.$$$reportNull$$$0(3);
        }
        boolean needsPassphrase = true;
        File file = new File(privateKeyPath);
        if (file.isFile() && file.canRead()) {
            try {
                KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                needsPassphrase = keyPair == null || keyPair.isEncrypted();
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
        return needsPassphrase;
    }

    private void updateOnAuthTypeChange() {
        if (!this.getSelectedAccessType().isProtocolBased()) {
            return;
        }
        if (this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(WebServerConfigForm.showSaveCheckboxed());
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText(null);
            int width = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(width, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else if (this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR) {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(WebServerConfigForm.showSaveCheckboxed());
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText(null);
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        }
    }

    @NotNull
    private AccessType getSelectedAccessType() {
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        if (accessType == null) {
            WebServerConfigForm.$$$reportNull$$$0(4);
        }
        return accessType;
    }

    private void updateOnAnonymousChange() {
        boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
        this.myUsernameField.setEnabled(!isAnonymous);
        this.myPasswordField.setEnabled(!isAnonymous);
        this.myPassphraseField.setEnabled(!isAnonymous);
        this.myPrivateKeyFileField.setEnabled(!isAnonymous);
        this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
        this.mySavePassphraseCheckbox.setEnabled(!isAnonymous);
        this.myAuthTypeCombo.setEnabled(!isAnonymous);
        if (isAnonymous) {
            this.myUsernameField.setText("anonymous");
            this.myPasswordField.setText(null);
            this.mySavePasswordCheckBox.setSelected(false);
            this.myPrivateKeyFileField.setText(null);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.myAuthTypeCombo.setSelectedItem(AuthType.PASSWORD);
        } else {
            this.myUsernameField.setText(null);
        }
    }

    private void updateOnAccessTypeChange() {
        boolean ftpSftp;
        AccessType accessType = this.getSelectedAccessType();
        if (accessType == AccessType.FTP) {
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AuthType.PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.SFTP) {
            boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
            if (isAnonymous) {
                this.myAnonymousCheckBox.setSelected(false);
                this.myUsernameField.setText(null);
            }
            this.myUsernameField.setEnabled(!isAnonymous);
            this.myPasswordField.setEnabled(!isAnonymous);
            this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
            this.myAuthTypeLabel.setVisible(true);
            this.myAuthTypeCombo.setVisible(true);
            this.myUploadPanel.setVisible(true);
            ftpSftp = true;
        } else if (accessType == AccessType.FTPS) {
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AuthType.PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.MOUNT) {
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myUploadPanel.setVisible(true);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        } else {
            this.myUploadPanel.setVisible(false);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        }
        this.myTestConnectionButton.setVisible(ftpSftp);
        this.myHostLabel.setVisible(ftpSftp);
        this.myHostField.setVisible(ftpSftp);
        this.myPortLabel.setVisible(ftpSftp);
        this.myPortField.setVisible(ftpSftp);
        this.myRootFolderLabel.setVisible(ftpSftp);
        this.myRootFolderField.setVisible(ftpSftp);
        this.myAutodetectButton.setVisible(ftpSftp);
        this.myUsernameLabel.setVisible(ftpSftp);
        this.myUsernameField.setVisible(ftpSftp);
        this.myAnonymousCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myPasswordLabel.setVisible(ftpSftp);
        this.myPasswordField.setVisible(ftpSftp);
        this.myPassphraseLabel.setVisible(accessType == AccessType.SFTP);
        this.myPassphraseField.setVisible(accessType == AccessType.SFTP);
        this.mySavePasswordCheckBox.setVisible(ftpSftp && WebServerConfigForm.showSaveCheckboxed());
        this.mySavePassphraseCheckbox.setVisible(accessType == AccessType.SFTP && WebServerConfigForm.showSaveCheckboxed());
        this.myAdvancedSettingsPanel.setVisible(ftpSftp);
        this.myPrivateKeyFileLabel.setVisible(ftpSftp);
        this.myPrivateKeyFileField.setVisible(ftpSftp);
        this.mySftpsSpacer.setVisible(ftpSftp);
        this.myMountedFolderLabel.setVisible(!ftpSftp);
        this.myMountedFolderField.setVisible(!ftpSftp);
        if (ftpSftp) {
            this.myPortField.setText(String.valueOf(accessType.getDefaultPort()));
            if (StringUtil.isEmpty((String)this.myRootFolderField.getText()) || this.myPreviousAccessType != null && this.myPreviousAccessType.getDefaultRootFolder().equals(this.myRootFolderField.getText())) {
                this.myRootFolderField.setText(accessType.getDefaultRootFolder());
            }
            this.updateOnAuthTypeChange();
        }
        this.myAccessTypeDescriptionLabel.setText(accessType.getDescription());
        this.myAdvancedOptionsForm.updateOnAccessTypeChange(accessType);
    }

    public JComponent createComponent() {
        return this.myContentPane;
    }

    public boolean isModified() {
        if (!Comparing.equal((String)this.myItem.getUrl(), (String)this.myUrlField.getText()) || this.myItem.isProjectLevel() != this.myProjectLevelCheckBox.isSelected()) {
            return true;
        }
        if (this.myItem.getAccessType() != this.myAccessTypeCombo.getSelectedItem() || !Comparing.strEqual((String)this.myItem.getHost(), (String)this.getHost()) || !Comparing.strEqual((String)this.myItem.getLiteralPort(), (String)this.myPortField.getText()) || this.myItem.isAnonymous() != this.myAnonymousCheckBox.isSelected()) {
            return true;
        }
        if (!this.myItem.isAnonymous()) {
            boolean isFormPassSaved;
            String password;
            String username;
            Credentials credentials = this.myItem.getCredentials();
            if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getUserName()), (String)(username = StringUtil.notNullize((String)this.myUsernameField.getText()).trim())) || this.myItem.getAuthType() != this.getSelectedAuthType() || !Comparing.strEqual((String)this.myItem.getPrivateKeyFile(), (String)this.myPrivateKeyFileField.getText())) {
                return true;
            }
            if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getPasswordAsString()), (String)(password = new String(this.getPassword(this.myItem))))) {
                return true;
            }
            boolean bl = isFormPassSaved = this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR ? this.mySavePassphraseCheckbox.isSelected() : this.mySavePasswordCheckBox.isSelected();
            if (this.myItem.isPassMemoryOnly() == isFormPassSaved) {
                return true;
            }
        }
        if (this.myAdvancedOptionsForm.isModified(this.myItem)) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getRootFolder()), (String)this.myRootFolderField.getText())) {
            return true;
        }
        return !Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getMountedFolder()), (String)StringUtil.notNullize((String)this.getMountedFolder()));
    }

    @NotNull
    private AuthType getSelectedAuthType() {
        AuthType authType = (AuthType)this.myAuthTypeCombo.getSelectedItem();
        if (authType == null) {
            WebServerConfigForm.$$$reportNull$$$0(5);
        }
        return authType;
    }

    public void apply() {
        this.applyTo(this.myItem, true);
    }

    @Nullable
    private String getHost() {
        String host = this.myHostField.getText();
        if (host != null) {
            host = UriUtil.trimTrailingSlashes((String)host);
        }
        return host;
    }

    public void applyTo(@NotNull SettingsDeployable serverConfig, boolean isApplyCredentials) {
        if (serverConfig == null) {
            WebServerConfigForm.$$$reportNull$$$0(6);
        }
        serverConfig.setUrl(this.myUrlField.getText());
        if (this.myProjectLevelCheckBox.isVisible()) {
            serverConfig.setIsProjectLevel(this.myProjectLevelCheckBox.isSelected());
        }
        AccessType accessType = this.getSelectedAccessType();
        serverConfig.setAccessType(accessType);
        if (accessType.isProtocolBased()) {
            serverConfig.setHost(this.getHost());
            serverConfig.setLiteralPort(this.myPortField.getText());
            serverConfig.setAuthType(this.getSelectedAuthType());
            serverConfig.setPrivateKeyFile(serverConfig.getAuthType() == AuthType.KEY_PAIR ? this.myPrivateKeyFileField.getText() : null);
            if (this.myAnonymousCheckBox.isSelected()) {
                serverConfig.setAnonymous(true);
                serverConfig.setCredentials(null, false, isApplyCredentials, false);
            } else {
                serverConfig.setAnonymous(false);
                char[] password = this.getPassword(serverConfig);
                boolean memoryOnly = this.isMemoryOnly(serverConfig);
                if (memoryOnly && password.length == 0) {
                    password = null;
                }
                String userName = StringUtil.nullize((String)this.myUsernameField.getText());
                Credentials credentials = new Credentials(userName, password);
                serverConfig.setCredentials(credentials, memoryOnly, isApplyCredentials, false);
            }
            this.myAdvancedOptionsForm.apply(serverConfig);
            serverConfig.setRootFolder(this.myRootFolderField.getText());
            serverConfig.setMountedFolder(null);
        } else {
            serverConfig.eraseCredentialsFromPasswordSafe();
            serverConfig.setHost(null);
            serverConfig.setPort(0);
            serverConfig.setAnonymous(false);
            serverConfig.setRootFolder(new FileTransferConfig().getRootFolder());
            serverConfig.setAuthType(AuthType.PASSWORD);
            serverConfig.setPrivateKeyFile(null);
            serverConfig.setAdvancedOptions(new AdvancedOptionsConfig());
            if (accessType == AccessType.MOUNT) {
                serverConfig.setMountedFolder(this.getMountedFolder());
            } else {
                serverConfig.setMountedFolder(null);
            }
        }
    }

    @NotNull
    private char[] getPassword(@NotNull SettingsDeployable serverConfig) {
        if (serverConfig == null) {
            WebServerConfigForm.$$$reportNull$$$0(7);
        }
        switch (serverConfig.getAuthType()) {
            case KEY_PAIR: {
                char[] cArray = this.myPassphraseField.getPassword();
                if (cArray == null) {
                    WebServerConfigForm.$$$reportNull$$$0(8);
                }
                return cArray;
            }
            case PASSWORD: {
                char[] cArray = this.myPasswordField.getPassword();
                if (cArray == null) {
                    WebServerConfigForm.$$$reportNull$$$0(9);
                }
                return cArray;
            }
        }
        char[] cArray = new char[]{};
        if (cArray == null) {
            WebServerConfigForm.$$$reportNull$$$0(10);
        }
        return cArray;
    }

    private boolean isMemoryOnly(@NotNull SettingsDeployable serverConfig) {
        if (serverConfig == null) {
            WebServerConfigForm.$$$reportNull$$$0(11);
        }
        switch (serverConfig.getAuthType()) {
            case KEY_PAIR: {
                return !this.mySavePassphraseCheckbox.isSelected();
            }
            case PASSWORD: {
                return !this.mySavePasswordCheckBox.isSelected();
            }
        }
        return true;
    }

    public String getMountedFolder() {
        String s = this.myMountedFolderField.getText();
        if (StringUtil.isEmpty((String)s)) {
            return s;
        }
        return new File(s).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.myMuted = true;
        try {
            this.myUrlField.setText(this.myItem.getUrl());
            this.myProjectLevelCheckBox.setSelected(this.myItem.isProjectLevel());
            this.myRootFolderField.setText(this.myItem.getRootFolder());
            this.myHostField.setText(this.myItem.getHost());
            this.myPreviousHostValue = this.myHostField.getText();
            this.myAccessTypeCombo.setSelectedItem((Object)this.myItem.getAccessType());
            this.updateOnAccessTypeChange();
            this.myPortField.setText(this.myItem.getLiteralPort());
            this.myAnonymousCheckBox.setSelected(this.myItem.isAnonymous());
            this.updateOnAnonymousChange();
            if (!this.myItem.isAnonymous()) {
                this.myItem.updateCredentialsFromPasswordSafe();
                Credentials credentials = this.myItem.getCredentials();
                String userName = credentials == null ? "" : credentials.getUserName();
                this.myUsernameField.setText(userName);
                String password = credentials == null ? "" : credentials.getPasswordAsString();
                this.myPasswordField.setText(password);
                this.myPassphraseField.setText(password);
                boolean isStorePassword = !this.myItem.isPassMemoryOnly();
                this.mySavePasswordCheckBox.setSelected(isStorePassword);
                this.mySavePassphraseCheckbox.setSelected(isStorePassword);
            }
            this.myPrivateKeyFileField.setText(this.myItem.getPrivateKeyFile());
            AuthType item = this.myItem.getAuthType();
            this.myAuthTypeCombo.setSelectedItem(item);
            this.myAdvancedOptionsForm.reset(this.myItem);
            this.myMountedFolderField.setText(this.myItem.getMountedFolder());
            this.updateOnAuthTypeChange();
            this.updateNeedsPassphrase();
            this.myAdvancedSettingsPanel.setOn(!WebServerConfigForm.isDefaultAdvancedSettings(this.myItem));
            this.mySlowValidationTimedOut = false;
            this.updateUi();
        }
        finally {
            this.myMuted = false;
        }
    }

    private static boolean isDefaultAdvancedSettings(@NotNull SettingsDeployable item) {
        AccessType type;
        if (item == null) {
            WebServerConfigForm.$$$reportNull$$$0(12);
        }
        if ((type = item.getAccessType()) != AccessType.FTP && type != AccessType.FTPS && type != AccessType.SFTP) {
            return true;
        }
        WebServerConfig config = new WebServerConfig();
        config.initializeNewCreatedServer(false);
        if (type == AccessType.FTPS && item.isFtpsExplicit() != config.getFileTransferConfig().isFtpsExplicit()) {
            return false;
        }
        AdvancedOptionsConfig options = item.getAdvancedOptions();
        AdvancedOptionsConfig defaultOptions = config.getFileTransferConfig().getAdvancedOptions();
        if (options.getMaxConnections() != defaultOptions.getMaxConnections()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)options.getControlEncoding(), (CharSequence)defaultOptions.getControlEncoding())) {
            return false;
        }
        if (options.getKeepAliveTimeout() != defaultOptions.getKeepAliveTimeout()) {
            return false;
        }
        if (type == AccessType.FTP || type == AccessType.FTPS) {
            if (options.isPassiveMode() != defaultOptions.isPassiveMode()) {
                return false;
            }
            if (options.isShowHiddenFiles() != defaultOptions.isShowHiddenFiles()) {
                return false;
            }
            if (options.getAccurateTimestamps() != defaultOptions.getAccurateTimestamps()) {
                return false;
            }
            if (options.isCompatibilityMode() != defaultOptions.isCompatibilityMode()) {
                return false;
            }
            if (options.isForceListCommand() != defaultOptions.isForceListCommand()) {
                return false;
            }
            if (options.getKeepAliveFtpCommand() != options.getKeepAliveFtpCommand()) {
                return false;
            }
        }
        if (type == AccessType.FTPS) {
            if (options.getDataChannelProtectionLevel() != defaultOptions.getDataChannelProtectionLevel()) {
                return false;
            }
            if (options.isShareSslContext() != defaultOptions.isShareSslContext()) {
                return false;
            }
        }
        return type != AccessType.SFTP || options.isMuteSftpMessages() == defaultOptions.isMuteSftpMessages();
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent[] fields;
        for (JComponent field : fields = new JComponent[]{this.myHostField, this.myPortField, this.myRootFolderField, this.myUsernameField, this.myPasswordField, this.myPrivateKeyFileField, this.myPassphraseField, this.myMountedFolderField, this.myUrlField}) {
            String text;
            String string = text = field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getText() : ((JTextField)field).getText();
            if (field == this.myUrlField && "http://".equals(text)) {
                text = null;
            }
            if (!field.isEnabled() || !field.isVisible() || !StringUtil.isEmpty((String)text)) continue;
            return field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getTextField() : field;
        }
        for (JComponent field : fields) {
            if (!field.isVisible()) continue;
            return field;
        }
        return fields[0];
    }

    @NotNull
    private SettingsDeployable updateUi() {
        SettingsDeployable serverConfig = this.updateWarning(false);
        if (serverConfig == null) {
            serverConfig = this.getCurrentState();
        }
        boolean canConnect = serverConfig.validateFastInternal(false) == null;
        this.myTestConnectionButton.setEnabled(canConnect);
        this.myAutodetectButton.setEnabled(canConnect);
        this.myRootFolderField.getButton().setEnabled(canConnect);
        SettingsDeployable settingsDeployable = serverConfig;
        if (settingsDeployable == null) {
            WebServerConfigForm.$$$reportNull$$$0(13);
        }
        return settingsDeployable;
    }

    public void setForbiddenChildPath(String forbiddenChildPath) {
        this.myForbiddenChildPath = forbiddenChildPath;
    }

    @Nullable
    private SettingsDeployable updateWarning(boolean forceSlow) {
        if (!forceSlow && this.mySlowValidationTimedOut) {
            return null;
        }
        String errorMessage = null;
        if (!this.myAnonymousCheckBox.isSelected() && StringUtil.isEmpty((String)this.myUsernameField.getText()) && this.getSelectedAccessType().isProtocolBased()) {
            errorMessage = WDBundle.message("username.is.empty", new Object[0]);
        }
        if (errorMessage == null) {
            errorMessage = this.myAdvancedOptionsForm.getErrorMessage();
        }
        SettingsDeployable currentState = null;
        if (errorMessage == null) {
            File path;
            File mountedFolder;
            currentState = this.getCurrentState();
            try {
                errorMessage = currentState.validateSlow(forceSlow ? -1L : 200L);
                this.mySlowValidationTimedOut = false;
            }
            catch (TimeoutException e) {
                errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                boolean bl = this.mySlowValidationTimedOut = !forceSlow;
            }
            if (StringUtil.isEmpty((String)errorMessage) && !StringUtil.isEmpty((String)this.myForbiddenChildPath) && VfsUtilCore.isAncestor((File)(mountedFolder = new File(this.getMountedFolder())), (File)(path = new File(this.myForbiddenChildPath)), (boolean)false)) {
                errorMessage = WDBundle.message("path.is.under.mounted.folder", mountedFolder);
            }
            if (StringUtil.isEmpty((String)errorMessage)) {
                try {
                    errorMessage = WebServerConfigForm.getNonBlockingWarnings(currentState, forceSlow ? -1L : 200L);
                }
                catch (TimeoutException e) {
                    errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                    this.mySlowValidationTimedOut = !forceSlow;
                }
            }
        }
        String finalErrorMessage = errorMessage;
        Runnable updateRunnable = () -> {
            if (finalErrorMessage != null) {
                this.getMessageLabel().setText("<html>" + finalErrorMessage + "</html>");
                this.getMessageLabel().setVisible(true);
                this.getFixLink().setVisible(this.mySlowValidationTimedOut);
            } else {
                this.getMessageLabel().setText(null);
                this.getMessageLabel().setVisible(false);
                this.getFixLink().setVisible(false);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            updateRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.stateForComponent((Component)this.myContentPane));
        }
        return currentState;
    }

    private static String getNonBlockingWarnings(@NotNull SettingsDeployable currentState, long msTimeout) throws TimeoutException {
        String warning;
        if (currentState == null) {
            WebServerConfigForm.$$$reportNull$$$0(14);
        }
        if ((warning = currentState.getNonBlockingWarnings()) != null) {
            return warning;
        }
        if (currentState.getAccessType() == AccessType.SFTP && !StringUtil.isEmpty((String)currentState.getPrivateKeyFile())) {
            boolean needsKeyPassphrase;
            OneTimeString password;
            Credentials credentials = currentState.getCredentials();
            OneTimeString oneTimeString = password = credentials == null ? null : credentials.getPassword();
            if (StringUtil.isEmpty((CharSequence)password) && (needsKeyPassphrase = ((Boolean)Util.runWithTimeout(msTimeout, () -> {
                if (currentState == null) {
                    WebServerConfigForm.$$$reportNull$$$0(16);
                }
                return WebServerConfigForm.needsKeyPassphrase(currentState.getPrivateKeyFile());
            })).booleanValue())) {
                return "Provided private key requires a passphrase";
            }
        }
        return null;
    }

    @Nullable
    public String getCurrentWarning() {
        return this.getMessageLabel().getText();
    }

    public Icon getIcon(int flags) {
        Icon icon = this.getSelectedAccessType().getIcon();
        if (this.getCurrentWarning() != null) {
            icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
        }
        return icon;
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public SettingsDeployable getCurrentState() {
        SettingsDeployable currentState = this.myItem.clone();
        currentState.setAccessType(this.myItem.getAccessType());
        this.applyTo(currentState, false);
        SettingsDeployable settingsDeployable = currentState;
        if (settingsDeployable == null) {
            WebServerConfigForm.$$$reportNull$$$0(15);
        }
        return settingsDeployable;
    }

    private void createUIComponents() {
        this.myFixLink = new HoverHyperlinkLabel(WDBundle.message("revalidate", new Object[0]));
        this.myUrlField = new TextFieldWithBrowseButton.NoPathCompletion(){

            @NotNull
            protected Icon getDefaultIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    9.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            protected Icon getHoveredIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    9.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHoveredIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.myAccessTypeDescriptionLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
        this.myAdvancedOptionsForm = new AdvancedOptionsForm();
        this.myAdvancedSettingsPanel = new HideableTitledPanel("Advanced", false, this.myAdvancedOptionsForm.getContentPane(), false);
    }

    protected JLabel getMessageLabel() {
        return this.myMessageLabel;
    }

    protected HoverHyperlinkLabel getFixLink() {
        return this.myFixLink;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKeyFileField";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKeyPath";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBrowseListenerForPrivateKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAccessType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAuthType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateUi";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBrowseListenerForPrivateKey";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateAuth";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "needsKeyPassphrase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMemoryOnly";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultAdvancedSettings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNonBlockingWarnings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNonBlockingWarnings$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        MultiLineLabel multiLineLabel;
        JButton jButton;
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel;
        JButton jButton2;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JLabel jLabel3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPasswordField jPasswordField;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel5;
        JPasswordField jPasswordField2;
        JLabel jLabel6;
        JLabel jLabel7;
        JCheckBox jCheckBox3;
        JTextField jTextField3;
        JLabel jLabel8;
        JLabel jLabel9;
        JPanel jPanel2;
        JLabel jLabel10;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(7, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myProjectLevelCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Visible only for this project");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAccessTypeCombo = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 3, 8, 0, 2, 0, new Dimension(200, -1), null, null));
        this.myAccessTypeLabel = jLabel10 = new JLabel();
        jLabel10.setText("Type:");
        jLabel10.setDisplayedMnemonic('T');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = this.myAccessTypeDescriptionLabel;
        ((Component)jLabel11).setForeground(SystemColor.textInactiveText);
        jLabel11.setText("Description");
        jPanel3.add((Component)jLabel11, new GridConstraints(2, 1, 1, 3, 8, 0, 3, 3, null, null, null, 1));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Web server URL:");
        jLabel12.setDisplayedMnemonic('W');
        jLabel12.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel12, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myUrlField;
        textFieldWithBrowseButton3.setText("");
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 3, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myUploadPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        this.myHostLabel = jLabel9 = new JLabel();
        jLabel9.setText("Host:");
        jLabel9.setDisplayedMnemonic('O');
        jLabel9.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameLabel = jLabel8 = new JLabel();
        jLabel8.setText("User name:");
        jLabel8.setDisplayedMnemonic('U');
        jLabel8.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.myAnonymousCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Login as anonymous");
        jCheckBox3.setMnemonic('N');
        jCheckBox3.setDisplayedMnemonicIndex(10);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myAuthTypeLabel = jLabel7 = new JLabel();
        jLabel7.setText("Authentication:");
        jPanel2.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel6 = new JLabel();
        jLabel6.setText("Password:");
        jLabel6.setDisplayedMnemonic('S');
        jLabel6.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(4, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myPrivateKeyFileLabel = jLabel5 = new JLabel();
        jLabel5.setText("Private key path:");
        jLabel5.setDisplayedMnemonic('K');
        jLabel5.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel4 = new JLabel();
        jLabel4.setText("Passphrase:");
        jLabel4.setDisplayedMnemonic('S');
        jLabel4.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(6, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        JComboBox jComboBox2 = new JComboBox();
        this.myAuthTypeCombo = jComboBox2;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox2, new GridConstraints(3, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Save passphrase");
        jCheckBox2.setMnemonic('V');
        jCheckBox2.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(6, 2, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySavePasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save password");
        jCheckBox.setMnemonic('V');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myRootFolderLabel = jLabel3 = new JLabel();
        jLabel3.setText("Root path:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderLabel = jLabel2 = new JLabel();
        jLabel2.setText("Folder:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(9, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myRootFolderField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel4.add((Component)noPathCompletion, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAutodetectButton = jButton2 = new JButton();
        jButton2.setText("Autodetect");
        jButton2.setToolTipText("Configure root folder according to the user home folder on the server.");
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPortLabel = jLabel = new JLabel();
        jLabel.setText("Port:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel5.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 0, 2, 0, null, new Dimension(70, 22), null));
        this.myHostField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, new Dimension(100, -1), null, null));
        this.mySftpsSpacer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setText("Test Connection");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jButton, new GridConstraints(7, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(5, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        hoverHyperlinkLabel.setText("Refresh");
        hoverHyperlinkLabel.setToolTipText("Force server revalidation");
        jPanel6.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        this.myMessageLabel = multiLineLabel = new MultiLineLabel();
        multiLineLabel.setText("Label");
        jPanel6.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.myAdvancedSettingsPanel;
        jPanel3.add((Component)hideableTitledPanel, new GridConstraints(6, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        jLabel10.setLabelFor(jComboBox);
        jLabel12.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel9.setLabelFor(jTextField);
        jLabel8.setLabelFor(jTextField3);
        jLabel7.setLabelFor(jComboBox2);
        jLabel6.setLabelFor(jPasswordField2);
        jLabel5.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jPasswordField);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static class AccessTypeComboRenderer
    extends ListCellRendererWrapper<AccessType> {
        public void customize(JList list, AccessType accessType, int index, boolean selected, boolean hasFocus) {
            if (accessType != null) {
                this.setText(accessType.getTitle());
                this.setIcon(accessType.getIcon());
            }
        }
    }

    public static interface AccessTypeChangeListener
    extends EventListener {
        public void changed();
    }

    public static interface Listener
    extends EventListener {
        public void changed(SettingsDeployable var1);
    }
}

