/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentServersEditor;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupConfigurableForm
extends NamedConfigurable {
    private final SettingsGroupedDeployable myGroupedDeployable;
    private final UserDataHolder myDataHolder;
    private JPanel myMainPanel;
    private JBTextField myNameTextField;
    private JBCheckBox myVisibilityCheckBox;
    private JLabel myContextHelpLabel;
    private LinkLabel<Object> myAddServerLabel;

    GroupConfigurableForm(SettingsGroupedDeployable groupedDeployable, final DeploymentServersEditor editor, final @NotNull Runnable updater, UserDataHolder dataHolder, @Nullable Project project) {
        if (updater == null) {
            GroupConfigurableForm.$$$reportNull$$$0(0);
        }
        super(false, null);
        this.myGroupedDeployable = groupedDeployable;
        this.myDataHolder = dataHolder;
        this.$$$setupUI$$$();
        this.myMainPanel.setBorder(DeploymentConfigurableForm.createConfigurableBorder());
        this.myAddServerLabel.setIcon(AllIcons.General.LinkDropTriangle);
        this.myAddServerLabel.setHorizontalTextPosition(2);
        this.myAddServerLabel.setListener((LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(editor.createAddServerAction(AccessType.FTP, GroupConfigurableForm.this.myGroupedDeployable));
                group.add(editor.createAddServerAction(AccessType.FTPS, GroupConfigurableForm.this.myGroupedDeployable));
                group.add(editor.createAddServerAction(AccessType.SFTP, GroupConfigurableForm.this.myGroupedDeployable));
                group.add(editor.createAddServerAction(AccessType.MOUNT, GroupConfigurableForm.this.myGroupedDeployable));
                group.add(editor.createAddServerAction(AccessType.LOCAL, GroupConfigurableForm.this.myGroupedDeployable));
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("DeploymentSettings.Group.AddLink", (ActionGroup)group);
                popupMenu.getComponent().show((Component)GroupConfigurableForm.this.myAddServerLabel, 0, GroupConfigurableForm.this.myAddServerLabel.getHeight());
            }
        }, null);
        this.myNameTextField.setText(groupedDeployable.getName());
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                updater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/config/GroupConfigurableForm$2", "textChanged"));
            }
        });
        this.myVisibilityCheckBox.setVisible(project != null && !project.isDefault());
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (!StringUtil.equals((CharSequence)this.myNameTextField.getText(), (CharSequence)this.myGroupedDeployable.getName())) {
            return true;
        }
        return this.myVisibilityCheckBox.isSelected() != this.myGroupedDeployable.isProjectLevel();
    }

    public void apply() throws ConfigurationException {
        String oldName = this.myGroupedDeployable.getName();
        String newName = this.myNameTextField.getText();
        if (oldName != null && oldName.equals(DeploymentServersEditor.getDefaultServerOrGroupName(this.myDataHolder))) {
            DeploymentServersEditor.setDefaultServerOrGroupName(this.myDataHolder, newName);
        }
        this.myGroupedDeployable.setName(newName);
        this.myGroupedDeployable.setIsProjectLevel(this.myVisibilityCheckBox.isSelected());
    }

    public void reset() {
        this.myNameTextField.setText(this.myGroupedDeployable.getName());
        this.myVisibilityCheckBox.setSelected(this.myGroupedDeployable.isProjectLevel());
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myContextHelpLabel = ComponentPanelBuilder.createCommentComponent((String)"A server group allows deploying an application to all servers at once, or to a single server from this group. Drag-n-drop a server to a group to add it.", (boolean)false);
    }

    public void reloadName() {
        this.myNameTextField.setText(this.myGroupedDeployable.getName());
    }

    public SettingsGroupedDeployable getEditableObject() {
        return this.myGroupedDeployable;
    }

    public String getBannerSlogan() {
        return this.myNameTextField.getText();
    }

    public String getDisplayName() {
        return this.myNameTextField.getText();
    }

    public Icon getIcon(boolean expanded) {
        return AllIcons.Webreferences.Server;
    }

    public String getHelpTopic() {
        return null;
    }

    public void setDisplayName(String name) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/jetbrains/plugins/webDeployment/ui/config/GroupConfigurableForm", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LinkLabel linkLabel;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = this.myContextHelpLabel;
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 4, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, new Dimension(200, -1), null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myVisibilityCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("For current project");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddServerLabel = linkLabel = new LinkLabel();
        linkLabel.setText("Add new server");
        jPanel.add((Component)linkLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

