/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleRequestBroker
implements DataBus.Producing,
DataBus.Consuming {
    private final MessageBus myMessageBus;
    private final DataRequest.Owner myOwner;
    private final List<DataProducer> myProducers;

    public static SimpleRequestBroker newInstance(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            SimpleRequestBroker.$$$reportNull$$$0(0);
        }
        if (title == null) {
            SimpleRequestBroker.$$$reportNull$$$0(1);
        }
        final Disposable disposable = Disposer.newDisposable((String)title);
        MessageBus messageBus = DataBus.newDataBusChild(project, title, disposable);
        return new SimpleRequestBroker(null, messageBus){

            @Override
            public void afterProducerRemove(@NotNull DataProducer dataProducer) {
                if (dataProducer == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.hasNoProducers()) {
                    return;
                }
                DbUIUtil.invokeLater(() -> Disposer.dispose((Disposable)disposable));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProducer", "com/intellij/database/SimpleRequestBroker$1", "afterProducerRemove"));
            }
        };
    }

    SimpleRequestBroker(@Nullable DataRequest.Owner owner, @NotNull MessageBus messageBus) {
        if (messageBus == null) {
            SimpleRequestBroker.$$$reportNull$$$0(2);
        }
        this.myProducers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOwner = owner;
        this.myMessageBus = messageBus;
        this.subscribe(DatabaseTopics.REQUEST_TOPIC, new DataProducer(){

            @Override
            public void processRequest(@NotNull DataRequest request) {
                if (request == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (DataProducer producer : SimpleRequestBroker.this.myProducers) {
                    producer.processRequest(request);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/SimpleRequestBroker$2", "processRequest"));
            }
        });
    }

    boolean hasNoProducers() {
        return this.myProducers.isEmpty();
    }

    @Override
    public DataBus.Consuming filterFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            SimpleRequestBroker.$$$reportNull$$$0(3);
        }
        return new SimpleRequestBroker(owner, this.myMessageBus);
    }

    @Override
    public DataProducer getDataProducer() {
        return (DataProducer)this.myMessageBus.syncPublisher(DatabaseTopics.REQUEST_TOPIC);
    }

    @Override
    public DataAuditor getDataAuditor() {
        return (DataAuditor)this.myMessageBus.syncPublisher(DatabaseTopics.AUDIT_TOPIC);
    }

    @Override
    public DataConsumer getDataConsumer() {
        return (DataConsumer)this.myMessageBus.syncPublisher(DatabaseTopics.RESPONSE_TOPIC);
    }

    @Override
    public void addProducer(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            SimpleRequestBroker.$$$reportNull$$$0(4);
        }
        this.myProducers.add(dataProducer);
    }

    @Override
    public void beforeProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            SimpleRequestBroker.$$$reportNull$$$0(5);
        }
        this.myProducers.remove(dataProducer);
    }

    @Override
    public void afterProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            SimpleRequestBroker.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void addConsumer(@NotNull DataConsumer dataConsumer) {
        if (dataConsumer == null) {
            SimpleRequestBroker.$$$reportNull$$$0(7);
        }
        this.subscribe(DatabaseTopics.RESPONSE_TOPIC, this.myOwner == null ? dataConsumer : new DataConsumer.Wrapper(dataConsumer){

            @Override
            public boolean accepts(@NotNull DataRequest.Owner owner) {
                if (owner == null) {
                    3.$$$reportNull$$$0(0);
                }
                return SimpleRequestBroker.acceptsOwner(SimpleRequestBroker.this.myOwner, owner);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/SimpleRequestBroker$3", "accepts"));
            }
        });
    }

    protected static boolean acceptsOwner(@NotNull DataRequest.Owner currentOwner, @NotNull DataRequest.Owner requestOwner) {
        if (currentOwner == null) {
            SimpleRequestBroker.$$$reportNull$$$0(8);
        }
        if (requestOwner == null) {
            SimpleRequestBroker.$$$reportNull$$$0(9);
        }
        return currentOwner == requestOwner || requestOwner instanceof DataRequest.OwnerEx && ((DataRequest.OwnerEx)requestOwner).isChildOf(currentOwner);
    }

    @Override
    public void addAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            SimpleRequestBroker.$$$reportNull$$$0(10);
        }
        this.subscribe(DatabaseTopics.AUDIT_TOPIC, this.myOwner == null ? dataAuditor : new DataAuditor.Wrapper(dataAuditor){

            @Override
            public boolean accepts(DataRequest.Owner owner) {
                return SimpleRequestBroker.acceptsOwner(SimpleRequestBroker.this.myOwner, owner);
            }
        });
    }

    private <L> void subscribe(Topic<L> topic, L listener) {
        DataAuditor target;
        MessageBusConnection busConnection = this.myOwner == null ? this.myMessageBus.connect() : this.myMessageBus.connect((Disposable)this.myOwner);
        busConnection.subscribe(topic, listener);
        DataAuditor dataAuditor = listener instanceof DataAuditor.Wrapper ? ((DataAuditor.Wrapper)listener).delegate : (target = listener instanceof DataConsumer.Wrapper ? ((DataConsumer.Wrapper)listener).delegate : listener);
        if (target instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)target), (Disposable)busConnection);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProducer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestOwner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/SimpleRequestBroker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filterFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addProducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeProducerRemove";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "afterProducerRemove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addConsumer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsOwner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addAuditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

