/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FractionDomain
extends Domain {
    private final Cardinality.FractionCardinality myCardinality;
    private final int myDefaultValue;
    private final boolean myNarrowable;
    private final int myMax;

    public FractionDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, int max) {
        if (name == null) {
            FractionDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            FractionDomain.$$$reportNull$$$0(1);
        }
        if (type == null) {
            FractionDomain.$$$reportNull$$$0(2);
        }
        this(name, descriptor, type, max, -1, false);
    }

    public FractionDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, int myMax, int defaultValue, boolean narrowable) {
        if (name == null) {
            FractionDomain.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            FractionDomain.$$$reportNull$$$0(4);
        }
        if (type == null) {
            FractionDomain.$$$reportNull$$$0(5);
        }
        super(descriptor, type, name);
        this.myMax = myMax;
        this.myCardinality = new Cardinality.FractionCardinality(myMax);
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(6);
        }
        int suitability = this.getLogicType().getSuitability(domain.getLogicType());
        Compatibility compatibility = domain instanceof SimpleDomain && suitability >= 100 ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof SimpleDomain && suitability > 1 ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof FractionDomain && suitability > 0 ? this.compareWithFraction((FractionDomain)domain) : Compatibility.uncompatible()));
        if (compatibility == null) {
            FractionDomain.$$$reportNull$$$0(7);
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            FractionDomain.$$$reportNull$$$0(8);
        }
        return o;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.FractionCardinality fractionCardinality = this.myCardinality;
        if (fractionCardinality == null) {
            FractionDomain.$$$reportNull$$$0(9);
        }
        return fractionCardinality;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(10);
        }
        FractionDomain fractionDomain = this.myNarrowable && domain instanceof FractionDomain ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), Math.min(((FractionDomain)domain).getMax(), this.getMax()), this.myDefaultValue, true) : (this.myNarrowable && domain instanceof SimpleDomain && domain.getDomainType() == this.getDomainType() ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), this.myDefaultValue, this.myDefaultValue, true) : this);
        if (fractionDomain == null) {
            FractionDomain.$$$reportNull$$$0(11);
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            FractionDomain.$$$reportNull$$$0(12);
        }
        FractionDomain fractionDomain = this.myNarrowable ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), Math.min(provider.getScale(), this.getMax()), this.myDefaultValue, true) : this;
        if (fractionDomain == null) {
            FractionDomain.$$$reportNull$$$0(13);
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.shouldParametrize() ? this.simpleName() + "(" + this.getMax() + ")" : super.name();
        if (string == null) {
            FractionDomain.$$$reportNull$$$0(14);
        }
        return string;
    }

    public int getMax() {
        return this.myMax;
    }

    public int getDefaultValue() {
        return this.myDefaultValue;
    }

    public boolean isNarrowable() {
        return this.myNarrowable;
    }

    protected boolean shouldParametrize() {
        return this.getMax() != this.myDefaultValue && this.myNarrowable && this.getMax() > 0;
    }

    @NotNull
    private Compatibility compareWithFraction(@NotNull FractionDomain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(15);
        }
        Compatibility compatibility = this.getLogicType().getSuitability(domain.getLogicType()) >= 100 && this.getMax() >= domain.getMax() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            FractionDomain.$$$reportNull$$$0(16);
        }
        return compatibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/FractionDomain";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/FractionDomain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithFraction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compareWithFraction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

