/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDomain
extends Domain {
    private final Cardinality.TextCardinality myCardinality;
    private final Length myLengthCaps;
    private final long myLength;

    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength) {
        if (name == null) {
            TextDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            TextDomain.$$$reportNull$$$0(1);
        }
        this(name, descriptor, maxLength, Length.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            TextDomain.$$$reportNull$$$0(3);
        }
        this(name, descriptor, maxLength, narrowable != false ? Length.optional(defaultValue == -1L ? maxLength : defaultValue) : Length.fixed(defaultValue));
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength, Length length) {
        void lengthCaps;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            TextDomain.$$$reportNull$$$0(5);
        }
        super(descriptor, PhysicalDomainType.TEXT, name);
        this.myLength = maxLength;
        this.myCardinality = new Cardinality.TextCardinality(maxLength);
        this.myLengthCaps = lengthCaps;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(6);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? this.compareWithLength((BinaryDomain)domain) : (domain instanceof TextDomain ? (((TextDomain)domain).getEffectiveLength() <= this.getEffectiveLength() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.uncompatibleLossless(this.cardinality(), TextDomain.getLogicalType(domain), this.getLogicType()));
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(7);
        }
        return compatibility;
    }

    @NotNull
    private static LogicalType getLogicalType(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(8);
        }
        LogicalType logicalType = domain instanceof TextPreferable ? ((TextPreferable)((Object)domain)).getFakeType() : domain.getLogicType();
        if (logicalType == null) {
            TextDomain.$$$reportNull$$$0(9);
        }
        return logicalType;
    }

    @NotNull
    private Compatibility compareWithLength(@NotNull BinaryDomain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(10);
        }
        Compatibility compatibility = domain.getEffectiveUpperBound() <= this.getEffectiveLength() ? Compatibility.uncompatibleLossless(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(11);
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.TextCardinality textCardinality = this.myCardinality;
        if (textCardinality == null) {
            TextDomain.$$$reportNull$$$0(12);
        }
        return textCardinality;
    }

    public long getLength() {
        return this.myLength;
    }

    public long getEffectiveLength() {
        return this.myLengthCaps.getEffectiveLength(this.myLength);
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            TextDomain.$$$reportNull$$$0(13);
        }
        return this.getLength() != 0L && o instanceof String ? ((String)o).substring(0, (int)Math.min(this.getLength(), (long)((String)o).length())) : o;
    }

    public long getDefaultValue() {
        return this.myLengthCaps.defaultLength;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(14);
        }
        Domain domain2 = this.myLengthCaps.isNarrowable() && domain instanceof TextDomain ? this.create(Math.min(((TextDomain)domain).getEffectiveLength(), this.getEffectiveLength())) : this;
        if (domain2 == null) {
            TextDomain.$$$reportNull$$$0(15);
        }
        return domain2;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            TextDomain.$$$reportNull$$$0(16);
        }
        if (!this.myLengthCaps.isNarrowable()) {
            TextDomain textDomain = this;
            if (textDomain == null) {
                TextDomain.$$$reportNull$$$0(17);
            }
            return textDomain;
        }
        int size = provider.getSize();
        Domain domain = this.create(size > 0 ? Math.min((long)size, this.getEffectiveLength()) : this.myLengthCaps.defaultLength);
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(18);
        }
        return domain;
    }

    protected Domain create(long length) {
        return new TextDomain(this.simpleName(), this.getPoint(), length, this.myLengthCaps);
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myLengthCaps.shouldAddLength(this.getLength()) ? this.simpleName() + "(" + this.getEffectiveLength() + ")" : super.name();
        if (string == null) {
            TextDomain.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithLength";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareWithLength";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Length {
        public final long defaultLength;
        public final Boolean hasCustomLength;
        public static final Length NONE = new Length(-1L, false);
        public static final Length MANDATORY = new Length(-1L, true);
        public static final Length UNKNOWN = new Length(-1L, null);

        public static Length fixed(long length) {
            return length == -1L ? NONE : new Length(length, false);
        }

        public static Length mandatory(long fallbackLength) {
            return fallbackLength == -1L ? MANDATORY : new Length(fallbackLength, true);
        }

        public static Length optional(long length) {
            return length == -1L ? MANDATORY : new Length(length, null);
        }

        private Length(long defaultLength, Boolean hasCustomLength) {
            this.defaultLength = defaultLength;
            this.hasCustomLength = hasCustomLength;
        }

        public boolean isNarrowable() {
            return !this.isFixed();
        }

        public boolean isOptional() {
            return this.hasCustomLength == null;
        }

        public boolean isFixed() {
            return Boolean.FALSE.equals(this.hasCustomLength);
        }

        public boolean shouldAddLength(long length) {
            if (this.isFixed()) {
                return false;
            }
            if (this.isOptional()) {
                return length != this.defaultLength && length > 0L;
            }
            return true;
        }

        public long getEffectiveLength(long length) {
            return length > 0L ? length : this.defaultLength;
        }
    }

    public static interface TextPreferable {
        @NotNull
        public LogicalType getFakeType();
    }
}

