/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcValidator {
    private static final Logger LOG = Logger.getInstance(DbSrcValidator.class);

    public static boolean isEnabled() {
        return ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    public Couple<List<LocalDataSource>> collect(@NotNull Project project, @NotNull Iterable<LocalDataSource> dataSources2) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(1);
        }
        Couple res2 = Couple.of((Object)ContainerUtil.newArrayList(), (Object)ContainerUtil.newArrayList());
        for (LocalDataSource source : dataSources2) {
            Result result2;
            if (project.isDisposed()) break;
            DbSrcStorage storage = DbSrcStorageManager.getInstance(source.isGlobal() ? null : project).getStorage(source.getUniqueId(), true);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getModel(), BasicModel.class);
            if (model == null || (result2 = this.isValid(storage, model)) == Result.VALID) continue;
            if (result2 == Result.GENERATE || result2 == Result.GENERATE_AND_INTROSPECT) {
                ((List)res2.first).add(source);
            }
            if (result2 != Result.INTROSPECT && result2 != Result.GENERATE_AND_INTROSPECT) continue;
            ((List)res2.second).add(source);
        }
        Couple couple = res2;
        if (couple == null) {
            DbSrcValidator.$$$reportNull$$$0(2);
        }
        return couple;
    }

    @NotNull
    public Result isValid(@NotNull DbSrcStorage storage, @NotNull BasicModel model) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(3);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(4);
        }
        Result result2 = Result.VALID;
        for (BasicSchema schema : DbSrcValidator.getSchemas(model)) {
            Result cur = this.isValid(storage, model, schema);
            if (result2 == Result.GENERATE && cur == Result.INTROSPECT || result2 == Result.INTROSPECT && cur == Result.GENERATE) {
                Result result3 = Result.GENERATE_AND_INTROSPECT;
                if (result3 == null) {
                    DbSrcValidator.$$$reportNull$$$0(5);
                }
                return result3;
            }
            if (cur.ordinal() <= result2.ordinal()) continue;
            result2 = cur;
        }
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(6);
        }
        return result4;
    }

    @NotNull
    public Result isValid(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicSchema schema) {
        Result result2;
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(7);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(8);
        }
        if (schema == null) {
            DbSrcValidator.$$$reportNull$$$0(9);
        }
        if ((result2 = this.checkVersions(storage, model, schema)) != null) {
            Result result3 = result2;
            if (result3 == null) {
                DbSrcValidator.$$$reportNull$$$0(10);
            }
            return result3;
        }
        result2 = Result.VALID;
        for (BasicSourceAware object : DbSrcValidator.getSources(model, schema)) {
            Result cur = (Result)((Object)ObjectUtils.chooseNotNull((Object)((Object)this.checkVersions(storage, model, object)), (Object)((Object)Result.VALID)));
            if (cur.ordinal() > result2.ordinal()) {
                result2 = cur;
            }
            if (result2 != Result.INTROSPECT) continue;
            break;
        }
        DbSrcValidator.updateSchemaValidness(storage, model, schema, result2);
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(11);
        }
        return result4;
    }

    @NotNull
    private static JBIterable<BasicSchema> getSchemas(@NotNull BasicModel model) {
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().withRoots(model.getModelRoots())).expand(n -> n.getKind() != ObjectKind.SCHEMA)).filter(BasicSchema.class).filter(BasicMateNamespace::isVisible);
        if (jBIterable == null) {
            DbSrcValidator.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    private static JBIterable<BasicSourceAware> getSources(@NotNull BasicModel model, @Nullable BasicSchema schema) {
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(14);
        }
        JBTreeTraverser traverser2 = model.traverser();
        traverser2 = schema != null ? (JBTreeTraverser)((JBTreeTraverser)traverser2.withRoot((Object)schema)).expand(Conditions.alwaysTrue()) : (JBTreeTraverser)((JBTreeTraverser)traverser2.withRoot((Object)model.getRoot())).expand(o -> !(o instanceof DasNamespace) || ((DasNamespace)o).isVisible());
        return traverser2.filter(BasicSourceAware.class);
    }

    @Nullable
    private Result checkVersions(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicElement object) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(15);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(16);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(17);
        }
        ObjectPath path = ObjectPaths.of(object);
        Dbms dbms = model.getDbms();
        ScriptGenerator service = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms);
        DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(path);
        if (metaData == null) {
            return null;
        }
        ScriptingCapabilities caps = service.capabilities(object);
        if (object.getKind() == ObjectKind.SCHEMA) {
            if (metaData.introContentVersion < 0 && metaData.introContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion) {
                return Result.INTROSPECT;
            }
            if (metaData.genContentVersion < 0 && metaData.genContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion) {
                return Result.GENERATE;
            }
            int genVersion = caps.getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
            boolean match2 = introVersion == metaData.introContentVersion && genVersion == metaData.genContentVersion;
            return match2 ? Result.VALID : null;
        }
        int genVersion = caps.getCreateVersion();
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
        if (introVersion != metaData.introContentVersion) {
            return Result.INTROSPECT;
        }
        if (genVersion != metaData.genContentVersion) {
            return Result.GENERATE;
        }
        return Result.VALID;
    }

    private static void updateSchemaValidness(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicSchema object, @NotNull Result result2) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(18);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(19);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            DbSrcValidator.$$$reportNull$$$0(21);
        }
        ObjectPath path = ObjectPaths.of(object);
        Dbms dbms = model.getDbms();
        ScriptingCapabilities caps = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(object);
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
        int genVersion = caps.getCreateVersion();
        metaData = DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, result2 == Result.INTROSPECT ? -introVersion : introVersion, result2 != Result.VALID ? -genVersion : genVersion);
        try {
            storage.putMetaData(path, metaData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invalidate(@NotNull DbSrcStorage storage, @NotNull ObjectPath path) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(22);
        }
        if (path == null) {
            DbSrcValidator.$$$reportNull$$$0(23);
        }
        if ((metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY)) == null) {
            return;
        }
        try {
            storage.putMetaData(path, DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion, DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void suggestIntrospecting(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(24);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(25);
        }
        String names = StringUtil.join(dataSources2, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Invalid source code of database objects", names + " must be <a href=\"introspect\">synchronized</a>", NotificationType.WARNING, (notification, event) -> {
            if (dataSources2 == null) {
                DbSrcValidator.$$$reportNull$$$0(39);
            }
            if (project == null) {
                DbSrcValidator.$$$reportNull$$$0(40);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("introspect")) {
                return;
            }
            for (LocalDataSource dataSource : dataSources2) {
                DataSourceUiUtil.performManualSyncTask(LoaderContext.loadAll(project, dataSource));
            }
        }).notify(project);
    }

    public static void suggestRegenerating(final @NotNull Project project, final @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(26);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(27);
        }
        String names = StringUtil.join(dataSources2, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Invalid source code of database objects", names + " must be <a href=\"regenerate\">regenerated</a>", NotificationType.WARNING, (notification, event) -> {
            if (project == null) {
                DbSrcValidator.$$$reportNull$$$0(37);
            }
            if (dataSources2 == null) {
                DbSrcValidator.$$$reportNull$$$0(38);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("regenerate")) {
                return;
            }
            new Task.Backgroundable(project, "Regenerating DB Objects Source Code", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DbSrcValidator.regenerateSources(project, dataSources2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$1", "run"));
                }
            }.queue();
        }).notify(project);
    }

    public static void regenerateSources(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        ProgressIndicator indicator;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(28);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(29);
        }
        if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null) {
            indicator.setText("Regenerating DB objects source code");
        }
        for (LocalDataSource dataSource : dataSources2) {
            DbSrcValidator.regenerateSources(project, dataSource);
        }
    }

    public static void regenerateSources(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        BasicModModel model;
        DbSrcModelStorage modelStorage;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(30);
        }
        if (dataSource == null) {
            DbSrcValidator.$$$reportNull$$$0(31);
        }
        DbSrcModelStorage dbSrcModelStorage = modelStorage = (model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class)) == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (modelStorage == null) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2("Processing " + dataSource.getName());
        }
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
        DbSrcStorage storage = DbSrcStorageManager.getInstance(dataSource.isGlobal() ? null : project).getStorage(dataSource.getUniqueId(), true);
        DbImplUtil.performSrcOperation(model, TransactionGuard.getInstance().getContextTransaction(), true, () -> modelStorage.writeSession(() -> {
            for (BasicSourceAware aware : DbSrcValidator.getSources(model, null)) {
                CompositeText compositeText;
                int version = service.capabilities(aware).getCreateVersion();
                DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(ObjectPaths.of(aware));
                if (metaData == null || metaData.genContentVersion == version || (compositeText = modelStorage.load(aware)) == null) continue;
                modelStorage.save(aware, compositeText);
            }
        }));
    }

    public static void checkOutdatedFiles(@Nullable Project project) {
        Project anyProject;
        VirtualFile root2 = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
        if (root2 == null) {
            return;
        }
        Project project2 = anyProject = project == null ? DbSrcValidator.getAnyProject() : project;
        if (anyProject == null) {
            return;
        }
        ArrayList pruned = ContainerUtil.newArrayList();
        for (VirtualFile dsRoot : root2.getChildren()) {
            if (!DbSrcValidator.checkOutdatedFiles(anyProject, project == null, dsRoot)) continue;
            pruned.add(dsRoot.getName());
        }
        if (!pruned.isEmpty()) {
            DbSrcValidator.notifyPruned(anyProject, project == null, pruned);
        }
    }

    @Nullable
    private static Project getAnyProject() {
        Project project = ProjectUtil.guessCurrentProject(null);
        if (!project.isDefault()) {
            return project;
        }
        for (Project p2 : ProjectManager.getInstance().getOpenProjects()) {
            if (p2.isDefault()) continue;
            return p2;
        }
        return null;
    }

    private static void notifyPruned(final Project project, boolean global, List<String> pruned) {
        final List dataSources2 = JBIterable.from(pruned).filterMap(ds -> DbSrcUtils.findDataSource(global ? null : project, ds)).toList();
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Stale cached sources removed", "<a href=\"sync\">Re-sync</a> may be required for:\n" + StringUtil.join((Collection)dataSources2, DasDataSource::getName, (String)", "), NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (LocalDataSource dataSource : dataSources2) {
                    DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(project, dataSource));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static boolean checkOutdatedFiles(@NotNull Project project, boolean global, @NotNull VirtualFile root2) {
        LocalDataSource localDs;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(32);
        }
        if (root2 == null) {
            DbSrcValidator.$$$reportNull$$$0(33);
        }
        if ((localDs = DbSrcUtils.findDataSource(global ? null : project, root2.getName())) == null) {
            return false;
        }
        final DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(localDs.getUniqueId());
        if (dataSource == null) {
            return false;
        }
        final LinkedHashSet leftOvers = ContainerUtil.newLinkedHashSet();
        final ArrayList leftOverFiles = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile file) {
                ObjectPath path;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((path = DbSrcUtils.getFullPath(file.getPath())) == null) {
                    return true;
                }
                if (!leftOvers.contains(path)) {
                    DbElement element2 = DbSqlUtil.findElement(dataSource, path);
                    if (element2 != null) {
                        return true;
                    }
                    if (DbSrcFileSystem.getInstance().isOrphaned(file)) {
                        return false;
                    }
                    leftOvers.add(path);
                }
                leftOverFiles.add(file);
                VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$3", "visitFile"));
            }
        });
        if (leftOvers.isEmpty()) {
            return false;
        }
        DbSrcStorage storage = DbSrcStorageManager.getInstance(global ? null : project).getStorage((String)ObjectUtils.notNull((Object)dataSource.getUniqueId()), true);
        LOG.warn("Found " + leftOvers.size() + " left over files in storage of " + dataSource.getName() + ":\n" + StringUtil.join((Iterable)JBIterable.from((Iterable)leftOvers).take(5), ObjectPath::getDisplayName, (String)"\n") + (leftOvers.size() > 5 ? "\n..." : "") + "\nPruning.");
        try {
            for (ObjectPath path : leftOvers) {
                storage.dropObject(path, true);
                DbSrcValidator.cleanupDatabaseAndSchemaStamps(storage, path);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        RefreshQueue.getInstance().refresh(true, true, null, (Collection)leftOverFiles);
        return true;
    }

    private static void cleanupDatabaseAndSchemaStamps(@NotNull DbSrcStorage storage, @NotNull ObjectPath obj) throws IOException {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(34);
        }
        if (obj == null) {
            DbSrcValidator.$$$reportNull$$$0(35);
        }
        DbSrcValidator.cleanupStamps(storage, obj.findParent(ObjectKind.SCHEMA, true));
        DbSrcValidator.cleanupStamps(storage, obj.findParent(ObjectKind.DATABASE, true));
    }

    private static void cleanupStamps(@NotNull DbSrcStorage storage, @Nullable ObjectPath obj) throws IOException {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(36);
        }
        if (obj == null) {
            return;
        }
        DbSrcStorageDsMetadata.MetaData md = storage.getMetaData(obj);
        if (md == null || md.srcVersion == null) {
            return;
        }
        storage.putMetaData(obj, DbSrcStorageDsMetadata.MetaData.modSrcVersion(md, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 18: 
            case 22: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isValid";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkVersions";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateSchemaValidness";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "suggestIntrospecting";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "suggestRegenerating";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "regenerateSources";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkOutdatedFiles";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "cleanupDatabaseAndSchemaStamps";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "cleanupStamps";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestRegenerating$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestIntrospecting$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Result {
        VALID,
        GENERATE,
        INTROSPECT,
        GENERATE_AND_INTROSPECT;

    }
}

