/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.database.dataSource.url.template.TextDecompositionUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDecomposition {
    private Boolean myMatched;
    private String myTextCache;
    private final Map<String, TextDecompositionNodes.Parameter> myParameters;
    private final StatelessTextDecomposition myStateless;
    private final TextDecompositionNodes.ListChoiceSNode myRoot;
    private List<TextRange> myInvalidRanges;
    private boolean myErroneous;

    @Nullable
    public TextRange getParameterRange(@NotNull String name) {
        if (name == null) {
            TextDecomposition.$$$reportNull$$$0(0);
        }
        this.validateText();
        TextDecompositionNodes.Matchable matchable = (TextDecompositionNodes.Matchable)ObjectUtils.tryCast((Object)this.myParameters.get(name), TextDecompositionNodes.Matchable.class);
        return matchable != null && matchable.getFrom() != -1 ? TextRange.create((int)matchable.getFrom(), (int)matchable.getTo()) : null;
    }

    public void validateParameters() {
        this.validateText();
    }

    private static void collectParameters(@NotNull TextDecompositionNodes.SNode root2, final @NotNull Map<String, TextDecompositionNodes.Parameter> res2) {
        if (root2 == null) {
            TextDecomposition.$$$reportNull$$$0(1);
        }
        if (res2 == null) {
            TextDecomposition.$$$reportNull$$$0(2);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                TextDecompositionNodes.Parameter param;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof TextDecompositionNodes.Parameter && (param = (TextDecompositionNodes.Parameter)((Object)node)).getName() != null) {
                    res2.put(param.getName(), param);
                }
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$1", "visit"));
            }
        }.visit(root2);
    }

    public TextDecomposition(@NotNull StatelessTextDecomposition decomposition) {
        if (decomposition == null) {
            TextDecomposition.$$$reportNull$$$0(3);
        }
        this.myStateless = decomposition;
        this.myRoot = TextDecompositionNodes.create(decomposition.getNode());
        this.myParameters = new HashMap<String, TextDecompositionNodes.Parameter>(1);
        TextDecomposition.collectParameters(this.myRoot, this.myParameters);
    }

    @NotNull
    public StatelessTextDecomposition getStateless() {
        StatelessTextDecomposition statelessTextDecomposition = this.myStateless;
        if (statelessTextDecomposition == null) {
            TextDecomposition.$$$reportNull$$$0(4);
        }
        return statelessTextDecomposition;
    }

    public String getPattern() {
        return this.myRoot.getStateless().getPattern();
    }

    public boolean isValid() {
        if (this.myMatched == null) {
            this.myMatched = this.myRoot.getStateless().compilePattern().matcher(this.getText()).matches();
        }
        return this.myMatched;
    }

    public void setTextTolerantly(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(5);
        }
        this.validateText();
        if (text2.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text2)) {
            this.matchIncrementally(text2);
        }
    }

    public void setText(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(6);
        }
        if (text2.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text2)) {
            this.matchFailed(text2);
        }
    }

    @NotNull
    public List<TextRange> getInvalidRanges() {
        this.validateText();
        List<TextRange> list = this.myInvalidRanges;
        if (list == null) {
            TextDecomposition.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public String getText() {
        this.validateText();
        String string = this.myTextCache;
        if (string == null) {
            TextDecomposition.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String findProperty(@NotNull String name) {
        if (name == null) {
            TextDecomposition.$$$reportNull$$$0(9);
        }
        block0: for (TextDecompositionNodes.ListChoiceSNode node : ((JBTreeTraverser)TextDecompositionUtil.traverse(this.myRoot).expand(Conditions.alwaysTrue())).filter(TextDecompositionNodes.ListChoiceSNode.class)) {
            JBIterable leaves;
            if (node == this.myRoot || !(leaves = ((JBTreeTraverser)TextDecompositionUtil.traverse(node).expand(Conditions.alwaysTrue())).filter(TextDecompositionNodes.LeafSNode.class)).skip(3).isEmpty()) continue;
            int cnt = 0;
            for (TextDecompositionNodes.LeafSNode leaf : leaves) {
                if (++cnt == 1 && !StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)leaf.getText()) || cnt == 2 && !"=".equals(leaf.getText())) continue block0;
                if (cnt != 3) continue;
                return leaf.getText();
            }
        }
        return null;
    }

    public void setParameter(@NotNull String name, @NotNull String value) {
        TextDecompositionNodes.Parameter param;
        if (name == null) {
            TextDecomposition.$$$reportNull$$$0(10);
        }
        if (value == null) {
            TextDecomposition.$$$reportNull$$$0(11);
        }
        if ((param = this.myParameters.get(name)) == null || value.equals(param.getText())) {
            return;
        }
        param.setText(value);
        this.myErroneous = false;
        TextDecompositionUtil.purgeBadGroups(this.myRoot);
        this.myMatched = value.isEmpty() || param.getPattern().matcher(value).matches() ? null : Boolean.FALSE;
        this.myTextCache = null;
    }

    @Nullable
    public String getParameter(@NotNull String name) {
        TextDecompositionNodes.Parameter node;
        if (name == null) {
            TextDecomposition.$$$reportNull$$$0(12);
        }
        if ((node = this.myParameters.get(name)) == null) {
            return null;
        }
        return node.getText();
    }

    private void validateText() {
        if (this.myTextCache == null) {
            this.checkOptionals();
            TextDecompositionUtil.resetDisabledMatchables(this.myRoot);
            StringBuilder builder = new StringBuilder();
            TextDecompositionUtil.buildText(builder, this.myRoot);
            this.myInvalidRanges = TextDecompositionUtil.extractBadRanges(this.myRoot);
            this.myTextCache = builder.toString();
        }
    }

    private void checkOptionals() {
        new TextDecompositionUtil.SimpleNodeVisitor<ThreeState>(){

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ThreeState.fromBoolean((!node.getText().isEmpty() || node.getBadGroup() != null ? 1 : 0) != 0);
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                return node.getBadGroup() != null ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
                ThreeState res2 = ThreeState.UNSURE;
                for (TextDecompositionNodes.SNode c2 : node.getChildren()) {
                    ThreeState tmp = (ThreeState)this.visit(c2);
                    if (tmp == ThreeState.YES && res2 != ThreeState.NO) {
                        res2 = ThreeState.YES;
                        continue;
                    }
                    if (tmp != ThreeState.NO) continue;
                    res2 = ThreeState.NO;
                }
                return res2;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                ThreeState res2;
                if (node == null) {
                    2.$$$reportNull$$$0(3);
                }
                ThreeState threeState = res2 = node.getBadGroup() != null ? ThreeState.YES : (ThreeState)this.visit(node.getNode());
                if (res2 != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res2.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return node.isEnabled() ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(4);
                }
                return ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(5);
                }
                ThreeState res2 = ThreeState.NO;
                for (TextDecompositionNodes.ListChoiceSNode c2 : node.getMatches()) {
                    ThreeState tmp = this.visit(c2);
                    if (tmp != ThreeState.YES) continue;
                    res2 = ThreeState.YES;
                }
                return res2;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                ThreeState res2;
                if (node == null) {
                    2.$$$reportNull$$$0(6);
                }
                if ((res2 = (ThreeState)this.visit(node.getRoot())) != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res2.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return ThreeState.fromBoolean((boolean)node.isEnabled());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
            }
        }.visit(this.myRoot);
        this.myRoot.setEnabled(true);
    }

    private boolean matchCompletely(@NotNull String text2) {
        Matcher matcher;
        boolean res2;
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(13);
        }
        if (res2 = (matcher = this.myRoot.getStateless().compilePattern().matcher(text2)).matches()) {
            this.myRoot.setMatch(text2);
        }
        this.myErroneous = !res2;
        this.myMatched = res2;
        return res2;
    }

    private void matchIncrementally(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(14);
        }
        this.myRoot.matchIncrementally(text2, null);
    }

    private void matchFailed(final @NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(15);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private final TextDecompositionNodes.BadGroup myBadGroup;
            {
                this.myBadGroup = new TextDecompositionNodes.BadGroup(text2);
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (node instanceof TextDecompositionNodes.LeafSNode) {
                    ((TextDecompositionNodes.LeafSNode)node).setBadGroup(this.myBadGroup);
                }
                if (node instanceof TextDecompositionNodes.OptionalSNode) {
                    ((TextDecompositionNodes.OptionalSNode)node).setEnabled(false);
                    return null;
                }
                if (node instanceof TextDecompositionNodes.ListChoiceSNode && node != TextDecomposition.this.myRoot) {
                    ((TextDecompositionNodes.ListChoiceSNode)node).setEnabled(false);
                    return null;
                }
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$3", "visit"));
            }
        }.visit(this.myRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decomposition";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecomposition";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecomposition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateless";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTextTolerantly";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchCompletely";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchIncrementally";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matchFailed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PatternFactory {
        @Nullable
        public Pattern getPattern(@NotNull String var1, @Nullable String var2, @Nullable String var3);
    }
}

