/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.datagrid.SqlDocumentDataHookUp;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataHookUpManager
extends SessionClientHolder<DataGridSessionClient, Parameters> {
    private final Project myProject;
    private final Map<VirtualFile, HookUpReference> myVirtualFileBasedHookUps;
    private final Set<HookUpReference> myHookUps;
    private final Object myLock;

    public GridDataHookUpManager(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(0);
        }
        super(DataGridSessionClient.class);
        this.myProject = project;
        this.myVirtualFileBasedHookUps = ContainerUtil.newHashMap();
        this.myHookUps = ContainerUtil.newHashSet();
        this.myLock = new Object();
    }

    public static GridDataHookUpManager getInstance(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(1);
        }
        return (GridDataHookUpManager)ServiceManager.getService((Project)project, GridDataHookUpManager.class);
    }

    @NotNull
    public DataGridSessionClient getHookUp(@NotNull VirtualFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(3);
        }
        DataGridSessionClient dataGridSessionClient = this.getOrCreateHookUp(file, this.generator((tableFile, session2) -> {
            Parameters parameters = new Parameters(this.myProject, (VisibleDatabaseSession)session2, (VirtualFile)tableFile);
            return (DataGridSessionClient)this.createClient(parameters);
        }, (dataSource, title) -> DatabaseSessionManager.getSession(this.myProject, dataSource, title)), parent2);
        if (dataGridSessionClient == null) {
            GridDataHookUpManager.$$$reportNull$$$0(4);
        }
        return dataGridSessionClient;
    }

    @NotNull
    public DatabaseTableGridDataHookUp getOrCreateLightweight(@NotNull VirtualFile file, @NotNull Disposable parent2, @NotNull DatabaseDepartment department) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(5);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(6);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(7);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.getOrCreateHookUp(file, this.generator((tableFile, session2) -> {
            if (department == null) {
                GridDataHookUpManager.$$$reportNull$$$0(63);
            }
            DatabaseTableGridDataHookUp hookUp = new DatabaseTableGridDataHookUp(this.myProject, (DatabaseSession)session2, (VirtualFile)tableFile, department);
            Disposer.register((Disposable)hookUp, (Disposable)session2);
            return hookUp;
        }, (dataSource, title) -> DatabaseSessionManager.getSilentSession(this.myProject, dataSource)), parent2, false);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(8);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull CsvTableDataFragmentFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(9);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(10);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, file1.getFormat(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent2);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(11);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public SqlDocumentDataHookUp getHookUp(@NotNull SqlTableDataFragmentFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(12);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(13);
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new SqlDocumentDataHookUp(this.myProject, file1.getDialect(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent2);
        if (sqlDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(14);
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull CsvFormat format, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(15);
        }
        if (format == null) {
            GridDataHookUpManager.$$$reportNull$$$0(16);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(17);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> {
            if (format == null) {
                GridDataHookUpManager.$$$reportNull$$$0(62);
            }
            return new CsvDocumentDataHookUp(this.myProject, format, GridDataHookUpManager.getDocument(file1), null);
        }, parent2);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(18);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createDatabaseHookUp(@NotNull Disposable parent2, @NotNull DatabaseSession session2, @NotNull JdbcConsole.SearchPathSender sender, @NotNull DatabaseDepartment department) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(19);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(20);
        }
        if (sender == null) {
            GridDataHookUpManager.$$$reportNull$$$0(21);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(22);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ConsoleGridDataHookUp(this.myProject, session2, department, sender), parent2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(23);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull LocalDataSource dataSource, @NotNull Disposable parent2, @NotNull String query, @NotNull DatabaseDepartment department) {
        if (dataSource == null) {
            GridDataHookUpManager.$$$reportNull$$$0(24);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(25);
        }
        if (query == null) {
            GridDataHookUpManager.$$$reportNull$$$0(26);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(27);
        }
        DatabaseSession session2 = DatabaseSessionManager.getSilentSession(this.myProject, dataSource);
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ReadOnlyDatabaseGridDataHookUp(this.myProject, session2, query, department), parent2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(28);
        }
        return databaseGridDataHookUp;
    }

    public JpaGridDataHookUp createJpaHookUp(@NotNull Session session2, @NotNull Disposable parent2) {
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(29);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(30);
        }
        return this.registerHookUp(new JpaGridDataHookUp(this.myProject, session2), parent2);
    }

    @NotNull
    public DatabaseGridDataHookUp createMockHookUp(final @NotNull DbDataSource dataSource, @NotNull DatabaseSession session2, @NotNull JdbcConsole.SearchPathSender sender, @NotNull DatabaseDepartment department) {
        if (dataSource == null) {
            GridDataHookUpManager.$$$reportNull$$$0(31);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(32);
        }
        if (sender == null) {
            GridDataHookUpManager.$$$reportNull$$$0(33);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(34);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ConsoleGridDataHookUp(this.myProject, session2, department, sender){

            @Override
            @NotNull
            public DbDataSource getDataSource() {
                DbDataSource dbDataSource = dataSource;
                if (dbDataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbDataSource;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager$1", "getDataSource"));
            }
        }, session2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(35);
        }
        return databaseGridDataHookUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> acquire(@NotNull HookUpHandle handle, @NotNull Disposable parent2) {
        if (handle == null) {
            GridDataHookUpManager.$$$reportNull$$$0(36);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(37);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (handle.myRef == null || handle.myRef.myReferenceCount <= 0) {
                return null;
            }
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(handle.myRef));
            return handle.myRef.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HookUpHandle getHandle(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(38);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        HookUpReference res2 = null;
        for (HookUpReference ref : this.myHookUps) {
            if (ref.myHookUp != hookUp) continue;
            res2 = ref;
            break;
        }
        HookUpHandle hookUpHandle = new HookUpHandle(res2);
        // MONITOREXIT : object
        if (hookUpHandle != null) return hookUpHandle;
        GridDataHookUpManager.$$$reportNull$$$0(39);
        return hookUpHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected List<DataGridSessionClient> getActiveClients(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(40);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        List<DataGridSessionClient> list = this.myVirtualFileBasedHookUps.values().stream().filter(h -> ((HookUpReference)h).myHookUp instanceof DataGridSessionClient).filter(h -> ((HookUpReference)h).myReferenceCount > 0).map(h -> (DataGridSessionClient)((HookUpReference)h).myHookUp).collect(Collectors.toList());
        // MONITOREXIT : object
        if (list != null) return list;
        GridDataHookUpManager.$$$reportNull$$$0(41);
        return list;
    }

    @Override
    protected void register(@NotNull Project project, @NotNull DataGridSessionClient session2) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(42);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(43);
        }
    }

    @Override
    @NotNull
    protected DataGridSessionClient createClientInner(@NotNull Parameters parameters) {
        if (parameters == null) {
            GridDataHookUpManager.$$$reportNull$$$0(44);
        }
        DataGridSessionClient dataGridSessionClient = new DataGridSessionClient(parameters.project, parameters.session, parameters.file);
        if (dataGridSessionClient == null) {
            GridDataHookUpManager.$$$reportNull$$$0(45);
        }
        return dataGridSessionClient;
    }

    private <F extends VirtualFile, H extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> H getOrCreateHookUp(@NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(46);
        }
        if (hookUpFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(47);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(48);
        }
        return this.getOrCreateHookUp(file, hookUpFactory, parent2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends VirtualFile, H extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> H getOrCreateHookUp(final @NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent2, final boolean cache2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(49);
        }
        if (hookUpFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(50);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(51);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = this.myVirtualFileBasedHookUps.get(file);
            if (ref == null || ref.myReferenceCount <= 0) {
                GridDataHookUp hookUp = (GridDataHookUp)hookUpFactory.fun(file);
                ref = new HookUpReference(hookUp){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void dispose() {
                        super.dispose();
                        if (cache2) {
                            Object object = GridDataHookUpManager.this.myLock;
                            synchronized (object) {
                                GridDataHookUpManager.this.myVirtualFileBasedHookUps.remove(file);
                            }
                        }
                    }
                };
                if (cache2) {
                    this.myVirtualFileBasedHookUps.put(file, ref);
                }
                this.myHookUps.add(ref);
            }
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(ref));
            return (H)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T registerHookUp(T hookUp, @NotNull Disposable parent2) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(52);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = new HookUpReference(hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(ref));
            return hookUp;
        }
    }

    private Disposable createHookUpReferenceDisposable(final @NotNull HookUpReference ref) {
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(53);
        }
        if (!GridDataHookUpManager.isClosingToReopen(ref)) {
            ref.myReferenceCount++;
        }
        return new Disposable(){
            private final AtomicBoolean myDisposed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (!this.myDisposed.compareAndSet(false, true)) {
                    return;
                }
                if (GridDataHookUpManager.isClosingToReopen(ref)) {
                    return;
                }
                Object object = GridDataHookUpManager.this.myLock;
                synchronized (object) {
                    if (--ref.myReferenceCount <= 0) {
                        Disposer.dispose((Disposable)ref);
                        GridDataHookUpManager.this.myHookUps.remove(ref);
                    }
                }
            }
        };
    }

    private static boolean isClosingToReopen(@NotNull @NotNull @NotNull HookUpReference ref) {
        VirtualFile file;
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(54);
        }
        return (file = DataGridUtil.getVirtualFile(ref.myHookUp)) != null && file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) == Boolean.TRUE;
    }

    @NotNull
    private <F extends VirtualFile, H extends DatabaseGridDataHookUp, S extends DatabaseSession> Function<F, H> generator(@NotNull HookUpFactory<F, H, S> factory, @NotNull SessionFactory<S> sessionFactory) {
        if (factory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(55);
        }
        if (sessionFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(56);
        }
        Function function2 = file -> {
            if (sessionFactory == null) {
                GridDataHookUpManager.$$$reportNull$$$0(60);
            }
            if (factory == null) {
                GridDataHookUpManager.$$$reportNull$$$0(61);
            }
            DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)DbImplUtil.findDataSource(this.myProject, file));
            Object session2 = sessionFactory.create(DbImplUtil.getLocalDataSource((DasDataSource)dataSource), VfsPresentationUtil.getPresentableNameForUI((Project)this.myProject, (VirtualFile)file));
            return (DatabaseGridDataHookUp)factory.construct(file, session2);
        };
        if (function2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(57);
        }
        return function2;
    }

    @NotNull
    private static Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(58);
        }
        Document document = (Document)ObjectUtils.assertNotNull((Object)FileDocumentManager.getInstance().getDocument(file));
        if (document == null) {
            GridDataHookUpManager.$$$reportNull$$$0(59);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 57: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 57: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 46: 
            case 49: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 30: 
            case 37: 
            case 48: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 7: 
            case 22: 
            case 27: 
            case 34: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 16: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 20: 
            case 29: 
            case 32: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handle";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLightweight";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseHookUp";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockHookUp";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandle";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveClients";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createClientInner";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "generator";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHookUp";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 57: 
            case 59: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightweight";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseHookUp";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createJpaHookUp";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createMockHookUp";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getHandle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getActiveClients";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createClientInner";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHookUp";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createHookUpReferenceDisposable";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isClosingToReopen";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "generator";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generator$10";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHookUp$6";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateLightweight$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 57: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SessionFactory<S extends DatabaseSession> {
        @NotNull
        public S create(@NotNull LocalDataSource var1, @NotNull String var2);
    }

    private static interface HookUpFactory<F, H, S> {
        @NotNull
        public H construct(@NotNull F var1, @NotNull S var2);
    }

    static class Parameters
    extends SessionClientHolder.Parameters {
        final VirtualFile file;

        Parameters(@NotNull Project project, @NotNull VisibleDatabaseSession session2, @NotNull VirtualFile file) {
            if (project == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            super(project, session2);
            this.file = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/GridDataHookUpManager$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ReadOnlyDatabaseGridDataHookUp
    extends DatabaseGridDataHookUp
    implements DatabaseSessionClient<DatabaseSession> {
        private final String myQuery;

        private ReadOnlyDatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull String query, @NotNull DatabaseDepartment department) {
            if (project == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            if (department == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            super(project, session2, department);
            this.myQuery = query;
            session2.attach(this);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            DatabaseGridDataHookUp.DatabaseLoader databaseLoader = new DatabaseGridDataHookUp.DatabaseLoader(){

                @Override
                protected boolean canUpdateQueryText() {
                    return true;
                }

                @Override
                protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes) {
                    if (attributes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myQuery;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp$1", "createQueryText"));
                }
            };
            if (databaseLoader == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(4);
            }
            return databaseLoader;
        }

        @Override
        @NotNull
        public String getTitle() {
            String string = this.myQuery;
            if (string == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            DatabaseSession databaseSession = super.getSession();
            if (databaseSession == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(6);
            }
            return databaseSession;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "department";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLoader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HookUpReference
    implements Disposable {
        private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myHookUp;
        private int myReferenceCount = 0;

        private HookUpReference(GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            this.myHookUp = hookUp;
            if (this.myHookUp instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myHookUp));
            }
        }

        public void dispose() {
        }
    }

    public static class HookUpHandle {
        private final HookUpReference myRef;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookUpHandle handle = (HookUpHandle)o;
            return !(this.myRef != null ? !this.myRef.equals(handle.myRef) : handle.myRef != null);
        }

        public int hashCode() {
            return this.myRef != null ? this.myRef.hashCode() : 0;
        }

        private HookUpHandle(@Nullable HookUpReference ref) {
            this.myRef = ref;
        }
    }
}

