/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextImportTarget
implements ImportTarget {
    public static final String SEPARATOR = "\n";
    private final StringBuilder myStringBuilder = new StringBuilder();
    private long myLines;

    @Override
    public void beforeImportStart(@NotNull ImportInfo info) {
        if (info == null) {
            TextImportTarget.$$$reportNull$$$0(0);
        }
        List<? extends ColumnDescriptor> producers = info.getProducers();
        this.myStringBuilder.append("-- columns\n");
        for (int i2 = 0; i2 < producers.size(); ++i2) {
            ColumnDescriptor producer = producers.get(i2);
            this.myStringBuilder.append(producer.getTypeName()).append(SEPARATOR).append(producer.getType()).append(SEPARATOR).append(producer.getSize()).append(SEPARATOR).append(producer.getScale());
            if (i2 >= producers.size() - 1) continue;
            this.myStringBuilder.append(SEPARATOR);
        }
        this.myStringBuilder.append("\n-- data\n");
    }

    @Override
    public void afterImportEnd(@NotNull ImportInfo info) {
        if (info == null) {
            TextImportTarget.$$$reportNull$$$0(1);
        }
    }

    @Override
    @NotNull
    public List<ErrorRecord> importBatch(@NotNull ImportInfo info, @NotNull BatchRecords records) {
        if (info == null) {
            TextImportTarget.$$$reportNull$$$0(2);
        }
        if (records == null) {
            TextImportTarget.$$$reportNull$$$0(3);
        }
        this.myLines += (long)records.getLinesCount();
        for (Object[] objects : records.getRecords()) {
            this.myStringBuilder.append("|");
            for (Object object : objects) {
                this.myStringBuilder.append((String)object).append("|");
            }
            this.myStringBuilder.append(SEPARATOR);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TextImportTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public Long getInsertedRows() {
        return this.myLines;
    }

    public String toString() {
        return this.myStringBuilder.toString();
    }

    @Override
    @NotNull
    public ImportTarget.Combination combine(@NotNull ReaderTask.Input input) {
        if (input == null) {
            TextImportTarget.$$$reportNull$$$0(5);
        }
        ImportTarget.Combination combination = ImportTarget.ConcurrentCombination.INSTANCE;
        if (combination == null) {
            TextImportTarget.$$$reportNull$$$0(6);
        }
        return combination;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/TextImportTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/TextImportTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "importBatch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeImportStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "afterImportEnd";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importBatch";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

