/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u001a \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a9\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0005\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u001a\u001a\u00020\u00192\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f0\u001b\u001a\u0017\u0010\u001c\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001d\"@\u0010\u0000\u001a4\u00120\u0012.\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004 \u0006*\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"UNSORTED_COLUMNS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/database/model/basic/BasicLikeTable;", "", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "kotlin.jvm.PlatformType", "computeUnsorted", "srcTable", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "findSortedPrefix", "", "columns", "", "Lcom/intellij/database/model/ElementAlteration;", "lens", "", "end", "(Ljava/util/List;[Ljava/lang/Integer;I)I", "getPrevColumn", "col", "getUnsortedColumns", "getUnsortedHolder", "hasExistingColumnAfter", "", "nullizeSorted", "", "indexOfMax", "([Ljava/lang/Integer;)I", "intellij.database.dialects"})
public final class LikeColumnProducersKt {
    private static final Key<Map<BasicLikeTable, Set<BasicLikeColumn>>> UNSORTED_COLUMNS;

    @Nullable
    public static final BasicLikeColumn getPrevColumn(@NotNull BasicLikeColumn col) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        short pos = col.getPosition();
        if (pos == (short)1) {
            return null;
        }
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicNode, (String)"col.likeTable?.columns ?: return null");
        BasicNode columns = basicNode;
        short maxPos = (short)0;
        BasicLikeColumn maxCol = null;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur;
            BasicLikeColumn basicLikeColumn = cur = (BasicLikeColumn)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeColumn, (String)"cur");
            short curPos = basicLikeColumn.getPosition();
            if (curPos >= pos || curPos <= maxPos) continue;
            maxPos = curPos;
            maxCol = cur;
        }
        return maxCol;
    }

    public static final boolean hasExistingColumnAfter(@NotNull BasicLikeColumn col, @NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getByTarget().isEmpty()) {
            return false;
        }
        short pos = col.getPosition();
        BasicNode basicNode = col.getLikeTable();
        if (basicNode == null || (basicNode = basicNode.getColumns()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicNode, (String)"col.likeTable?.columns ?: return false");
        BasicNode columns = basicNode;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur;
            BasicLikeColumn basicLikeColumn = cur = (BasicLikeColumn)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeColumn, (String)"cur");
            if (basicLikeColumn.getPosition() <= pos) continue;
            ElementDelta<?> elementDelta = context.getByTarget().get(cur);
            if ((elementDelta != null ? elementDelta.getSourceElement() : null) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<BasicLikeColumn> getUnsortedColumns(BasicLikeTable srcTable, ScriptingContext context) {
        Set<BasicLikeColumn> set;
        Map<BasicLikeTable, Set<BasicLikeColumn>> $receiver$iv = LikeColumnProducersKt.getUnsortedHolder(context);
        Set<BasicLikeColumn> value$iv = $receiver$iv.get(srcTable);
        if (value$iv == null) {
            Set<BasicLikeColumn> set2 = LikeColumnProducersKt.computeUnsorted(srcTable, context);
            if (set2 == null) {
                Set set3 = Collections.emptySet();
                set2 = set3;
                Intrinsics.checkExpressionValueIsNotNull(set3, (String)"Collections.emptySet()");
            }
            Set<BasicLikeColumn> answer$iv = set2;
            $receiver$iv.put(srcTable, answer$iv);
            set = answer$iv;
        } else {
            void var3_3;
            set = var3_3;
        }
        return set;
    }

    private static final Map<BasicLikeTable, Set<BasicLikeColumn>> getUnsortedHolder(ScriptingContext context) {
        Map map = (Map)UNSORTED_COLUMNS.get(context.getSharedData());
        if (map != null) {
            Map map2;
            Map it = map2 = map;
            return it;
        }
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap\u2026, Set<BasicLikeColumn>>()");
        HashMap res2 = hashMap;
        UNSORTED_COLUMNS.set(context.getSharedData(), (Object)res2);
        return res2;
    }

    private static final Set<BasicLikeColumn> computeUnsorted(BasicLikeTable srcTable, ScriptingContext context) {
        Comparator comparator;
        ArrayList arrayList = ContainerUtil.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayLi\u2026tion<BasicLikeColumn>?>()");
        ArrayList columns = arrayList;
        for (BasicLikeColumn basicLikeColumn : srcTable.getColumns()) {
            ElementDelta<?> elementDelta = context.getBySource().get(basicLikeColumn);
            if (!(elementDelta instanceof ElementAlteration)) {
                elementDelta = null;
            }
            if ((ElementAlteration)elementDelta == null) continue;
            Object it = comparator;
            if ((BasicLikeColumn)((ElementAlteration)it).getTargetElement() == basicLikeColumn) continue;
            columns.add(it);
        }
        if (columns.isEmpty()) {
            return null;
        }
        List list = columns;
        if (list.size() > 1) {
            List iterable = list;
            comparator = new Comparator<T>(){

                public final int compare(T a, T b2) {
                    ElementAlteration it;
                    ElementAlteration elementAlteration = it = (ElementAlteration)a;
                    if (elementAlteration == null) {
                        Intrinsics.throwNpe();
                    }
                    it = (ElementAlteration)b2;
                    Comparable comparable = Short.valueOf(((BasicLikeColumn)elementAlteration.getSourceElement()).getPosition());
                    ElementAlteration elementAlteration2 = it;
                    if (elementAlteration2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Short s = ((BasicLikeColumn)elementAlteration2.getSourceElement()).getPosition();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)s);
                }
            };
            CollectionsKt.sortWith((List)iterable, (Comparator)comparator);
        }
        if (!LikeColumnProducersKt.nullizeSorted(columns)) {
            return null;
        }
        Iterable iterable = columns;
        Collection destination$iv = ContainerUtil.newHashSet();
        Iterable $receiver$iv$iv = iterable;
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn basicLikeColumn;
            ElementAlteration it;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            ElementAlteration elementAlteration = it = (ElementAlteration)element$iv;
            BasicLikeColumn basicLikeColumn2 = elementAlteration != null ? (BasicLikeColumn)elementAlteration.getSourceElement() : null;
            if (basicLikeColumn2 == null) continue;
            BasicLikeColumn it$iv = basicLikeColumn = basicLikeColumn2;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean nullizeSorted(@NotNull List<ElementAlteration<BasicLikeColumn>> columns) {
        Integer n;
        Integer[] integerArray;
        void var15_16;
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        int size$iv = columns.size();
        Integer[] result$iv = new Integer[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            void i$iv;
            void var6_13 = i$iv;
            var15_16 = i$iv++;
            integerArray = result$iv;
            integerArray[var15_16] = n = Integer.valueOf(0);
        }
        Integer[] lens = result$iv;
        int size$iv2 = columns.size();
        Integer[] result$iv2 = new Integer[size$iv2];
        n3 = 0;
        int it = result$iv2.length;
        while (n3 < it) {
            void i$iv;
            void $i$a$1$<init> = i$iv;
            var15_16 = i$iv++;
            integerArray = result$iv2;
            integerArray[var15_16] = n = Integer.valueOf(-1);
        }
        Integer[] backRefs = result$iv2;
        Iterable $receiver$iv = columns;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n4;
            if ((n4 = index$iv++) < 0) {
                throw (Throwable)new ArithmeticException("Index overflow has happened.");
            }
            int n5 = n4;
            ElementAlteration $i$f$Array = (ElementAlteration)item$iv;
            int i2 = n5;
            int maxi = LikeColumnProducersKt.findSortedPrefix(columns, lens, i2);
            backRefs[i2] = maxi;
            lens[i2] = maxi == -1 ? 1 : lens[maxi] + 1;
        }
        int idx = LikeColumnProducersKt.indexOfMax(lens);
        if (lens[idx].intValue() == columns.size()) {
            return false;
        }
        while (idx != -1) {
            columns.set(idx, null);
            idx = backRefs[idx];
        }
        return true;
    }

    private static final int findSortedPrefix(List<? extends ElementAlteration<? extends BasicLikeColumn>> columns, Integer[] lens, int end) {
        ElementAlteration<? extends BasicLikeColumn> elementAlteration = columns.get(end);
        if (elementAlteration == null) {
            Intrinsics.throwNpe();
        }
        short pos = elementAlteration.getTargetElement().getPosition();
        int max = 0;
        int maxi = -1;
        int k = end - 1;
        while (k >= 0) {
            int kk = k--;
            ElementAlteration<? extends BasicLikeColumn> prev = columns.get(kk);
            int cur = lens[kk] + 1;
            if (cur <= max) continue;
            ElementAlteration<? extends BasicLikeColumn> elementAlteration2 = prev;
            if (elementAlteration2 == null) {
                Intrinsics.throwNpe();
            }
            if (pos <= elementAlteration2.getTargetElement().getPosition()) continue;
            max = cur;
            maxi = kk;
            if (max != kk + 1) continue;
            return maxi;
        }
        return maxi;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfMax(@NotNull Integer[] $receiver) {
        int maxi = 0;
        int max = ((Number)$receiver[0]).intValue();
        Integer[] $receiver$iv = $receiver;
        int index$iv = 0;
        for (Integer item$iv : $receiver$iv) {
            void v;
            int n = index$iv++;
            int n2 = ((Number)item$iv).intValue();
            int i2 = n;
            if (max >= v) continue;
            max = v;
            maxi = i2;
        }
        return maxi;
    }

    static {
        Key key2 = Key.create((String)"UNSORTED_COLUMNS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<MutableMap<Ba\u2026mn>>>(\"UNSORTED_COLUMNS\")");
        UNSORTED_COLUMNS = key2;
    }

    @NotNull
    public static final /* synthetic */ Set access$getUnsortedColumns(@NotNull BasicLikeTable srcTable, @NotNull ScriptingContext context) {
        return LikeColumnProducersKt.getUnsortedColumns(srcTable, context);
    }
}

