/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.hsql.model.HsqlDatabase;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.Casing;
import com.intellij.database.util.Version;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface HsqlRoot
extends BasicMultiDatabaseRoot {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            HsqlRoot.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends HsqlDatabase> getDatabases();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.DATABASE);
        if (list == null) {
            HsqlRoot.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<NamingFamily<? extends HsqlDatabase>> list = Collections.singletonList(this.getDatabases());
        if (list == null) {
            HsqlRoot.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        Dbms dbms;
        Version serverVersion;
        if (consumer2 == null) {
            HsqlRoot.$$$reportNull$$$0(3);
        }
        if ((serverVersion = this.getServerVersion()) != null) {
            consumer2.accept("ServerVersion", PropertyConverter.export(serverVersion));
        }
        if ((dbms = this.getDbms()) != null && dbms != Dbms.HSQL) {
            consumer2.accept("Dbms", PropertyConverter.export(dbms));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ServerVersion", "Dbms");
        if (list == null) {
            HsqlRoot.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    default public Casing getDefaultCasing() {
        return BasicNamespace.UPPER_CASING;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/hsql/model/HsqlRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/hsql/model/HsqlRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

