/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.OracleConsoleUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class OracleProcessDbmsOutputAction
extends ToggleAction {
    private static final Key<MyDataAuditor> DBMS_LISTENER = Key.create((String)"DBMS_LISTENER");
    private static final int BYTES_TO_LOAD = 0x100000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OracleProcessDbmsOutputAction.$$$reportNull$$$0(0);
        }
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        if (console != null) {
            super.update(e);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            OracleProcessDbmsOutputAction.$$$reportNull$$$0(1);
        }
        return (console = OracleConsoleUtils.getOracleConsole(e)) != null && console.getUserData(DBMS_LISTENER) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        JdbcConsole console;
        if (e == null) {
            OracleProcessDbmsOutputAction.$$$reportNull$$$0(2);
        }
        if ((console = OracleConsoleUtils.getOracleConsole(e)) == null) {
            return;
        }
        if (state) {
            MyDataAuditor listener = new MyDataAuditor(console);
            Disposer.register((Disposable)console, (Disposable)listener);
            console.getMessageBus().addAuditor(listener);
            console.putUserData(DBMS_LISTENER, listener);
        } else {
            MyDataAuditor listener = (MyDataAuditor)console.getUserData(DBMS_LISTENER);
            if (listener != null) {
                console.putUserData(DBMS_LISTENER, null);
                Disposer.dispose((Disposable)listener);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/dialects/oracle/OracleProcessDbmsOutputAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDataAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final JdbcConsole myConsole;

        MyDataAuditor(JdbcConsole console) {
            this.myConsole = console;
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            DatabaseConnection connection2;
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(0);
            }
            if ((connection2 = OracleConsoleUtils.getConnection(context)) == null) {
                return;
            }
            this.execute(context, SmartStatements.poweredBy(connection2), "{call sys.dbms_output.enable(1048576)}");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            DatabaseConnection connection2;
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(1);
            }
            if ((connection2 = OracleConsoleUtils.getConnection(context)) == null) {
                return;
            }
            String sql = "{call sys.dbms_output.get_line(?, ?)}";
            CallableStatementBasis data = new StatementParameters().parameter(1, 12).parameter(2, 4).asCallBasis(sql);
            SmartStatements statements2 = SmartStatements.poweredBy(connection2);
            Configuration configuration = Configuration.sourced(SmartStatements.Source.SYSTEM);
            try (ReusableSmartStatement<ParameterizedStatementDecoration> call2 = statements2.call(configuration).reuse(data);){
                int status;
                do {
                    try (ClosableResultsProducer producer = call2.noisy().execute(StatementParameters.getEmpty(), StandardExecutionMode.GENERIC);){
                        Object first = producer.getParameterValue(1);
                        if (first instanceof String) {
                            this.myConsole.getHistoryLogger().warn(context, (String)first);
                        }
                        Object second = producer.getParameterValue(2);
                        status = (Integer)second;
                    }
                } while (status == 0);
            }
            catch (SQLException call2) {
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
            finally {
                this.execute(context, statements2, "{call sys.dbms_output.disable()}");
            }
        }

        protected void execute(@NotNull DataRequest.Context context, @NotNull SmartStatements statements2, @NotNull String statement) {
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(2);
            }
            if (statements2 == null) {
                MyDataAuditor.$$$reportNull$$$0(3);
            }
            if (statement == null) {
                MyDataAuditor.$$$reportNull$$$0(4);
            }
            try {
                statements2.simple(Configuration.sourced(SmartStatements.Source.SYSTEM)).barren().quiet().execute(statement);
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/oracle/OracleProcessDbmsOutputAction$MyDataAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

