/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public interface OraMixinMatLog
extends BasicMinorObject,
BasicNamedElement {
    @Override
    public OraSchema getSchema();

    public boolean isWithRowId();

    public boolean isWithObjectId();

    public boolean isWithPrimaryKey();

    public boolean isWithSequence();

    public boolean isWithNewValues();

    @Override
    @NotNull
    default public String identity(boolean includingSurrogate) {
        String string = includingSurrogate ? BasicNamedElement.super.identity(true) : "#ML";
        if (string == null) {
            OraMixinMatLog.$$$reportNull$$$0(0);
        }
        return string;
    }

    default public String withOptions() {
        OraTable table;
        StringBuilder b2 = new StringBuilder(60);
        ArrayList<String> opts = new ArrayList<String>(3);
        if (this.isWithRowId()) {
            opts.add("rowid");
        }
        if (this.isWithObjectId()) {
            opts.add("object id");
        }
        if (this.isWithPrimaryKey()) {
            opts.add("primary key");
        }
        if (this.isWithSequence()) {
            opts.add("sequence");
        }
        b2.append("with ");
        StringUtil.join(opts, (String)", ", (StringBuilder)b2);
        OraSchema schema = this.getSchema();
        if (schema != null && (table = (OraTable)schema.getTables().get(this.getName())) != null) {
            boolean was = false;
            for (OraTableColumn oraTableColumn : table.getColumns()) {
                String name = oraTableColumn.getRealName();
                if (name == null || name.endsWith("$$")) continue;
                b2.append(was ? ", " : " (").append(name);
                was = true;
            }
            if (was) {
                b2.append(')');
            }
        }
        return b2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/oracle/model/OraMixinMatLog", "identity"));
    }
}

