/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgExtension;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PgRelation;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgDatabase
extends PgBaseDatabase,
PgBaseCatalogObject,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.DATABASE;
        if (objectKind == null) {
            PgDatabase.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public PgRoot getRoot();

    @Override
    @Nullable
    default public PgRoot getParent() {
        return this.getRoot();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgDatabase> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgSchema> getSchemas();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgForeignDataWrapper> getForeignDataWrappers();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgAccessMethod> getAccessMethods();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgExtension> getExtensions();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SCHEMA, ObjectKind.FOREIGN_DATA_WRAPPER, ObjectKind.ACCESS_METHOD, ObjectKind.EXTENSION);
        if (list == null) {
            PgDatabase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSchemas(), this.getForeignDataWrappers(), this.getAccessMethods(), this.getExtensions());
        if (list == null) {
            PgDatabase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @Nullable
    default public String getOwner() {
        return null;
    }

    @Override
    default public boolean isFaceless() {
        return false;
    }

    default public long getIntrospectionStateNumber() {
        return 0L;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @NotNull
    default public Set<PgRelation> getRelations() {
        Set<PgRelation> set = Collections.emptySet();
        if (set == null) {
            PgDatabase.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        Set<PgRelation> relations;
        boolean visible;
        boolean current;
        long introspectionStateNumber;
        boolean faceless;
        String owner;
        long stateNumber;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            PgDatabase.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer2.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((owner = this.getOwner()) != null) {
            consumer2.accept("Owner", PropertyConverter.export(owner));
        }
        if (faceless = this.isFaceless()) {
            consumer2.accept("Faceless", PropertyConverter.export(faceless));
        }
        if ((introspectionStateNumber = this.getIntrospectionStateNumber()) != 0L) {
            consumer2.accept("IntrospectionStateNumber", PropertyConverter.export(introspectionStateNumber));
        }
        if (current = this.isCurrent()) {
            consumer2.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer2.accept("Visible", PropertyConverter.export(visible));
        }
        if (!(relations = this.getRelations()).isEmpty()) {
            consumer2.accept("Relations", PropertyConverter.exportSetOfPgRelation(relations));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "StateNumber", "Owner", "Faceless", "IntrospectionStateNumber", "Current", "Visible", "Relations");
        if (list == null) {
            PgDatabase.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgDatabase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgDatabase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

