/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSchemaAction
extends AlignedIconWithTextAction.Group
implements DumbAware {
    private static final Comparator<ObjectPath> PATH_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final FileAttribute SELECTED_SEARCH_PATH_ATTR = new FileAttribute("datasource_namespace", 2, true);

    public void actionPerformed(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(0);
        }
        if ((console = JdbcConsole.findConsole(e)) == null) {
            return;
        }
        WizardPopup popup = ChooseSchemaAction.createPopupForStep(null, ChooseSchemaAction.createInitialStep(console), null);
        DbUIUtil.showPopup((JBPopup)popup, null, e);
        popup.pack(true, true);
    }

    public void update(@NotNull AnActionEvent e) {
        ObjectKind kind;
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(1);
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        Presentation presentation = e.getPresentation();
        ObjectKind objectKind = kind = console == null ? null : DbImplUtil.getDatabaseDialect(console).getSearchPathObjectKind();
        if (console == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        List schemas2 = SearchPath.getElements((SearchPath)console.getSearchPath());
        if (schemas2.isEmpty() || ((ObjectPath)schemas2.get((int)0)).kind == ObjectKind.NONE) {
            schemas2 = SearchPath.getElements((SearchPath)((SearchPath)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)console.getFile())));
        }
        ObjectKind expected = (ObjectKind)ObjectUtils.chooseNotNull((Object)kind, (Object)ObjectKind.SCHEMA);
        boolean shorter = !schemas2.isEmpty() && ((ObjectPath)schemas2.get((int)0)).kind != expected;
        boolean isToolbar = e.isFromActionToolbar();
        String schemasText = isToolbar && !schemas2.isEmpty() ? ChooseSchemaAction.buildText(schemas2) : "";
        String placeholder = StringUtil.toLowerCase((String)expected.name());
        String text2 = !isToolbar ? "Switch Current Schema" : StringUtil.shortenTextWithEllipsis((String)(StringUtil.isEmpty((String)schemasText) ? "<" + placeholder + ">" : (shorter ? schemasText + ".<" + placeholder + ">" : schemasText)), (int)30, (int)0);
        presentation.setText(text2, false);
        presentation.setDescription("Switches Current Schema");
    }

    @NotNull
    private static String buildText(List<ObjectPath> schemas2) {
        StringBuilder res2 = new StringBuilder();
        int pos = 0;
        while (pos < schemas2.size()) {
            if (res2.length() != 0) {
                res2.append("; ");
            }
            ObjectPath cur = schemas2.get(pos);
            if (++pos < schemas2.size() && cur.parent != null && cur.parent.equals((Object)schemas2.get((int)pos).parent)) {
                res2.append(cur.parent.getDisplayName());
                res2.append(": ");
                res2.append(cur.getName()).append(", ").append(schemas2.get(pos).getName());
                ++pos;
                while (pos < schemas2.size() && cur.parent.equals((Object)schemas2.get((int)pos).parent)) {
                    res2.append(", ").append(schemas2.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res2.append(cur.getDisplayName());
        }
        String string = res2.toString();
        if (string == null) {
            ChooseSchemaAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static WizardPopup createPopupForStep(@Nullable WizardPopup parent2, @NotNull ListPopupStep<ObjectPath> step, @Nullable ObjectPath parentValue) {
        if (step == null) {
            ChooseSchemaAction.$$$reportNull$$$0(3);
        }
        if (step instanceof SearchPathStep) {
            return new SearchPathPopup(parent2, (SearchPathStep)step, parentValue);
        }
        if (step instanceof DbScStep) {
            return new DbScListPopup(parent2, (DbScStep)step, parentValue);
        }
        return new SimpleListPopup(parent2, step, parentValue);
    }

    @NotNull
    private static ListPopupStep<ObjectPath> createInitialStep(@NotNull JdbcConsole console) {
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(4);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        if (JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)console.getTarget()) && dialect.getSearchPathObjectKind() != ObjectKind.DATABASE) {
            DbScStep dbScStep = new DbScStep(console);
            if (dbScStep == null) {
                ChooseSchemaAction.$$$reportNull$$$0(5);
            }
            return dbScStep;
        }
        BaseStep baseStep = dialect.supportsSearchPath() ? new SearchPathStep(console) : new SingleScOrDbStep(console);
        if (baseStep == null) {
            ChooseSchemaAction.$$$reportNull$$$0(6);
        }
        return baseStep;
    }

    public static void scheduleSavedSchemaSwitch(@NotNull JdbcConsole console) {
        SearchPath o;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(7);
        }
        if ((o = ChooseSchemaAction.getSchemaToSwitchToInner(console)) == null) {
            return;
        }
        SearchPath path = DbImplUtil.getAutoSwitchPath(console.getDataSource(), o);
        if (path == null) {
            return;
        }
        console.switchSchema(path, false);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)console.getFile(), (Object)path);
    }

    @Nullable
    private static SearchPath getSchemaToSwitchToInner(@NotNull JdbcConsole console) {
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(8);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        SearchPath schemaPaths = ChooseSchemaAction.getSelectedSearchPath(console.getVirtualFile(), dialect);
        if (schemaPaths != null && schemaPaths.getCurrent().kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (localDataSource.isLoading()) {
                DataSourceUiUtil.promiseFacadeUpdate(DbPsiFacade.getInstance((Project)console.getProject()), console).onProcessed(o -> {
                    if (console == null) {
                        ChooseSchemaAction.$$$reportNull$$$0(22);
                    }
                    ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
                });
            } else {
                return SearchPath.of((List)JBIterable.from((Iterable)SearchPath.getElements((SearchPath)schemaPaths)).filter(p2 -> {
                    if (console == null) {
                        ChooseSchemaAction.$$$reportNull$$$0(21);
                    }
                    return (p2.kind == ObjectKind.SCHEMA || p2.kind == ObjectKind.DATABASE) && DatabaseEditorHelper.findNamespace(console.getProject(), localDataSource, p2) != null;
                }).toList());
            }
        }
        return null;
    }

    public static void setSelectedSearchPath(@NotNull VirtualFile file, @Nullable SearchPath schemaPaths) {
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(9);
        }
        DbImplUtil.writeVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR, ChooseSchemaAction.serialize(schemaPaths));
    }

    @Nullable
    private static SearchPath getSelectedSearchPath(@NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            ChooseSchemaAction.$$$reportNull$$$0(11);
        }
        return ChooseSchemaAction.deserializeList(DbImplUtil.readVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR), dialect.getMetaModel());
    }

    @Nullable
    private static SearchPath deserializeList(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            ChooseSchemaAction.$$$reportNull$$$0(12);
        }
        if (o == null) {
            return null;
        }
        return SearchPath.of((List)JBIterable.of((Object[])o.split(",")).transform(x -> {
            if (metaModel == null) {
                ChooseSchemaAction.$$$reportNull$$$0(20);
            }
            return ObjectPaths.deserialize(x, metaModel);
        }).toList());
    }

    @Contract(value="!null->!null")
    private static String serialize(@Nullable SearchPath o) {
        if (o == null) {
            return null;
        }
        return StringUtil.join((Collection)o.elements, ObjectPaths::serialize, (String)",");
    }

    @NotNull
    protected static String getText(ObjectPath value) {
        if (value == null) {
            if ("" == null) {
                ChooseSchemaAction.$$$reportNull$$$0(13);
            }
            return "";
        }
        String text2 = value.getName();
        String string = text2.isEmpty() ? "<unnamed " + StringUtil.toLowerCase((String)value.kind.toString()) + ">" : text2;
        if (string == null) {
            ChooseSchemaAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean canSwitchTo(DatabaseDialectEx dialect, ObjectPath path) {
        return DbImplUtil.canSwitchTo(SearchPath.of((ObjectPath)path), dialect);
    }

    private static JBTreeTraverser<? extends DasObject> traverser(@NotNull DasModel model) {
        if (model == null) {
            ChooseSchemaAction.$$$reportNull$$$0(15);
        }
        return model instanceof BasicModel ? ((BasicModel)model).traverser(true) : model.traverser();
    }

    private static void switchSearchPath(@NotNull JdbcConsole console, @NotNull SearchPath path) {
        DatabaseDialectEx dialect;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(16);
        }
        if (path == null) {
            ChooseSchemaAction.$$$reportNull$$$0(17);
        }
        if ((dialect = DbImplUtil.getDatabaseDialect(console)).getSearchPathObjectKind() != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (console == null) {
                    ChooseSchemaAction.$$$reportNull$$$0(18);
                }
                if (path == null) {
                    ChooseSchemaAction.$$$reportNull$$$0(19);
                }
                console.switchSchema(path, true);
            });
            return;
        }
        final ObjectPath current = path.getCurrent();
        console.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(console){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) throws Exception {
                Connection c2 = connection2.getJdbcConnection();
                if (current.kind == ObjectKind.SCHEMA) {
                    c2.setSchema(current.getName());
                    if (!Comparing.equal((String)current.getName(), (String)c2.getSchema())) {
                        throw new UnsupportedOperationException("Schema switch is not supported by driver");
                    }
                } else if (current.kind == ObjectKind.DATABASE) {
                    c2.setCatalog(current.getName());
                    if (!Comparing.equal((String)current.getName(), (String)c2.getCatalog())) {
                        throw new UnsupportedOperationException("Database switch is not supported by driver");
                    }
                } else {
                    throw new UnsupportedOperationException(StringUtil.capitalize((String)StringUtil.toLowerCase((String)current.kind.toString())) + " switch is not supported by driver");
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialStep";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopupForStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSavedSchemaSwitch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaToSwitchToInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedSearchPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedSearchPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "traverser";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "switchSearchPath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$switchSearchPath$4";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deserializeList$3";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSchemaToSwitchToInner$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSchemaToSwitchToInner$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ElementWithControlRenderer<T>
    extends PopupListElementRenderer<T> {
        private int myControlIndex;
        public final Color UNFOCUSED;

        ElementWithControlRenderer(final @NotNull ListPopupImpl popup) {
            if (popup == null) {
                ElementWithControlRenderer.$$$reportNull$$$0(0);
            }
            super(popup);
            this.myControlIndex = -1;
            this.UNFOCUSED = UIUtil.mix((Color)this.getSelectionBackground(), (Color)this.getBackground(), (double)0.2);
            popup.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int i2;
                    JList list = popup.getList();
                    int i0 = myControlIndex;
                    int i1 = list.locationToIndex(e.getPoint());
                    int n = i2 = i1 != -1 && !this.isInControlZone(i1, e.getPoint()) ? -1 : i1;
                    if (i0 < 0 && i1 < 0) {
                        return;
                    }
                    myControlIndex = i2;
                    Rectangle bounds = list.getCellBounds(i0 < 0 ? i1 : i0, i1 < 0 ? i0 : i1);
                    list.repaint(bounds);
                }
            });
            this.myNextStepLabel.setHorizontalAlignment(0);
            this.myNextStepLabel.setOpaque(true);
            ((JComponent)this.myTextLabel.getParent()).setBorder((Border)JBUI.Borders.empty((int)UIUtil.getListCellVPadding(), (int)0));
        }

        protected void highlightZones(JList<? extends T> list, T value) {
            boolean ctrl = this.isControl(list, value);
            if (ctrl) {
                UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)this.UNFOCUSED);
            }
            if (this.myNextStepLabel.getIcon() != null) {
                this.myNextStepLabel.setBackground(ctrl ? this.getSelectionBackground() : this.UNFOCUSED);
            }
        }

        protected boolean isControl(JList<? extends T> list, T value) {
            return this.myControlIndex != -1 && this.myControlIndex < list.getModel().getSize() && list.getModel().getElementAt(this.myControlIndex) == value;
        }

        protected abstract boolean isInControlZone(int var1, Point var2);

        protected Border getDefaultItemComponentBorder() {
            return JBUI.Borders.emptyLeft((int)UIUtil.getListCellHPadding());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/actions/ChooseSchemaAction$ElementWithControlRenderer", "<init>"));
        }
    }

    private static class DbScListPopup
    extends SimpleListPopup {
        private static final int ZONE_SIZE = 20;

        DbScListPopup(@Nullable WizardPopup parent2, @NotNull DbScStep step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                DbScListPopup.$$$reportNull$$$0(0);
            }
            super(parent2, step, parentValue);
            Dimension sz = new Dimension(0, 0);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.updateAdvertisement(i2 % 2 == 0, i2 / 2 == 0);
                Dimension pref = this.getContent().getPreferredSize();
                sz.width = Math.max(sz.width, pref.width);
                sz.height = Math.max(sz.height, pref.height);
            }
            sz.width = this.trimWidth(sz.width + 20);
            this.getContent().setPreferredSize(sz);
            this.updateAdvertisement(this.getMousePos());
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
            Insets padding = UIUtil.getListViewportPadding();
            this.getList().setBorder((Border)JBUI.Borders.empty((int)padding.top, (int)padding.left, (int)padding.bottom, (int)0));
        }

        private void updateAdvertisement(@NotNull Point pt) {
            int idx;
            if (pt == null) {
                DbScListPopup.$$$reportNull$$$0(1);
            }
            this.updateAdvertisement((idx = this.getList().locationToIndex(pt)) != -1 && this.isInControlZone(idx, pt), idx != -1 && idx == this.getStep().getDefaultOptionIndex());
        }

        private void updateAdvertisement(boolean ctrl, boolean cur) {
            if (ctrl) {
                this.setAdText("<html>Configure search path</html>");
            } else if (cur) {
                this.setAdText("<html>Set default search path (Enter)</html>");
            } else {
                this.setAdText("<html>Connect to database (Enter)</html>");
            }
        }

        protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
            int index2 = this.getList().locationToIndex(e.getPoint());
            if (index2 == -1) {
                return super.handleFinalChoices(e, selectedValue, listStep);
            }
            return !this.isInControlZone(index2, e.getPoint());
        }

        public void handleSelect(boolean handleFinalChoices) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices);
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices, e);
        }

        public DbScStep getStep() {
            return (DbScStep)super.getStep();
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        private boolean isInControlZone(int index2, Point pt) {
            Rectangle bounds = this.getList().getCellBounds(index2, index2);
            ObjectPath val = this.getList().getModel().getElementAt(index2);
            return bounds.contains(pt) && pt.x > bounds.x + bounds.width - 20 && this.getStep().hasSubstep(val);
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new ElementWithControlRenderer<ObjectPath>((ListPopupImpl)this){
                {
                    super(popup);
                    this.myNextStepLabel.setPreferredSize(new Dimension(20, 20));
                }

                protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value, boolean isSelected) {
                    super.customizeComponent(list, (Object)value, isSelected);
                    if (isSelected) {
                        this.highlightZones(list, value);
                    } else if (myChild instanceof SimpleListPopup && myChild.isVisible() && ((SimpleListPopup)myChild).getParentValue() == value) {
                        UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)UIUtil.getListUnfocusedSelectionBackground());
                    }
                }

                @Override
                protected boolean isInControlZone(int idx, Point pt) {
                    return this.isInControlZone(idx, pt);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pt";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScListPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAdvertisement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SearchPathPopup
    extends SimpleListPopup {
        private final String IN_PATH_AD;
        private static final String OUT_PATH_AD = "<html>Replace search path (Enter)<br>&nbsp;</html>";
        private static final String IN_PATH_CTRL_AD = "<html>Remove from search path<br>(Space)</html>";
        private static final String OUT_PATH_CTRL_AD = "<html>Add to search path (Ctrl+click<br>schema name or Space)</html>";
        private static final int ZONE_SIZE = 30;
        private final JComponent myButtonsPanel;

        SearchPathPopup(@Nullable WizardPopup parent2, @NotNull SearchPathStep step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                SearchPathPopup.$$$reportNull$$$0(0);
            }
            super(parent2, step, parentValue);
            this.IN_PATH_AD = "<html>Drag to reorder<br>(" + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_UP.getShortcuts()) + " / " + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_DOWN.getShortcuts()) + ")</html>";
            this.registerAction("Select schema", 10, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.replaceItem(this.getSelectedValue(), this.getStep());
                    this.apply();
                }
            });
            this.registerAction("Apply schemas", 10, 2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            });
            this.registerAction("Toggle schema", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleItem(this.getSelectedValue());
                }
            });
            new AnAction("Move up"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, this.getList());
            new AnAction("Move down"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, this.getList());
            this.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean ctrl;
                    int listIdx = this.getList().locationToIndex(e.getPoint());
                    if (listIdx == -1) {
                        return;
                    }
                    ObjectPath item = this.getList().getModel().getElementAt(listIdx);
                    if (item == null) {
                        return;
                    }
                    SearchPathStep step = this.getStep();
                    boolean bl = ctrl = (e.getModifiers() & 2) != 0 || this.isInControlZone(listIdx, e.getPoint());
                    if (ctrl) {
                        this.toggleItem(item);
                    } else {
                        this.replaceItem(item, step);
                    }
                }
            });
            RowsDnDSupport.install(this.getList(), (EditableModel)new EditableModel(){

                public void addRow() {
                    throw new UnsupportedOperationException();
                }

                public void exchangeRows(int oldIndex, int newIndex) {
                    SearchPathStep step = this.getStep();
                    ObjectPath item = step.getValues().get(oldIndex);
                    List<ObjectPath> path = step.getPathItems();
                    if (newIndex <= path.size()) {
                        step.moveInPath(item, newIndex);
                    } else if (path.indexOf(item) != -1) {
                        step.removeFromPath(item);
                    } else {
                        return;
                    }
                    this.update(item);
                }

                public boolean canExchangeRows(int oldIndex, int newIndex) {
                    List<ObjectPath> path = this.getStep().getPathItems();
                    return oldIndex <= path.size() || newIndex <= path.size();
                }

                public void removeRow(int idx) {
                    throw new UnsupportedOperationException();
                }
            });
            Dimension sz = new Dimension(0, 0);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.updateAdvertisement(i2 % 2 == 0, i2 / 2 == 0);
                Dimension pref = this.getContent().getPreferredSize();
                sz.width = Math.max(sz.width, pref.width);
                sz.height = Math.max(sz.height, pref.height);
            }
            int extra = 20;
            if (step.getPathItems().isEmpty()) {
                sz.height += extra;
            }
            if (step.getPathItems().size() == step.getValues().size()) {
                sz.height += extra;
            }
            sz.width = this.trimWidth(sz.width + extra);
            this.getContent().setPreferredSize(sz);
            this.updateAdvertisement(this.getMousePos());
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
            Insets padding = UIUtil.getListViewportPadding();
            this.getList().setBorder((Border)JBUI.Borders.empty((int)padding.top, (int)padding.left, (int)padding.bottom, (int)0));
            this.myButtonsPanel = new JPanel(new GridLayout(1, 2));
            this.getContent().add((Component)JBUI.Panels.simplePanel().addToCenter((Component)this.getComponent()).addToBottom((Component)this.myButtonsPanel), "Center");
            GridConstraints constraints = new GridConstraints();
            this.myButtonsPanel.add((Component)new JButton(new AbstractAction(CommonBundle.getOkButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            }), constraints);
            constraints.setColumn(1);
            this.myButtonsPanel.add(new JButton(new AbstractAction(CommonBundle.getCancelButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPathStep step = this.getStep();
                    step.reset();
                    this.update(null);
                }
            }));
            this.myButtonsPanel.setVisible(false);
        }

        public void apply() {
            SearchPathStep step = this.getStep();
            JdbcConsole console = step.getConsole();
            SearchPath p2 = SearchPath.of(step.getPathItems());
            if (p2 != null && !p2.equals((Object)console.getSearchPath())) {
                ChooseSchemaAction.switchSearchPath(console, p2);
            }
            this.closeOk(null);
            this.disposeAllParents(null);
        }

        public void replaceItem(ObjectPath item, SearchPathStep step) {
            if (item == null) {
                return;
            }
            int idx = step.getValues().indexOf(item);
            for (ObjectPath path : ContainerUtil.newArrayList(step.getPathItems())) {
                step.removeFromPath(path);
            }
            step.moveInPath(item, 0);
            if (idx != -1) {
                item = step.getValues().get(idx);
            }
            this.update(item);
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        @Nullable
        private ObjectPath getSelectedValue() {
            return this.getList().getSelectedValue();
        }

        private boolean isInControlZone(int index2, Point pt) {
            ObjectPath val = this.getList().getModel().getElementAt(index2);
            List<ObjectPath> items = this.getStep().getPathItems();
            if (items.size() < 2 && items.contains(val)) {
                return false;
            }
            Rectangle bounds = this.getList().getCellBounds(index2, index2);
            return bounds.contains(pt) && pt.x > bounds.x + bounds.width - 30;
        }

        private void toggleItem(@Nullable ObjectPath item) {
            if (item == null) {
                return;
            }
            SearchPathStep step = this.getStep();
            List<ObjectPath> path = step.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1 && path.size() < 2) {
                return;
            }
            if (idx != -1) {
                step.removeFromPath(item);
                item = idx < path.size() ? path.get(idx) : path.get(path.size() - 1);
            } else {
                List<ObjectPath> values2 = step.getValues();
                idx = values2.indexOf(item);
                step.moveInPath(item, path.size());
                values2 = step.getValues();
                item = idx + 1 < values2.size() ? values2.get(idx + 1) : values2.get(values2.size() - 1);
            }
            this.update(item);
        }

        private void moveItem(@Nullable ObjectPath item, boolean up) {
            if (item == null) {
                return;
            }
            SearchPathStep step = this.getStep();
            List<ObjectPath> path = step.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1) {
                if (!up && idx + 1 == path.size() || up && idx == 0) {
                    if (path.size() < 2) {
                        return;
                    }
                    step.removeFromPath(item);
                } else {
                    step.moveInPath(item, idx + (up ? -1 : 2));
                }
            } else {
                step.moveInPath(item, up ? path.size() : 0);
            }
            this.update(item);
        }

        public SearchPathStep getStep() {
            return (SearchPathStep)super.getStep();
        }

        private void updateAdvertisement(Point pt) {
            int idx = this.getList().locationToIndex(pt);
            this.updateAdvertisement(idx < this.getStep().getPathItems().size(), idx != -1 && this.isInControlZone(idx, pt));
        }

        private void updateAdvertisement(boolean inPath, boolean ctrl) {
            if (!ctrl) {
                this.setAdText(inPath ? this.IN_PATH_AD : OUT_PATH_AD);
            } else {
                this.setAdText(inPath ? IN_PATH_CTRL_AD : OUT_PATH_CTRL_AD);
            }
        }

        public void cancel(InputEvent e) {
            if (e instanceof MouseEvent) {
                this.setOk(true);
            }
            super.cancel(e);
        }

        public void setOk(boolean ok) {
            this.myOk = ok;
            super.setOk(ok);
        }

        protected boolean isActionClick(MouseEvent e) {
            return false;
        }

        private void update(ObjectPath item) {
            this.getListModel().updateOriginalList();
            if (item != null) {
                this.getList().setSelectedValue(item, true);
            }
            this.getList().validate();
            this.getList().repaint();
            this.myButtonsPanel.setVisible(this.getStep().changed());
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new ElementWithControlRenderer<ObjectPath>((ListPopupImpl)this){
                {
                    super(popup);
                    Font font = this.mySeparatorComponent.getFont();
                    this.mySeparatorComponent.setFont(font.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
                    this.myNextStepLabel.setPreferredSize(new Dimension(30, 20));
                }

                protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value, boolean isSelected) {
                    super.customizeComponent(list, (Object)value, isSelected);
                    this.myNextStepLabel.setVisible(isSelected);
                    SearchPathStep step = this.getStep();
                    if (isSelected) {
                        boolean ctrl = this.isControl(list, value);
                        Icon add = ctrl ? DatabaseIcons.Add_hover : DatabaseIcons.Add;
                        Icon del = ctrl ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove;
                        List<ObjectPath> path = step.getPathItems();
                        if (path.size() < 2) {
                            del = null;
                        }
                        Icon icon = path.contains(value) ? del : add;
                        this.highlightZones(list, value);
                        this.myNextStepLabel.setIcon(icon);
                    }
                }

                @Override
                protected boolean isInControlZone(int idx, Point pt) {
                    return this.isInControlZone(idx, pt);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup", "<init>"));
        }
    }

    private static class SimpleListPopup
    extends ListPopupImpl {
        private final ObjectPath myParentValue;

        SimpleListPopup(@Nullable WizardPopup parent2, @NotNull ListPopupStep<ObjectPath> step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                SimpleListPopup.$$$reportNull$$$0(0);
            }
            super(parent2, step, (Object)parentValue, 15);
            this.myParentValue = parentValue;
            final ListPopupImpl popup = (ListPopupImpl)ObjectUtils.tryCast((Object)parent2, ListPopupImpl.class);
            if (popup != null) {
                this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (!Comparing.equal(popup.getList().getSelectedValue(), (Object)myParentValue)) {
                            popup.getList().setSelectedValue(myParentValue, false);
                        }
                    }
                });
            }
        }

        protected WizardPopup createPopup(WizardPopup parent2, PopupStep step, Object parentValue) {
            return step instanceof ListPopupStep ? ChooseSchemaAction.createPopupForStep(parent2, (ListPopupStep<ObjectPath>)((ListPopupStep)step), (ObjectPath)ObjectUtils.tryCast((Object)parentValue, ObjectPath.class)) : super.createPopup(parent2, step, parentValue);
        }

        @NotNull
        protected Point getMousePos() {
            Point pt = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(pt, this.getList());
            Point point = pt;
            if (point == null) {
                SimpleListPopup.$$$reportNull$$$0(1);
            }
            return point;
        }

        protected int trimWidth(int width) {
            FontMetrics fm = this.getList().getFontMetrics(UIUtil.getListFont());
            return Math.min(fm.stringWidth("Long enough schema name123"), width);
        }

        @NotNull
        public ObjectPath getParentValue() {
            ObjectPath objectPath = this.myParentValue;
            if (objectPath == null) {
                SimpleListPopup.$$$reportNull$$$0(2);
            }
            return objectPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMousePos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DbScStep
    extends BaseStep<ObjectPath>
    implements ListPopupStep<ObjectPath> {
        private final JdbcConsole myConsole;
        private final List<ObjectPath> myPaths;
        private final ObjectPath myCurrent;

        DbScStep(@NotNull JdbcConsole console) {
            ObjectPath dbPath;
            if (console == null) {
                DbScStep.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
            LocalDataSource dataSource = console.getDataSource();
            ObjectPath cur = SearchPath.getCurrent((SearchPath)console.getSearchPath());
            this.myPaths = ContainerUtil.newArrayList();
            if (cur != null && (dbPath = cur.findParent(ObjectKind.DATABASE, false)) != null) {
                this.myPaths.add(dbPath);
            }
            this.myCurrent = (ObjectPath)ContainerUtil.getFirstItem(this.myPaths);
            for (DasObject namespace : (JBTreeTraverser)ChooseSchemaAction.traverser(dataSource.getModel()).expand(Conditions.alwaysFalse())) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || path.kind != ObjectKind.DATABASE) continue;
                this.myPaths.add(path);
            }
            ContainerUtil.removeDuplicates(this.myPaths);
            this.myPaths.sort(PATH_COMPARATOR);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @NotNull
        public String getTextFor(ObjectPath value) {
            String string = ChooseSchemaAction.getText(value);
            if (string == null) {
                DbScStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                DbScStep.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (finalChoice || selectedValue == null) {
                if (selectedValue != null) {
                    ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
                }
                return FINAL_CHOICE;
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(this.myConsole);
            ArrayList paths = ContainerUtil.newArrayList((Iterable)this.getSchemas(selectedValue).transform(ObjectPaths::of));
            ArrayList searchPath = ContainerUtil.newArrayList((Iterable)SearchPath.getElements((SearchPath)this.myConsole.getSearchPath()));
            Iterator it = searchPath.iterator();
            while (it.hasNext()) {
                ObjectPath p2 = (ObjectPath)it.next();
                if (p2.kind == ObjectKind.SCHEMA && p2.parent != null && p2.parent.name.equals(selectedValue.getName())) continue;
                it.remove();
            }
            if (dialect.supportsSearchPath()) {
                return new SearchPathStep(this.myConsole, paths, searchPath);
            }
            ObjectPath cur = (ObjectPath)ContainerUtil.getFirstItem((List)searchPath);
            if (cur != null && !paths.contains(cur)) {
                cur = null;
            }
            return new SingleScOrDbStep(this.myConsole, paths, cur);
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return !this.getSchemas(selectedValue).isEmpty();
        }

        @NotNull
        public JBIterable<? extends DasObject> getSchemas(@Nullable ObjectPath selectedValue) {
            if (selectedValue == null || this.myConsole.getDataSource().getSchemaControl() == DatabaseDriver.SchemaControl.FORBID) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DbScStep.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)ChooseSchemaAction.traverser(this.myConsole.getDataSource().getModel()).expandAndSkip(x -> x.getKind() == ObjectKind.DATABASE && x.getName().equals(selectedValue.getName()))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).traverse();
            if (jBIterable == null) {
                DbScStep.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value) {
            return null;
        }

        public int getDefaultOptionIndex() {
            return this.myPaths.indexOf(this.myCurrent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemas";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SearchPathStep
    extends BaseStep<ObjectPath>
    implements ListPopupStep<ObjectPath> {
        private static final ListSeparator mySearchPathSeparator = new ListSeparator("Search Path");
        private static final ListSeparator myAvailSeparator = new ListSeparator("Select or Add to Search Path");
        private final JdbcConsole myConsole;
        private final List<ObjectPath> mySearchPath;
        private final List<ObjectPath> myInitialPath;
        private final List<ObjectPath> myRest;
        private final List<ObjectPath> myPaths;
        private boolean myPathsDirty;

        SearchPathStep(@NotNull JdbcConsole console) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(0);
            }
            this.myPaths = ContainerUtil.newArrayList();
            this.myPathsDirty = true;
            this.myConsole = console;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            LocalDataSource dataSource = console.getDataSource();
            this.mySearchPath = ContainerUtil.newArrayList();
            for (ObjectPath path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (!ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                this.mySearchPath.add(path);
            }
            this.myRest = ContainerUtil.newArrayList();
            for (DasObject namespace : (JBTreeTraverser)ChooseSchemaAction.traverser(dataSource.getModel()).expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || !ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                this.myRest.add(path);
            }
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = ContainerUtil.newArrayList(this.mySearchPath);
        }

        SearchPathStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @NotNull List<ObjectPath> searchPath) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SearchPathStep.$$$reportNull$$$0(2);
            }
            if (searchPath == null) {
                SearchPathStep.$$$reportNull$$$0(3);
            }
            this.myPaths = ContainerUtil.newArrayList();
            this.myPathsDirty = true;
            this.myConsole = console;
            this.mySearchPath = ContainerUtil.newArrayList(searchPath);
            this.myRest = ContainerUtil.newArrayList(paths);
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = ContainerUtil.newArrayList(this.mySearchPath);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(ObjectPath value) {
            String string = ChooseSchemaAction.getText(value);
            if (string == null) {
                SearchPathStep.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            if (this.myPathsDirty) {
                ContainerUtil.sort(this.myRest, (Comparator)PATH_COMPARATOR);
                this.myPaths.clear();
                this.myPaths.addAll(this.mySearchPath);
                this.myPaths.addAll(this.myRest);
            }
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(5);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            return null;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value) {
            if (Comparing.equal((Object)value, (Object)ContainerUtil.getFirstItem(this.mySearchPath))) {
                return mySearchPathSeparator;
            }
            if (Comparing.equal((Object)value, (Object)ContainerUtil.getFirstItem(this.myRest))) {
                return myAvailSeparator;
            }
            return null;
        }

        public int getDefaultOptionIndex() {
            return 0;
        }

        @NotNull
        public JdbcConsole getConsole() {
            JdbcConsole jdbcConsole = this.myConsole;
            if (jdbcConsole == null) {
                SearchPathStep.$$$reportNull$$$0(6);
            }
            return jdbcConsole;
        }

        @NotNull
        public List<ObjectPath> getPathItems() {
            List<ObjectPath> list = this.mySearchPath;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(7);
            }
            return list;
        }

        public boolean changed() {
            return !this.mySearchPath.equals(this.myInitialPath);
        }

        public void removeFromPath(ObjectPath item) {
            if (!this.mySearchPath.remove(item)) {
                return;
            }
            this.myRest.add(item);
            this.myPathsDirty = true;
        }

        public void moveInPath(ObjectPath item, int idx) {
            int prevIdx = this.mySearchPath.indexOf(item);
            if (prevIdx == idx) {
                return;
            }
            if (prevIdx != -1) {
                this.mySearchPath.remove(prevIdx);
            } else {
                this.myRest.remove(item);
            }
            if (prevIdx != -1 && idx > prevIdx) {
                --idx;
            }
            this.mySearchPath.add(idx, item);
            this.myPathsDirty = true;
        }

        public void reset() {
            HashSet values2 = ContainerUtil.newHashSet(this.getValues());
            this.mySearchPath.clear();
            this.mySearchPath.addAll(this.myInitialPath);
            values2.removeAll(this.mySearchPath);
            this.myRest.clear();
            this.myRest.addAll(values2);
            this.myPathsDirty = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchPath";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsole";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SingleScOrDbStep
    extends BaseStep<ObjectPath>
    implements ListPopupStep<ObjectPath> {
        private final JdbcConsole myConsole;
        private final List<ObjectPath> myPaths;
        private final ObjectPath myCurrent;

        SingleScOrDbStep(@NotNull JdbcConsole console) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            ObjectKind kind = dialect.getSearchPathObjectKind();
            LocalDataSource dataSource = console.getDataSource();
            boolean sensitive = console.getDataSource().getCaseModes().quoted.sensitive;
            THashMap paths = ContainerUtil.newTroveMap(sensitive ? ContainerUtil.canonicalStrategy() : ObjectPaths.INSENSITIVE_STRATEGY);
            for (DasObject namespace : (JBTreeTraverser)ChooseSchemaAction.traverser(dataSource.getModel()).expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || kind != null && !ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                paths.put(path, path);
            }
            ObjectPath cur = null;
            for (ObjectPath path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (kind != null && !ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                path = paths.getOrDefault(path, path);
                if (cur == null) {
                    cur = path;
                }
                paths.put(path, path);
            }
            this.myCurrent = cur;
            this.myPaths = ContainerUtil.newArrayList(paths.keySet());
            this.myPaths.sort(PATH_COMPARATOR);
        }

        SingleScOrDbStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @Nullable ObjectPath current) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SingleScOrDbStep.$$$reportNull$$$0(2);
            }
            this.myConsole = console;
            this.myPaths = paths;
            this.myCurrent = current;
            this.myPaths.sort(PATH_COMPARATOR);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(ObjectPath value) {
            String string = ChooseSchemaAction.getText(value);
            if (string == null) {
                SingleScOrDbStep.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                SingleScOrDbStep.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (selectedValue != null) {
                ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value) {
            return null;
        }

        public int getDefaultOptionIndex() {
            return this.myPaths.indexOf(this.myCurrent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SingleScOrDbStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SingleScOrDbStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

