/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"anyCurrentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/script/generator/ScriptingTask;", "getAnyCurrentDatabase", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicDatabase;", "anyCurrentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "getAnyCurrentSchema", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicSchema;", "anyModel", "Lcom/intellij/database/model/basic/BasicModel;", "getAnyModel", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicModel;", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/Dbms;", "intellij.database.impl"})
public final class ScriptingTaskKt {
    @Nullable
    public static final BasicModel getAnyModel(@NotNull ScriptingTask $receiver) {
        BasicModel basicModel;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ScriptingTask scriptingTask = $receiver;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            basicModel = ((ScriptingSingleModelTask)$receiver).getModel();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            basicModel = ((ScriptingNativeDefinitionTask)$receiver).getModel();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            basicModel = ((ScriptingAlterTask)$receiver).getSourceModel();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            basicModel = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return basicModel;
    }

    @NotNull
    public static final Dbms getDbms(@NotNull ScriptingTask $receiver) {
        Dbms dbms;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ScriptingTask scriptingTask = $receiver;
        if (scriptingTask instanceof ScriptingInternalTask) {
            dbms = ((ScriptingInternalTask)$receiver).getDbms();
        } else {
            BasicModel basicModel = ScriptingTaskKt.getAnyModel($receiver);
            if (basicModel == null) {
                Intrinsics.throwNpe();
            }
            Dbms dbms2 = basicModel.getDbms();
            dbms = dbms2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms2, (String)"anyModel!!.dbms");
        }
        return dbms;
    }

    @Nullable
    public static final BasicDatabase getAnyCurrentDatabase(@NotNull ScriptingTask $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        BasicDatabase basicDatabase = $receiver.getCurrentDatabase();
        if (basicDatabase == null) {
            Object object = ScriptingTaskKt.getAnyModel($receiver);
            basicDatabase = object != null && (object = object.getRoot()) != null ? object.getCurrentDatabase() : null;
        }
        return basicDatabase;
    }

    @Nullable
    public static final BasicSchema getAnyCurrentSchema(@NotNull ScriptingTask $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        BasicSchema basicSchema = $receiver.getCurrentSchema();
        if (basicSchema == null) {
            BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase($receiver);
            basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
        }
        return basicSchema;
    }
}

