/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor {
    public static void updatePresentation(PresentationData presentation, DasObject element2, Project project) {
        String comment;
        presentation.clear();
        presentation.setIcon(element2 instanceof DbDataSource ? ((DbDataSource)element2).getIcon() : DbPresentation.getIcon(element2));
        String nodeText = DbPresentation.getPresentableName(element2, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(presentation, element2);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, style);
        Dbms dbms = element2 instanceof BasicElement ? DbImplUtil.getDbms((BasicElement)element2) : Dbms.UNKNOWN;
        DescriptionService service = ModelFacade.forDbms(dbms).getDescriptionService();
        service.updatePresentation(project, element2, presentation);
        if (element2 instanceof DbDataSource || element2 instanceof DasNamespace) {
            DbNodeDescriptor.appendCollapsedNamespaces(presentation, element2, project);
        }
        if ((comment = element2.getComment()) != null && comment.length() > 0) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXml((String)StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true)) + "</pre>");
        }
    }

    private static void appendCollapsedNamespaces(PresentationData presentation, DasObject element2, Project project) {
        String textExt;
        DasObject root2;
        DatabaseViewOptions options = DatabaseView.getDatabaseView(project).getViewOptions();
        DasObject dasObject = options.SHOW_INTERMEDIATE ? element2 : (element2 instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element2, options) : (root2 = element2 instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(element2, options) : element2));
        if (root2 != element2 && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText(" (" + textExt + ")", DbNodeDescriptor.getGrayAttrs());
        }
    }

    private static SimpleTextAttributes handleErrors(PresentationData presentation, Object element2) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        int connectionCount = -1;
        if (element2 instanceof DbDataSource && ((DbDataSource)element2).getDelegate() instanceof LocalDataSource) {
            Project project;
            LocalDataSource dataSource = (LocalDataSource)((DbDataSource)element2).getDelegate();
            hasErrors = !DbImplUtil.canConnectTo(dataSource);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(element2, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connectionCount = DbImplUtil.isConnected(project = ((DbDataSource)element2).getProject(), dataSource) ? DbImplUtil.getActiveConnectionCount(dataSource) : -1;
        } else if (element2 instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element2).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element2 instanceof DasObject && DbPresentation.isUnnamed((DasObject)element2) ? DbNodeDescriptor.getGrayAttrs() : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element2 instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)element2)) {
            DbNodeDescriptor.addTooltip(presentation, false, "Database driver files not found, open Properties to download");
        }
        if (connectionCount >= 0) {
            if (connectionCount > 0) {
                style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            DbNodeDescriptor.addTooltip(presentation, false, connectionCount + " " + StringUtil.pluralize((String)"connection", (int)connectionCount));
        }
        return style;
    }

    private static void addTooltip(PresentationData presentation, boolean before2, String tooltip) {
        String result2;
        String cur = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur)) {
            result2 = tooltip;
        } else {
            String separator = "<p><p>";
            result2 = before2 ? tooltip + separator + cur : cur + separator + tooltip;
        }
        presentation.setTooltip(result2.startsWith("<html>") ? result2 : "<html>" + result2);
    }

    public static SimpleTextAttributes getGrayAttrs() {
        return UIUtil.isUnderDarcula() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    @Nullable
    public static Object getData(@NonNls @NotNull String dataId, Project project, Object node) {
        if (dataId == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (!(node instanceof DasObject)) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && node instanceof Navigatable) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node instanceof PsiElement) {
                return node;
            }
            return null;
        }
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)node);
        if (dataSource == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (node instanceof Navigatable) {
                return node;
            }
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/view/DbNodeDescriptor", "getData"));
    }
}

