/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.cassandra.CassandraTokens;

class CassandraAnnotatingVisitor
extends PsiElementVisitor {
    public static final TextAttributesKey CASS_UUID = TextAttributesKey.createTextAttributesKey((String)"CASS_UUID", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    private final AnnotationHolder myHolder;

    CassandraAnnotatingVisitor(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    public void visitElement(PsiElement element2) {
        IElementType type;
        super.visitElement(element2);
        ASTNode node = element2.getNode();
        if (node != null && ((type = node.getElementType()) == CassandraTokens.CASS_UUID_TOKEN || type == CassandraTokens.CASS_DURATION_TOKEN)) {
            this.myHolder.createInfoAnnotation(element2, null).setTextAttributes(CASS_UUID);
        }
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept((PsiElementVisitor)this);
        }
    }
}

