/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.cassandra.CassandraTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CassandraGeneratedParserUtil
extends SqlGeneratedParserUtil {
    private static final Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
    private static final Pattern durationPattern = Pattern.compile("(\\d+(y|mo|w|d|h|m|s|ms|us|\u00b5s|ns))+");
    private static final Pattern iso8601Pattern = Pattern.compile("P(\\d+Y)?(\\d+M)?(\\d+D)?T(\\d+H)?(\\d+M)?(\\d+S)?");
    private static final Pattern iso8601Weeks = Pattern.compile("P\\d+W");

    public static TokenSet create_token_set_(IElementType ... tokenTypes_) {
        TokenSet set = SqlGeneratedParserUtil.create_token_set_(tokenTypes_);
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE})});
        }
        return set;
    }

    public static boolean parseUUIDLiteral(PsiBuilder builder, int level) {
        IElementType type = builder.getTokenType();
        if (!CassandraGeneratedParserUtil.isUUIDType(type)) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        StringBuilder sb = new StringBuilder();
        int uuidLength = 36;
        sb.append(builder.getTokenText());
        while (sb.length() < uuidLength) {
            if (!CassandraGeneratedParserUtil.isUUIDType(builder.rawLookup(1))) {
                return false;
            }
            builder.advanceLexer();
            sb.append(builder.getTokenText());
        }
        if (sb.length() == uuidLength && uuidPattern.matcher(sb.toString()).matches()) {
            builder.advanceLexer();
            mark2.collapse((IElementType)CassandraTokens.CASS_UUID_TOKEN);
            return true;
        }
        return false;
    }

    private static boolean isUUIDType(IElementType type) {
        return type == SqlTokens.SQL_INTEGER_TOKEN || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_OP_MINUS || type == SqlTokens.SQL_FLOAT_TOKEN;
    }

    public static boolean parseDurationLiteral(PsiBuilder builder, int level) {
        return CassandraGeneratedParserUtil.parseCassandraDuration(builder) || CassandraGeneratedParserUtil.parseIso8601(builder) || CassandraGeneratedParserUtil.parseIso8601Alt(builder);
    }

    private static boolean parseIso8601Alt(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text2 = builder.getTokenText();
        if (text2 == null) {
            return false;
        }
        if (!CassandraGeneratedParserUtil.isBeginningOfIso8601Alt(text2)) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        if (!CassandraGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_OP_MINUS)) {
            return false;
        }
        if (!CassandraGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_OP_MINUS)) {
            return false;
        }
        if (builder.rawLookup(1) != SqlTokens.SQL_IDENT) {
            return false;
        }
        builder.advanceLexer();
        text2 = builder.getTokenText();
        if (text2 == null || text2.length() != 3 || text2.charAt(0) != 'T' || !CassandraGeneratedParserUtil.isInteger(text2, 1)) {
            return false;
        }
        if (!CassandraGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_COLON)) {
            return false;
        }
        if (!CassandraGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_COLON)) {
            return false;
        }
        builder.advanceLexer();
        mark2.collapse((IElementType)CassandraTokens.CASS_DURATION_TOKEN);
        return true;
    }

    private static boolean isTwoDigitsPart(PsiBuilder builder, SqlTokenType delimiterToken) {
        if (builder.rawLookup(1) != delimiterToken) {
            return false;
        }
        if (builder.rawLookup(2) != SqlTokens.SQL_INTEGER_TOKEN) {
            return false;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        String text2 = builder.getTokenText();
        if (text2 == null) {
            return false;
        }
        return text2.length() == 2;
    }

    private static boolean isInteger(String text2, int offset) {
        for (int i2 = offset; i2 < text2.length(); ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isBeginningOfIso8601Alt(@NotNull String text2) {
        if (text2 == null) {
            CassandraGeneratedParserUtil.$$$reportNull$$$0(0);
        }
        if (text2.length() != 5) {
            return false;
        }
        if (text2.charAt(0) != 'P') {
            return false;
        }
        return CassandraGeneratedParserUtil.isInteger(text2, 1);
    }

    private static boolean parseIso8601(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text2 = builder.getTokenText();
        if (text2 == null || text2.charAt(0) != 'P') {
            return false;
        }
        if (!iso8601Pattern.matcher(text2).matches() && !iso8601Weeks.matcher(text2).matches()) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        builder.advanceLexer();
        mark2.collapse((IElementType)CassandraTokens.CASS_DURATION_TOKEN);
        return true;
    }

    private static boolean parseCassandraDuration(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_INTEGER_TOKEN) {
            return false;
        }
        if (builder.rawLookup(1) != SqlTokens.SQL_IDENT) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        String number = builder.getTokenText();
        builder.advanceLexer();
        String durationLiteral = number + builder.getTokenText();
        if (durationPattern.matcher(durationLiteral).matches()) {
            builder.advanceLexer();
            mark2.collapse((IElementType)CassandraTokens.CASS_DURATION_TOKEN);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/dialects/cassandra/CassandraGeneratedParserUtil", "isBeginningOfIso8601Alt"));
    }
}

