/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TextWithRanges;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlPreFormatProcessor;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.script.SqlScriptModel;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.TextRangeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPsiFacadeImpl
extends SqlPsiFacade {
    private final Project myProject;

    public SqlPsiFacadeImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public SqlLanguageDialect getDefaultDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(this.myProject, null);
        if (sqlLanguageDialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialect;
    }

    public void setDialectMapping(@NotNull VirtualFile file, @NotNull SqlLanguageDialect dialect) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        SqlDialectMappings.getInstance(this.myProject).setMapping(file, dialect);
    }

    @NotNull
    public SqlLanguageDialect getDialectMapping(@NotNull VirtualFile file) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(this.myProject).getMapping(file);
        if (sqlLanguageDialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlScriptModel createScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        SqlScriptModel sqlScriptModel = new SqlScriptModel(file);
        if (sqlScriptModel == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        return sqlScriptModel;
    }

    @NotNull
    public SqlFile createROFile(@NotNull SqlLanguageDialect dialect, @NotNull CharSequence text2, @Nullable Language hostLanguage) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(8);
        }
        SqlFile sqlFile = SqlPsiElementFactory.createROFileFromText(text2, dialect, this.myProject, hostLanguage);
        if (sqlFile == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(9);
        }
        return sqlFile;
    }

    @NotNull
    public JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement element2, boolean strict) {
        JBIterable<DbElement> jBIterable = SqlDocumentationProvider.findRelatedDbElements(element2, strict);
        if (jBIterable == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    public CharSequence format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull TextWithRanges textWithRanges) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        if (textWithRanges == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createDocumentFormattingModel(project, dialect, sqlSettings.getRootSettings(), textWithRanges);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
        CharSequence charSequence = model.getDocumentModel().getDocument().getImmutableCharSequence();
        if (charSequence == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        return charSequence;
    }

    public void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        if (document == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createModel(project, dialect, sqlSettings.getRootSettings(), document.getText(), document);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
    }

    private static void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CommonCodeStyleSettings sqlSettings, @NotNull FormattingModel model) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(19);
        }
        if (sqlSettings == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        if (model == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        CodeStyleSettings settings = sqlSettings.getRootSettings();
        SqlRootBlock rootBlock = (SqlRootBlock)model.getRootBlock();
        TextRange range = new SqlPreFormatProcessor().process(rootBlock.getNode(), TextRange.create((int)0, (int)model.getDocumentModel().getTextLength()));
        Document document = model.getDocumentModel().getDocument();
        FormatTextRanges ranges = new FormatTextRanges();
        Iterable toProcess = TextRangeUtil.excludeRanges((TextRange)range, ((DocumentEx)document).getGuardedBlocks().stream().map(marker -> TextRange.create((int)marker.getStartOffset(), (int)marker.getEndOffset())).collect(Collectors.toList()));
        for (TextRange tr : toProcess) {
            ranges.add(tr, true);
        }
        model = SqlFormattingModelBuilder.createModel(project, dialect, settings, document.getCharsSequence(), document);
        FormatterEx.getInstance().format(model, settings, sqlSettings.getIndentOptions(), ranges);
    }

    @NotNull
    public PsiCodeFragment createTableReferenceFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable DbElement schemaElement, @NotNull String text2) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, "dummy.sql", text2, true);
        codeFragment.setContext((PsiElement)schemaElement);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createEvaluableExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource dataSourceElement, @Nullable SearchPath searchPath, @NotNull String text2) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION, "dummy.sql", text2, true);
        fragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, dataSourceElement);
        fragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = fragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public SqlCodeFragment createTypeElementFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable SearchPath searchPath, @NotNull String text2) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, "dummy.sql", text2, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable SearchPath searchPath, @NotNull String text2) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text2, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable SearchPath searchPath, @NotNull String text2, @NotNull String contextQuery) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(34);
        }
        if (text2 == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(35);
        }
        if (contextQuery == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text2, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlFile file = (SqlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.sql", dialect, (CharSequence)contextQuery);
        file.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)context);
        file.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)searchPath);
        final Ref ref = Ref.create();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element2) {
                if (element2 instanceof SqlQueryExpression) {
                    ref.set((Object)((SqlQueryExpression)element2));
                } else {
                    super.visitElement(element2);
                }
            }
        });
        if (!ref.isNull()) {
            codeFragment.setContext((PsiElement)ref.get());
        }
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public SqlExecutionFlowAnalyzer<PsiElement> getExecutionFlowAnalyzer() {
        SqlExecutionFlowAnalyzer sqlExecutionFlowAnalyzer = (SqlExecutionFlowAnalyzer)ServiceManager.getService((Project)this.myProject, SqlExecutionFlowAnalyzer.class);
        if (sqlExecutionFlowAnalyzer == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        return sqlExecutionFlowAnalyzer;
    }

    public Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> buildModel(DasModel model, List<SqlFile> files, final PairProcessor<DasObject, DasObject> newHandler) {
        if (files.isEmpty()) {
            return ContainerUtil.newHashMap();
        }
        SqlModelBuilder builder = new SqlModelBuilder(this.myProject, (BasicModModel)model, Collections.emptyMap()){

            @Override
            protected void buildObject(@NotNull BasicModElement target, @NotNull DasObject obj) {
                if (target == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (obj == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (newHandler != null && !newHandler.process((Object)target, (Object)obj)) {
                    return;
                }
                super.buildObject(target, obj);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "obj";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/SqlPsiFacadeImpl$2";
                objectArray[2] = "buildObject";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        builder.begin(true);
        builder.introspect(files, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlPsiFacadeImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithRanges";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlSettings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDialect";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlPsiFacadeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createScriptModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createROFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableReferenceFragment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluableExpressionFragment";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElementFragment";
                break;
            }
            case 33: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFragment";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionFlowAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDialectMapping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDialectMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createROFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTableReferenceFragment";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluableExpressionFragment";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElementFragment";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

