/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.builder.GraphDataModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CachedGraphDataModel<N, E>
extends GraphDataModel<N, E> {
    private boolean myDirty = true;
    protected final Set<N> myNodes = new HashSet<N>();
    protected final Map<E, EdgeInfo<N>> myEdges = new HashMap<E, EdgeInfo<N>>();

    @Override
    @NotNull
    public Collection<N> getNodes() {
        this.checkUpdate();
        Set<N> set = this.myNodes;
        if (set == null) {
            CachedGraphDataModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<E> getEdges() {
        this.checkUpdate();
        Set<E> set = this.myEdges.keySet();
        if (set == null) {
            CachedGraphDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public N getSourceNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.source;
    }

    @Override
    public N getTargetNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.target;
    }

    @Override
    public E createEdge(@NotNull N from, @NotNull N to) {
        if (from == null) {
            CachedGraphDataModel.$$$reportNull$$$0(2);
        }
        if (to == null) {
            CachedGraphDataModel.$$$reportNull$$$0(3);
        }
        return null;
    }

    public void dispose() {
    }

    protected void createNode(N node) {
        this.myNodes.add(node);
    }

    protected void createEdge(E edge, N source, N target) {
        this.myEdges.put(edge, new EdgeInfo<N>(source, target));
    }

    protected final synchronized void checkUpdate() {
        if (this.myDirty) {
            this.buildGraph();
            this.myDirty = false;
        }
    }

    protected abstract void buildGraph();

    protected void clear() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public final synchronized void setDirty() {
        this.myDirty = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/CachedGraphDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/CachedGraphDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EdgeInfo<N> {
        final N source;
        final N target;

        EdgeInfo(N source, N target) {
            this.source = source;
            this.target = target;
        }
    }
}

