/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.psi.SqlLanguage;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeStyleSettings
extends CustomCodeStyleSettings
implements SqlCodeStyleConst {
    public int myVersion = 2;
    public boolean DISABLE_FORMATTING = false;
    @SqlCodeStyleConst.AliasCase
    public int ALIAS_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int KEYWORD_CASE;
    @SqlCodeStyleConst.IdentifierCaseExt
    public int TYPE_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int IDENTIFIER_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int QUOTED_IDENTIFIER_CASE;
    public int QUOTE_IDENTIFIER;
    public int QUERY_SECTION_1ST_WORD_ALIGN;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int QUERY_EL_LINE;
    @SqlCodeStyleConst.CommaMagicValues
    public int QUERY_EL_COMMA;
    public int QUERY_IN_ONE_STRING;
    public boolean QUERY_TRUE_INDENT;
    public boolean QUERY_ALIGN_ELEMENTS;
    public boolean QUERY_ALIGN_LINE_COMMENTS;
    @SqlCodeStyleConst.OpeningMagicValues
    public int SUBQUERY_OPENING;
    @SqlCodeStyleConst.ContentMagicValues
    public int SUBQUERY_CONTENT;
    @SqlCodeStyleConst.ClosingMagicValues
    public int SUBQUERY_CLOSING;
    public boolean SUBQUERY_PAR_SPACE_INSIDE;
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int INSERT_INTO_NL;
    @SqlCodeStyleConst.OpeningMagicValues
    public int INSERT_OPENING;
    @SqlCodeStyleConst.ContentMagicValues
    public int INSERT_CONTENT;
    @SqlCodeStyleConst.ClosingMagicValues
    public int INSERT_CLOSING;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int INSERT_TABLE_EL_LINE;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int INSERT_VALUES_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int INSERT_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int INSERT_EL_COMMA;
    public boolean INSERT_SPACE_WITHIN_PARENTHESES;
    public boolean INSERT_COLLAPSE_MULTI_ROW_VALUES;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int SET_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int SET_EL_WRAP;
    @SqlCodeStyleConst.ContentMagicValues
    public int SET_EL_COMMA;
    public boolean SET_ALIGN_EQUAL_SIGN;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int WITH_EL_LINE;
    @SqlCodeStyleConst.Wrap2MagicValues
    public int WITH_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int WITH_EL_COMMA;
    public boolean WITH_ALIGN_AS;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int SELECT_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int SELECT_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int SELECT_EL_COMMA;
    public boolean SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
    public int SELECT_KEEP_N_ITEMS_IN_LINE;
    public int SELECT_USE_AS_WORD;
    public boolean SELECT_ALIGN_AS;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int FROM_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int FROM_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int FROM_EL_COMMA;
    public boolean FROM_WRAP_JOIN_1;
    public boolean FROM_WRAP_JOIN_2;
    public boolean FROM_WRAP_ON;
    public boolean FROM_ALIGN_JOIN_TABLES;
    public boolean FROM_ALIGN_ALIASES;
    public boolean FROM_INDENT_JOIN;
    @SqlCodeStyleConst.FromOnlyJoinIndentValues
    public int FROM_ONLY_JOIN_INDENT;
    @SqlCodeStyleConst.FromPlaceOnValues
    public int FROM_PLACE_ON;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int WHERE_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int WHERE_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int WHERE_EL_BOUND;
    @SqlCodeStyleConst.ElementsLineMagicValues
    public int ORDER_EL_LINE;
    @SqlCodeStyleConst.WrapMagicValues
    public int ORDER_EL_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int ORDER_EL_COMMA;
    public boolean ORDER_ALIGN_ASC_DESC;
    @SqlCodeStyleConst.OpeningMagicValues
    public int TABLE_OPENING;
    @SqlCodeStyleConst.ContentMagicValues
    public int TABLE_CONTENT;
    @SqlCodeStyleConst.ClosingMagicValues
    public int TABLE_CLOSING;
    public boolean TABLE_TYPES_ALIGN;
    public boolean TABLE_DEFAULTS_ALIGN;
    public boolean TABLE_NULLABILITIES_ALIGN;
    public boolean TABLE_COLLAPSE;
    @SqlCodeStyleConst.AddRemoveAsIsMagicValues
    public int TABLE_ALTER_INSTRUCTION_WRAP;
    public boolean TABLE_ALTER_INSTRUCTION_ALIGN;
    public boolean CONSTRAINT_WRAP_1;
    public boolean CONSTRAINT_WRAP_2;
    public boolean CONSTRAINT_WRAP_3;
    public boolean CONSTRAINT_WRAP_4;
    public boolean POST_OPT_WRAP_1;
    public boolean POST_OPT_WRAP_2;
    public boolean POST_OPT_INDENT;
    public boolean POST_OPT_ALIGN;
    public boolean CREATE_SCHEMA_CONTENT_INDENT;
    public int CREATE_SCHEMA_BLANK_LINES_MIN;
    public int CREATE_SCHEMA_BLANK_LINES_MAX;
    public boolean VIEW_WRAP_AS;
    public boolean VIEW_WRAP_QUERY;
    public boolean VIEW_INDENT_QUERY;
    @SqlCodeStyleConst.OpeningMagicValues
    public int ROUTINE_ARG_OPENING;
    @SqlCodeStyleConst.ContentMagicValues
    public int ROUTINE_ARG_CONTENT;
    @SqlCodeStyleConst.ClosingMagicValues
    public int ROUTINE_ARG_CLOSING;
    @SqlCodeStyleConst.WrapMagicValues
    public int ROUTINE_ARG_WRAP;
    @SqlCodeStyleConst.CommaMagicValues
    public int ROUTINE_ARG_COMMA;
    public boolean ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
    public boolean ROUTINE_ARG_ALIGN_TYPES;
    public boolean ROUTINE_AS_WRAP;
    public boolean ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
    public boolean ROUTINE_PG_L_QUOTE_WRAP_AFTER;
    public boolean ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
    public boolean ROUTINE_PG_R_QUOTE_WRAP_AFTER;
    public boolean IMP_COMMON_WRAP_EVERY_STATEMENT;
    public int IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
    public boolean IMP_DECLARE_CONTENT_WRAP;
    @SqlCodeStyleConst.WrapMagicValues
    public int IMP_DECLARE_EL_WRAP;
    public boolean IMP_DECLARE_ALIGN_TYPE;
    public boolean IMP_DECLARE_ALIGN_EQ;
    public boolean IMP_DECLARE_ALIGN_DEFAULT;
    public boolean IMP_IF_THEN_WRAP_THEN;
    public boolean IMP_IF_THEN_WRAP_ELSE;
    public boolean IMP_IF_THEN_WRAP_INNER;
    public boolean IMP_IF_THEN_INDENT_THEN_ELSE;
    public boolean IMP_IF_THEN_INDENT_END;
    public boolean IMP_IF_THEN_COLLAPSE;
    public boolean IMP_LOOP_LOOP_WRAP;
    public boolean IMP_LOOP_LOOP_INDENT;
    public boolean IMP_LOOP_END_INDENT;
    public boolean IMP_LOOP_COLLAPSE;
    public boolean CORTEGE_SPACE_BEFORE_L_PAREN;
    public boolean CORTEGE_COMMA_1ST;
    public int CORTEGE_CLOSING;
    public boolean CORTEGE_SPACE_WITHIN_PARENTHESES;
    public boolean CORTEGE_SPACE_BEFORE_COMMA;
    public boolean CORTEGE_SPACE_AFTER_COMMA;
    public int EXPR_SPACE_AROUND_OPERATOR;
    public boolean EXPR_SPACE_WITHIN_PARENTHESES;
    public boolean EXPR_BINARY_OP_ALIGN;
    public boolean EXPR_CALL_SPACE_INSIDE_PARENTHESES;
    public boolean EXPR_CALL_SPACE_BEFORE_COMMA;
    public boolean EXPR_CALL_SPACE_AFTER_COMMA;
    public boolean EXPR_CASE_WHEN_WRAP;
    public boolean EXPR_CASE_WHEN_INDENT;
    public boolean EXPR_CASE_THEN_WRAP;
    public boolean EXPR_CASE_THEN_ALIGN;
    public boolean EXPR_CASE_ELSE_ALIGN_THEN;
    public int EXPR_CASE_END;
    public boolean EXPR_CASE_KEEP_NL_AFTER_THEN;
    public boolean EXPR_CASE_COLLAPSE;
    public String INDEX_NAME_TEMPLATE;
    public String PRIMARY_KEY_NAME_TEMPLATE;
    public String FOREIGN_KEY_NAME_TEMPLATE;
    @Deprecated
    public boolean SUBQUERY_L_PAR_NL_OUTSIDE;
    @Deprecated
    public boolean SUBQUERY_L_PAR_NL_INSIDE;
    @Deprecated
    public boolean SUBQUERY_R_PAR_NL_INSIDE;
    @Deprecated
    public int SUBQUERY_R_PAR_ALIGN;
    @Deprecated
    public boolean SUBQUERY_INDENT_INSIDE;
    @Deprecated
    public boolean SPACES_AROUND_OPERATORS;
    @Deprecated
    public boolean ALIGN_AS_IN_SELECT_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_CREATE_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_BLOCK_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
    @Deprecated
    public boolean ALIGN_INSIDE_BINARY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_INSIDE_QUERY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_EQ_INSIDE_SET_CLAUSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_FROM;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN_CONDITION;
    @Deprecated
    public boolean NEW_LINE_BEFORE_WHERE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_GROUP_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ORDER_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_HAVING;
    @Deprecated
    public boolean NEW_LINE_BEFORE_THEN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ELSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_OTHER_CLAUSES;
    @Deprecated
    public boolean NEW_LINE_BEFORE_COMMA;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_DML;
    @Deprecated
    public boolean NEW_LINE_AROUND_SEMICOLON;
    @Deprecated
    public boolean INDENT_JOIN;
    @Deprecated
    public boolean INDENT_JOIN_CONDITION;
    @Deprecated
    public boolean INDENT_SELECT_INTO_CLAUSE;
    @Deprecated
    public int WRAP_INSIDE_CREATE_TABLE;
    @Deprecated
    public int WRAP_INSIDE_SELECT;
    @Deprecated
    public int WRAP_INSIDE_JOIN_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_GROUP_BY;
    @Deprecated
    public int WRAP_INSIDE_WHERE;
    @Deprecated
    public int WRAP_INSIDE_ORDER_BY;
    @Deprecated
    public int WRAP_INSIDE_SET;
    @Deprecated
    public int WRAP_INSIDE_ARGUMENT_DEFINITION;
    @Deprecated
    public int WRAP_INSIDE_CALL_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT_ITEM;
    @Deprecated
    public int NEW_LINE_AFTER_SELECT_2;
    private static final Logger LOG = Logger.getInstance(SqlCodeStyleSettings.class);

    public SqlCodeStyleSettings(CodeStyleSettings container) {
        super("SqlCodeStyleSettings", container);
        this.ALIAS_CASE = SqlCodeStyleSettingsDefault.MODERN.ALIAS_CASE;
        this.KEYWORD_CASE = SqlCodeStyleSettingsDefault.MODERN.KEYWORD_CASE;
        this.TYPE_CASE = SqlCodeStyleSettingsDefault.MODERN.TYPE_CASE;
        this.IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.IDENTIFIER_CASE;
        this.QUOTED_IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.QUOTED_IDENTIFIER_CASE;
        this.QUOTE_IDENTIFIER = SqlCodeStyleSettingsDefault.MODERN.QUOTE_IDENTIFIER;
        this.QUERY_SECTION_1ST_WORD_ALIGN = SqlCodeStyleSettingsDefault.MODERN.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.QUERY_EL_LINE;
        this.QUERY_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.QUERY_EL_COMMA;
        this.QUERY_IN_ONE_STRING = SqlCodeStyleSettingsDefault.MODERN.QUERY_IN_ONE_STRING;
        this.QUERY_TRUE_INDENT = SqlCodeStyleSettingsDefault.MODERN.QUERY_TRUE_INDENT;
        this.QUERY_ALIGN_ELEMENTS = SqlCodeStyleSettingsDefault.MODERN.QUERY_ALIGN_ELEMENTS;
        this.QUERY_ALIGN_LINE_COMMENTS = SqlCodeStyleSettingsDefault.MODERN.QUERY_ALIGN_LINE_COMMENTS;
        this.SUBQUERY_OPENING = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_OPENING;
        this.SUBQUERY_CONTENT = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_CONTENT;
        this.SUBQUERY_CLOSING = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_CLOSING;
        this.SUBQUERY_PAR_SPACE_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = SqlCodeStyleSettingsDefault.MODERN.INSERT_INTO_NL;
        this.INSERT_OPENING = SqlCodeStyleSettingsDefault.MODERN.INSERT_OPENING;
        this.INSERT_CONTENT = SqlCodeStyleSettingsDefault.MODERN.INSERT_CONTENT;
        this.INSERT_CLOSING = SqlCodeStyleSettingsDefault.MODERN.INSERT_CLOSING;
        this.INSERT_TABLE_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.INSERT_TABLE_EL_LINE;
        this.INSERT_VALUES_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.INSERT_VALUES_EL_LINE;
        this.INSERT_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.INSERT_EL_WRAP;
        this.INSERT_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.INSERT_EL_COMMA;
        this.INSERT_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.INSERT_SPACE_WITHIN_PARENTHESES;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = SqlCodeStyleSettingsDefault.MODERN.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.SET_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.SET_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SET_EL_WRAP;
        this.SET_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = SqlCodeStyleSettingsDefault.MODERN.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.WITH_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_WRAP;
        this.WITH_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.WITH_ALIGN_AS;
        this.SELECT_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.SELECT_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = SqlCodeStyleSettingsDefault.MODERN.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = SqlCodeStyleSettingsDefault.MODERN.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = SqlCodeStyleSettingsDefault.MODERN.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.SELECT_ALIGN_AS;
        this.FROM_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.FROM_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_WRAP;
        this.FROM_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = SqlCodeStyleSettingsDefault.MODERN.FROM_INDENT_JOIN;
        this.FROM_ONLY_JOIN_INDENT = SqlCodeStyleSettingsDefault.MODERN.FROM_ONLY_JOIN_INDENT;
        this.FROM_PLACE_ON = SqlCodeStyleSettingsDefault.MODERN.FROM_PLACE_ON;
        this.WHERE_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.WHERE_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_BOUND;
        this.ORDER_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.SET_EL_LINE;
        this.ORDER_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = SqlCodeStyleSettingsDefault.MODERN.ORDER_ALIGN_ASC_DESC;
        this.TABLE_OPENING = SqlCodeStyleSettingsDefault.MODERN.TABLE_OPENING;
        this.TABLE_CONTENT = SqlCodeStyleSettingsDefault.MODERN.TABLE_CONTENT;
        this.TABLE_CLOSING = SqlCodeStyleSettingsDefault.MODERN.TABLE_CLOSING;
        this.TABLE_TYPES_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_TYPES_ALIGN;
        this.TABLE_DEFAULTS_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_DEFAULTS_ALIGN;
        this.TABLE_NULLABILITIES_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_NULLABILITIES_ALIGN;
        this.TABLE_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.TABLE_COLLAPSE;
        this.TABLE_ALTER_INSTRUCTION_WRAP = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_INSTRUCTION_WRAP;
        this.TABLE_ALTER_INSTRUCTION_ALIGN = SqlCodeStyleSettingsDefault.MODERN.TABLE_ALTER_INSTRUCTION_ALIGN;
        this.CONSTRAINT_WRAP_1 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_3;
        this.CONSTRAINT_WRAP_4 = SqlCodeStyleSettingsDefault.MODERN.CONSTRAINT_WRAP_4;
        this.POST_OPT_WRAP_1 = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_WRAP_1;
        this.POST_OPT_WRAP_2 = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_WRAP_2;
        this.POST_OPT_INDENT = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_INDENT;
        this.POST_OPT_ALIGN = SqlCodeStyleSettingsDefault.MODERN.POST_OPT_ALIGN;
        this.CREATE_SCHEMA_CONTENT_INDENT = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_CONTENT_INDENT;
        this.CREATE_SCHEMA_BLANK_LINES_MIN = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_BLANK_LINES_MIN;
        this.CREATE_SCHEMA_BLANK_LINES_MAX = SqlCodeStyleSettingsDefault.MODERN.CREATE_SCHEMA_BLANK_LINES_MAX;
        this.VIEW_WRAP_AS = SqlCodeStyleSettingsDefault.MODERN.VIEW_WRAP_AS;
        this.VIEW_WRAP_QUERY = SqlCodeStyleSettingsDefault.MODERN.VIEW_WRAP_QUERY;
        this.VIEW_INDENT_QUERY = SqlCodeStyleSettingsDefault.MODERN.VIEW_INDENT_QUERY;
        this.ROUTINE_ARG_OPENING = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_OPENING;
        this.ROUTINE_ARG_CONTENT = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_CONTENT;
        this.ROUTINE_ARG_CLOSING = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_CLOSING;
        this.ROUTINE_ARG_WRAP = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_WRAP;
        this.ROUTINE_ARG_COMMA = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_COMMA;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_ARG_ALIGN_TYPES;
        this.ROUTINE_AS_WRAP = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_AS_WRAP;
        this.ROUTINE_PG_L_QUOTE_WRAP_BEFORE = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_L_QUOTE_WRAP_AFTER = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_L_QUOTE_WRAP_AFTER;
        this.ROUTINE_PG_R_QUOTE_WRAP_BEFORE = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_R_QUOTE_WRAP_AFTER = SqlCodeStyleSettingsDefault.MODERN.ROUTINE_PG_R_QUOTE_WRAP_AFTER;
        this.IMP_COMMON_WRAP_EVERY_STATEMENT = SqlCodeStyleSettingsDefault.MODERN.IMP_COMMON_WRAP_EVERY_STATEMENT;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = SqlCodeStyleSettingsDefault.MODERN.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
        this.IMP_DECLARE_CONTENT_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_CONTENT_WRAP;
        this.IMP_DECLARE_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_EL_WRAP;
        this.IMP_DECLARE_ALIGN_TYPE = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_TYPE;
        this.IMP_DECLARE_ALIGN_EQ = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_EQ;
        this.IMP_DECLARE_ALIGN_DEFAULT = SqlCodeStyleSettingsDefault.MODERN.IMP_DECLARE_ALIGN_DEFAULT;
        this.IMP_IF_THEN_WRAP_THEN = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_ELSE;
        this.IMP_IF_THEN_WRAP_INNER = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_WRAP_INNER;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_INDENT_THEN_ELSE;
        this.IMP_IF_THEN_INDENT_END = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_INDENT_END;
        this.IMP_IF_THEN_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.IMP_IF_THEN_COLLAPSE;
        this.IMP_LOOP_LOOP_WRAP = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_LOOP_WRAP;
        this.IMP_LOOP_LOOP_INDENT = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_LOOP_INDENT;
        this.IMP_LOOP_END_INDENT = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_END_INDENT;
        this.IMP_LOOP_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.IMP_LOOP_COLLAPSE;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_CLOSING;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_AFTER_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = SqlCodeStyleSettingsDefault.MODERN.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_SPACE_WITHIN_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.EXPR_SPACE_WITHIN_PARENTHESES;
        this.EXPR_BINARY_OP_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_INSIDE_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = SqlCodeStyleSettingsDefault.MODERN.EXPR_CALL_SPACE_AFTER_COMMA;
        this.EXPR_CASE_WHEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.FOREIGN_KEY_NAME_TEMPLATE;
        this.SUBQUERY_L_PAR_NL_OUTSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = SqlCodeStyleSettingsDefault.LEGACY.SUBQUERY_INDENT_INSIDE;
        this.SPACES_AROUND_OPERATORS = SqlCodeStyleSettingsDefault.LEGACY.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = SqlCodeStyleSettingsDefault.LEGACY.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_2;
    }

    public SqlCodeStyleSettings clone() {
        SqlCodeStyleSettings clone = (SqlCodeStyleSettings)super.clone();
        clone.myVersion = this.myVersion;
        return clone;
    }

    @NotNull
    public static Case getCaseMode(@SqlCodeStyleConst.IdentifierCase int codeStyleSetting) {
        Case case_ = codeStyleSetting == 0 ? Case.UPPER : (codeStyleSetting == 1 ? Case.LOWER : Case.MIXED);
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return case_;
    }

    @NotNull
    public Case getCaseModeExt(@SqlCodeStyleConst.IdentifierCaseExt int codeStyleSetting) {
        if (codeStyleSetting == 3) {
            Case case_ = this.getCaseModeExt(this.KEYWORD_CASE);
            if (case_ == null) {
                SqlCodeStyleSettings.$$$reportNull$$$0(1);
            }
            return case_;
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode(codeStyleSetting);
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return case_;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        Element sectionElement = parentElement.getChild(this.getTagName());
        if (sectionElement == null) {
            return;
        }
        this.myVersion = SqlCodeStyleSettings.readIntAttribute(sectionElement, "version");
        if (this.myVersion == 0) {
            this.assignDefaults(SqlCodeStyleSettingsDefault.LEGACY);
        }
        super.readExternal(parentElement);
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(3);
        }
        super.writeExternal(parentElement, parentSettings);
        Element sectionElement = parentElement.getChild(this.getTagName());
        if (sectionElement != null) {
            sectionElement.setAttribute("version", Integer.toString(this.myVersion));
        }
    }

    private static int readIntAttribute(@Nullable Element element, @NotNull String attributeName) {
        String value;
        if (attributeName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(4);
        }
        if ((value = SqlCodeStyleSettings.readStringAttribute(element, attributeName)) == null) {
            return 0;
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Reading SQL code style settings: Wrong integer attribute value: \"" + value + '\"');
            return 0;
        }
    }

    @Nullable
    private static String readStringAttribute(@Nullable Element element, @NotNull String attributeName) {
        if (attributeName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return null;
        }
        return element.getAttributeValue(attributeName);
    }

    public void beforeLoading() {
    }

    public void afterLoaded2() {
        if (this.myVersion == 0) {
            this.migrateFromVersion0();
        }
    }

    public void afterLoaded() {
        if (this.myVersion <= 0) {
            this.migrateFromVersion0();
        }
        if (this.myVersion <= 1) {
            this.migrateFromVersion1();
        }
    }

    private void migrateFromVersion0() {
        LOG.debug("Migrating SQL code style settings from version 0");
        CommonCodeStyleSettings c = this.getCommonSettings();
        int x = SqlCodeStyleSettings.countValue(2, this.WRAP_INSIDE_SET, this.WRAP_INSIDE_SELECT, this.WRAP_INSIDE_WHERE, this.WRAP_INSIDE_GROUP_BY, this.WRAP_INSIDE_ORDER_BY);
        this.QUERY_EL_LINE = x <= 2 ? 1 : (x >= 4 ? 101 : 0);
        this.SUBQUERY_PAR_SPACE_INSIDE = c.SPACE_WITHIN_PARENTHESES;
        this.SET_ALIGN_EQUAL_SIGN = this.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.SELECT_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_SELECT);
        this.SELECT_KEEP_N_ITEMS_IN_LINE = this.WRAP_INSIDE_SELECT == 2 ? 0 : 7;
        this.SELECT_ALIGN_AS = this.ALIGN_AS_IN_SELECT_STATEMENT;
        this.FROM_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_JOIN_EXPRESSION);
        if (this.FROM_EL_WRAP == 3) {
            this.FROM_EL_WRAP = 2;
        }
        this.FROM_WRAP_JOIN_1 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_WRAP_JOIN_2 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_INDENT_JOIN = this.INDENT_JOIN;
        this.WHERE_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_WHERE);
        this.ORDER_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_ORDER_BY);
        this.ORDER_EL_COMMA = this.NEW_LINE_BEFORE_COMMA ? 1 : 2;
        this.FROM_EL_COMMA = this.ORDER_EL_COMMA;
        this.SELECT_EL_COMMA = this.ORDER_EL_COMMA;
        this.ROUTINE_ARG_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_ARGUMENT_DEFINITION);
        this.ROUTINE_ARG_COMMA = this.NEW_LINE_BEFORE_COMMA ? 1 : 2;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = c.SPACE_WITHIN_METHOD_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = c.SPACE_BEFORE_METHOD_PARENTHESES;
        this.CORTEGE_COMMA_1ST = this.NEW_LINE_BEFORE_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = this.SPACES_AROUND_OPERATORS ? 1 : 2;
        this.EXPR_BINARY_OP_ALIGN = this.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.EXPR_CASE_THEN_WRAP = this.NEW_LINE_BEFORE_THEN;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = c.KEEP_BLANK_LINES_IN_CODE;
    }

    private void migrateFromVersion1() {
        LOG.debug("Migrating SQL code style settings from version 0");
        CommonCodeStyleSettings c = this.getCommonSettings();
        this.TABLE_OPENING = SqlCodeStyleSettingsDefault.LEGACY.TABLE_OPENING;
        this.TABLE_CONTENT = SqlCodeStyleSettingsDefault.LEGACY.TABLE_CONTENT;
        this.TABLE_CLOSING = SqlCodeStyleSettingsDefault.LEGACY.TABLE_CLOSING;
        this.TABLE_ALTER_INSTRUCTION_WRAP = SqlCodeStyleSettingsDefault.LEGACY.TABLE_ALTER_INSTRUCTION_WRAP;
        this.CONSTRAINT_WRAP_1 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = SqlCodeStyleSettingsDefault.LEGACY.CONSTRAINT_WRAP_3;
        this.POST_OPT_WRAP_1 = this.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.POST_OPT_WRAP_2 = this.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.TABLE_TYPES_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.TABLE_DEFAULTS_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.TABLE_NULLABILITIES_ALIGN = this.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = c.SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = c.SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = c.SPACE_AFTER_COMMA;
        this.IMP_DECLARE_EL_WRAP = this.ALIGN_TYPE_IN_BLOCK_STATEMENT ? 1 : 3;
        this.IMP_DECLARE_ALIGN_TYPE = this.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.IMP_IF_THEN_WRAP_THEN = this.NEW_LINE_BEFORE_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = this.NEW_LINE_BEFORE_ELSE;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = !this.NEW_LINE_BEFORE_THEN;
        this.IMP_IF_THEN_INDENT_END = !this.NEW_LINE_BEFORE_THEN;
        this.EXPR_SPACE_WITHIN_PARENTHESES = c.SPACE_WITHIN_PARENTHESES;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = c.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = c.SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = c.SPACE_AFTER_COMMA;
    }

    @NotNull
    private CommonCodeStyleSettings getCommonSettings() {
        CodeStyleSettings container = this.getContainer();
        assert (container != null) : "The container of SQL custom settings must not be null";
        CommonCodeStyleSettings commonCodeStyleSettings = container.getCommonSettings((Language)SqlLanguage.INSTANCE);
        if (commonCodeStyleSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(6);
        }
        return commonCodeStyleSettings;
    }

    private static int countValue(int valueToCount, int ... values) {
        int m = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            if (values[i] != valueToCount) continue;
            ++m;
        }
        return m;
    }

    @Contract(pure=true)
    @SqlCodeStyleConst.WrapMagicValues
    private static int convertWrap(int oldWrap) {
        switch (oldWrap) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public void manuallyChanged() {
        if (this.myVersion < 2) {
            LOG.info(String.format("SQL code style settings version updated from %d to %d (because they were manually changed)", this.myVersion, 2));
            this.myVersion = 2;
        }
    }

    private void assignDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(7);
        }
        this.assignModernDefaults(def);
        this.assignLegacyDefaults(def);
    }

    private void assignModernDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(8);
        }
        this.ALIAS_CASE = def.ALIAS_CASE;
        this.KEYWORD_CASE = def.KEYWORD_CASE;
        this.TYPE_CASE = def.TYPE_CASE;
        this.IDENTIFIER_CASE = def.IDENTIFIER_CASE;
        this.QUOTED_IDENTIFIER_CASE = def.QUOTED_IDENTIFIER_CASE;
        this.QUOTE_IDENTIFIER = def.QUOTE_IDENTIFIER;
        this.QUERY_SECTION_1ST_WORD_ALIGN = def.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = def.QUERY_EL_LINE;
        this.QUERY_EL_COMMA = def.QUERY_EL_COMMA;
        this.QUERY_IN_ONE_STRING = def.QUERY_IN_ONE_STRING;
        this.QUERY_TRUE_INDENT = def.QUERY_TRUE_INDENT;
        this.QUERY_ALIGN_ELEMENTS = def.QUERY_ALIGN_ELEMENTS;
        this.QUERY_ALIGN_LINE_COMMENTS = def.QUERY_ALIGN_LINE_COMMENTS;
        this.SUBQUERY_OPENING = def.SUBQUERY_OPENING;
        this.SUBQUERY_CONTENT = def.SUBQUERY_CONTENT;
        this.SUBQUERY_CLOSING = def.SUBQUERY_CLOSING;
        this.SUBQUERY_PAR_SPACE_INSIDE = def.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = def.INSERT_INTO_NL;
        this.INSERT_OPENING = def.INSERT_OPENING;
        this.INSERT_CONTENT = def.INSERT_CONTENT;
        this.INSERT_CLOSING = def.INSERT_CLOSING;
        this.INSERT_TABLE_EL_LINE = def.INSERT_TABLE_EL_LINE;
        this.INSERT_VALUES_EL_LINE = def.INSERT_VALUES_EL_LINE;
        this.INSERT_EL_WRAP = def.INSERT_EL_WRAP;
        this.INSERT_EL_COMMA = def.INSERT_EL_COMMA;
        this.INSERT_SPACE_WITHIN_PARENTHESES = def.INSERT_SPACE_WITHIN_PARENTHESES;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = def.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.SET_EL_LINE = def.SET_EL_LINE;
        this.SET_EL_WRAP = def.SET_EL_WRAP;
        this.SET_EL_COMMA = def.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = def.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_LINE = def.WITH_EL_LINE;
        this.WITH_EL_WRAP = def.WITH_EL_WRAP;
        this.WITH_EL_COMMA = def.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = def.WITH_ALIGN_AS;
        this.SELECT_EL_LINE = def.SELECT_EL_LINE;
        this.SELECT_EL_WRAP = def.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = def.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = def.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = def.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = def.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = def.SELECT_ALIGN_AS;
        this.FROM_EL_LINE = def.FROM_EL_LINE;
        this.FROM_EL_WRAP = def.FROM_EL_WRAP;
        this.FROM_EL_COMMA = def.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = def.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = def.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = def.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = def.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = def.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = def.FROM_INDENT_JOIN;
        this.FROM_ONLY_JOIN_INDENT = def.FROM_ONLY_JOIN_INDENT;
        this.FROM_PLACE_ON = def.FROM_PLACE_ON;
        this.WHERE_EL_LINE = def.WHERE_EL_LINE;
        this.WHERE_EL_WRAP = def.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = def.WHERE_EL_BOUND;
        this.ORDER_EL_LINE = def.ORDER_EL_LINE;
        this.ORDER_EL_WRAP = def.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = def.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = def.ORDER_ALIGN_ASC_DESC;
        this.TABLE_OPENING = def.TABLE_OPENING;
        this.TABLE_CONTENT = def.TABLE_CONTENT;
        this.TABLE_CLOSING = def.TABLE_CLOSING;
        this.TABLE_TYPES_ALIGN = def.TABLE_TYPES_ALIGN;
        this.TABLE_DEFAULTS_ALIGN = def.TABLE_DEFAULTS_ALIGN;
        this.TABLE_NULLABILITIES_ALIGN = def.TABLE_NULLABILITIES_ALIGN;
        this.TABLE_COLLAPSE = def.TABLE_COLLAPSE;
        this.TABLE_ALTER_INSTRUCTION_WRAP = def.TABLE_ALTER_INSTRUCTION_WRAP;
        this.TABLE_ALTER_INSTRUCTION_ALIGN = def.TABLE_ALTER_INSTRUCTION_ALIGN;
        this.CONSTRAINT_WRAP_1 = def.CONSTRAINT_WRAP_1;
        this.CONSTRAINT_WRAP_2 = def.CONSTRAINT_WRAP_2;
        this.CONSTRAINT_WRAP_3 = def.CONSTRAINT_WRAP_3;
        this.CONSTRAINT_WRAP_4 = def.CONSTRAINT_WRAP_4;
        this.POST_OPT_WRAP_1 = def.POST_OPT_WRAP_1;
        this.POST_OPT_WRAP_2 = def.POST_OPT_WRAP_2;
        this.POST_OPT_INDENT = def.POST_OPT_INDENT;
        this.POST_OPT_ALIGN = def.POST_OPT_ALIGN;
        this.CREATE_SCHEMA_CONTENT_INDENT = def.CREATE_SCHEMA_CONTENT_INDENT;
        this.CREATE_SCHEMA_BLANK_LINES_MIN = def.CREATE_SCHEMA_BLANK_LINES_MIN;
        this.CREATE_SCHEMA_BLANK_LINES_MAX = def.CREATE_SCHEMA_BLANK_LINES_MAX;
        this.VIEW_WRAP_AS = def.VIEW_WRAP_AS;
        this.VIEW_WRAP_QUERY = def.VIEW_WRAP_QUERY;
        this.VIEW_INDENT_QUERY = def.VIEW_INDENT_QUERY;
        this.ROUTINE_ARG_OPENING = def.ROUTINE_ARG_OPENING;
        this.ROUTINE_ARG_CONTENT = def.ROUTINE_ARG_CONTENT;
        this.ROUTINE_ARG_CLOSING = def.ROUTINE_ARG_CLOSING;
        this.ROUTINE_ARG_WRAP = def.ROUTINE_ARG_WRAP;
        this.ROUTINE_ARG_COMMA = def.ROUTINE_ARG_COMMA;
        this.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES = def.ROUTINE_ARG_SPACE_WITHIN_PARENTHESES;
        this.ROUTINE_ARG_ALIGN_TYPES = def.ROUTINE_ARG_ALIGN_TYPES;
        this.ROUTINE_AS_WRAP = def.ROUTINE_AS_WRAP;
        this.ROUTINE_PG_L_QUOTE_WRAP_BEFORE = def.ROUTINE_PG_L_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_L_QUOTE_WRAP_AFTER = def.ROUTINE_PG_L_QUOTE_WRAP_AFTER;
        this.ROUTINE_PG_R_QUOTE_WRAP_BEFORE = def.ROUTINE_PG_R_QUOTE_WRAP_BEFORE;
        this.ROUTINE_PG_R_QUOTE_WRAP_AFTER = def.ROUTINE_PG_R_QUOTE_WRAP_AFTER;
        this.IMP_COMMON_WRAP_EVERY_STATEMENT = def.IMP_COMMON_WRAP_EVERY_STATEMENT;
        this.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE = def.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE;
        this.IMP_DECLARE_CONTENT_WRAP = def.IMP_DECLARE_CONTENT_WRAP;
        this.IMP_DECLARE_EL_WRAP = def.IMP_DECLARE_EL_WRAP;
        this.IMP_DECLARE_ALIGN_TYPE = def.IMP_DECLARE_ALIGN_TYPE;
        this.IMP_DECLARE_ALIGN_EQ = def.IMP_DECLARE_ALIGN_EQ;
        this.IMP_DECLARE_ALIGN_DEFAULT = def.IMP_DECLARE_ALIGN_DEFAULT;
        this.IMP_IF_THEN_WRAP_THEN = def.IMP_IF_THEN_WRAP_THEN;
        this.IMP_IF_THEN_WRAP_ELSE = def.IMP_IF_THEN_WRAP_ELSE;
        this.IMP_IF_THEN_WRAP_INNER = def.IMP_IF_THEN_WRAP_INNER;
        this.IMP_IF_THEN_INDENT_THEN_ELSE = def.IMP_IF_THEN_INDENT_THEN_ELSE;
        this.IMP_IF_THEN_INDENT_END = def.IMP_IF_THEN_INDENT_END;
        this.IMP_IF_THEN_COLLAPSE = def.IMP_IF_THEN_COLLAPSE;
        this.IMP_LOOP_LOOP_WRAP = def.IMP_LOOP_LOOP_WRAP;
        this.IMP_LOOP_LOOP_INDENT = def.IMP_LOOP_LOOP_INDENT;
        this.IMP_LOOP_END_INDENT = def.IMP_LOOP_END_INDENT;
        this.IMP_LOOP_COLLAPSE = def.IMP_LOOP_COLLAPSE;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = def.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = def.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = def.CORTEGE_CLOSING;
        this.CORTEGE_SPACE_WITHIN_PARENTHESES = def.CORTEGE_SPACE_WITHIN_PARENTHESES;
        this.CORTEGE_SPACE_BEFORE_COMMA = def.CORTEGE_SPACE_BEFORE_COMMA;
        this.CORTEGE_SPACE_AFTER_COMMA = def.CORTEGE_SPACE_AFTER_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = def.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_SPACE_WITHIN_PARENTHESES = def.EXPR_SPACE_WITHIN_PARENTHESES;
        this.EXPR_BINARY_OP_ALIGN = def.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CALL_SPACE_INSIDE_PARENTHESES = def.EXPR_CALL_SPACE_INSIDE_PARENTHESES;
        this.EXPR_CALL_SPACE_BEFORE_COMMA = def.EXPR_CALL_SPACE_BEFORE_COMMA;
        this.EXPR_CALL_SPACE_AFTER_COMMA = def.EXPR_CALL_SPACE_AFTER_COMMA;
        this.EXPR_CASE_WHEN_WRAP = def.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = def.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = def.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = def.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = def.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = def.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = def.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = def.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = def.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = def.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = def.FOREIGN_KEY_NAME_TEMPLATE;
    }

    private void assignLegacyDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(9);
        }
        this.SUBQUERY_L_PAR_NL_OUTSIDE = def.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = def.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = def.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = def.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = def.SUBQUERY_INDENT_INSIDE;
        this.SPACES_AROUND_OPERATORS = def.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = def.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = def.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = def.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = def.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = def.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = def.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = def.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = def.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = def.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = def.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = def.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = def.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = def.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = def.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = def.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = def.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = def.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = def.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = def.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = def.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = def.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = def.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = def.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = def.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = def.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = def.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = def.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = def.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = def.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = def.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = def.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = def.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = def.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = def.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = def.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = def.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = def.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = def.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = def.NEW_LINE_AFTER_SELECT_2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseModeExt";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readIntAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readStringAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assignDefaults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assignModernDefaults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assignLegacyDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

