/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestConsoleProperties
extends SMTRunnerConsoleProperties {
    private final CompositeFilter myStackTraceFilter;

    public JsTestConsoleProperties(@NotNull RunConfiguration config2, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config2 == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(2);
        }
        super(config2, testFrameworkName, executor);
        this.myStackTraceFilter = new CompositeFilter(config2.getProject());
    }

    public void addStackTraceFilter(@NotNull Filter filter) {
        if (filter == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(3);
        }
        this.myStackTraceFilter.addFilter(filter);
    }

    @NotNull
    public List<Filter> getStackTrackFilters() {
        List list = this.myStackTraceFilter.getFilters();
        if (list == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String[] lines;
        if (location == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(5);
        }
        if (stacktrace == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(6);
        }
        if (this.myStackTraceFilter.isEmpty()) {
            return null;
        }
        PsiElement navigationElement = location.getPsiElement();
        PsiElement enclosingElement = JsTestConsoleProperties.getEnclosingElement(navigationElement);
        if (enclosingElement == null) {
            return null;
        }
        String withoutAnsiStackTrace = JsTestConsoleProperties.clearAnsi(stacktrace);
        int stacktraceLength = withoutAnsiStackTrace.length();
        for (String line : lines = StringUtil.splitByLines((String)withoutAnsiStackTrace)) {
            OpenFileDescriptor descriptor2;
            HyperlinkInfo info;
            Filter.Result result2 = this.myStackTraceFilter.applyFilter(line, stacktraceLength);
            HyperlinkInfo hyperlinkInfo = info = result2 != null ? result2.getFirstHyperlinkInfo() : null;
            if (!(info instanceof FileHyperlinkInfo) || (descriptor2 = ((FileHyperlinkInfo)info).getDescriptor()) == null || !JsTestConsoleProperties.isInside(enclosingElement, descriptor2)) continue;
            return descriptor2;
        }
        return null;
    }

    @NotNull
    private static String clearAnsi(@NotNull String stacktrace) {
        if (stacktrace == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(7);
        }
        StringBuilder buffer = new StringBuilder();
        new AnsiEscapeDecoder().escapeText(stacktrace, ProcessOutputTypes.STDOUT, (text, attributes) -> buffer.append(text));
        String string = buffer.toString();
        if (string == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static PsiElement getEnclosingElement(@NotNull PsiElement element) {
        if (element == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(9);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class, (boolean)true);
    }

    private static boolean isInside(@NotNull PsiElement enclosingElement, @NotNull OpenFileDescriptor descriptor2) {
        if (enclosingElement == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(11);
        }
        if (descriptor2.getFile().equals(enclosingElement.getContainingFile().getOriginalFile().getVirtualFile())) {
            int offset = descriptor2.getOffset();
            return offset >= 0 && enclosingElement.getTextRange().contains(offset);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrackFilters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAnsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStackTraceFilter";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearAnsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInside";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

