/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSAnyModuleImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportPathBuilder {
    private static final Logger LOGGER = Logger.getInstance(JSImportPathBuilder.class);
    @NotNull
    protected final PsiElement myPlace;
    @NotNull
    protected final VirtualFile myPlaceFile;
    @Nullable
    protected final PsiElement myElementToImport;
    @NotNull
    protected final VirtualFile myFileToImport;
    @NotNull
    protected final Project myProject;
    protected final boolean myUseExistingImports;
    @NotNull
    protected final PsiElement myPlaceModule;

    public JSImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport, boolean useExistingImports) {
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (fileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = place.getProject();
        this.myUseExistingImports = useExistingImports;
        PsiFile originalFile = place.getContainingFile().getOriginalFile();
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)place);
        if (originalElement == null) {
            originalElement = originalFile;
        }
        this.myPlaceModule = ES6PsiUtil.isExternalModule(originalElement) ? originalElement : (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(place), (Object)originalFile);
        this.myPlace = place;
        this.myPlaceFile = originalFile.getVirtualFile();
        this.myElementToImport = elementToImport;
        this.myFileToImport = fileToImport;
    }

    @NotNull
    static JSImportPathBuilder createBuilder(@NotNull PsiElement place, @Nullable PsiElement toImport, @NotNull VirtualFile dstFile, boolean useExistingImports, @Nullable TypeScriptConfig configFile) {
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (DialectDetector.isTypeScript(place)) {
            TypeScriptImportPathBuilder typeScriptImportPathBuilder = new TypeScriptImportPathBuilder(place, toImport, dstFile, configFile, useExistingImports);
            if (typeScriptImportPathBuilder == null) {
                JSImportPathBuilder.$$$reportNull$$$0(4);
            }
            return typeScriptImportPathBuilder;
        }
        if (toImport != null && DialectDetector.isTypeScript(toImport)) {
            TypeScriptInES6ImportPathBuilder typeScriptInES6ImportPathBuilder = new TypeScriptInES6ImportPathBuilder(place, toImport, dstFile, useExistingImports);
            if (typeScriptInES6ImportPathBuilder == null) {
                JSImportPathBuilder.$$$reportNull$$$0(5);
            }
            return typeScriptInES6ImportPathBuilder;
        }
        JSAnyModuleImportPathBuilder jSAnyModuleImportPathBuilder = new JSAnyModuleImportPathBuilder(place, toImport, dstFile, useExistingImports);
        if (jSAnyModuleImportPathBuilder == null) {
            JSImportPathBuilder.$$$reportNull$$$0(6);
        }
        return jSAnyModuleImportPathBuilder;
    }

    @NotNull
    public static JSImportPathBuilder createBuilder(@NotNull PsiElement place, @Nullable PsiElement toImport, @NotNull VirtualFile dstFile, boolean useExistingImports) {
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(8);
        }
        PsiFile myPlacePsiFile = place.getContainingFile().getOriginalFile();
        TypeScriptConfig configFile = DialectDetector.isTypeScript(place) ? TypeScriptConfigUtil.getConfigForPsiFile(myPlacePsiFile) : null;
        JSImportPathBuilder jSImportPathBuilder = JSImportPathBuilder.createBuilder(place, toImport, dstFile, useExistingImports, configFile);
        if (jSImportPathBuilder == null) {
            JSImportPathBuilder.$$$reportNull$$$0(9);
        }
        return jSImportPathBuilder;
    }

    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        String rootPath;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(11);
        }
        if ((rootPath = this.getPathRelativeToRoots(moduleFileOrDirectory)) != null) {
            return new JSModuleNameInfo(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myPlace);
        }
        return null;
    }

    protected final void processDirectModuleNames(boolean checkNodeResolution, @NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (checkNodeResolution && this.useNodeResolution()) {
            if (!this.processForNodeResolutionSymlinks(processor)) {
                return;
            }
            if (!this.processModuleFileWithNodeResolution(processor)) {
                return;
            }
        }
        this.processForModuleFile(processor, this.myFileToImport, this.myFileToImport);
    }

    protected boolean processForNodeResolutionSymlinks(@NotNull Processor<? super JSModuleNameInfo> processor) {
        String pathFromImportRoot;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(13);
        }
        if (this.myFileToImport.isDirectory() || NodeModuleUtil.hasNodeModulesDirInPath(this.myFileToImport, this.myProject.getBaseDir())) {
            return true;
        }
        VirtualFile placeRoot = NodeModuleUtil.getMainModuleRoot(this.myPlace);
        if (placeRoot == null) {
            return true;
        }
        VirtualFile importRoot = NodeModuleUtil.findMainModuleRoot(this.myProject, this.myFileToImport);
        if (importRoot == null || placeRoot.equals(importRoot)) {
            return true;
        }
        VirtualFile importPackageJson = PackageJsonUtil.findChildPackageJsonFile(importRoot);
        if (importPackageJson == null) {
            return true;
        }
        VirtualFile commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)placeRoot, (VirtualFile)importRoot);
        if (commonParent == null || importRoot.equals(commonParent)) {
            return true;
        }
        PackageJsonData importData = PackageJsonUtil.getOrCreateData(importPackageJson);
        String importPackageName = importData.getName();
        if (importPackageName == null) {
            importPackageName = importRoot.getName();
        }
        if ((pathFromImportRoot = VfsUtilCore.getRelativePath((VirtualFile)this.myFileToImport, (VirtualFile)importRoot)) == null) {
            return true;
        }
        VirtualFile placeRootNodeModules = placeRoot.findChild("node_modules");
        if (!this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, placeRootNodeModules, importPackageName))) {
            return false;
        }
        VirtualFile rootProject = NodeModuleUtil.findMainModuleRoot(this.myProject, commonParent);
        if (rootProject == null) {
            return true;
        }
        VirtualFile commonRootNodeModules = rootProject.findChild("node_modules");
        return this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, commonRootNodeModules, importPackageName));
    }

    private boolean processSymlinkForNodeModules(@NotNull Processor<? super JSModuleNameInfo> processor, @Nullable JSSymlinkLinkedProject linkedProject) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(14);
        }
        if (linkedProject == null) {
            return true;
        }
        VirtualFile importRoot = linkedProject.getImportRoot();
        for (VirtualFile packageResolveFile : this.resolveFileAsNpmPackage(linkedProject.getLinkedPackage())) {
            VirtualFile sourceFile;
            if (packageResolveFile == null || (sourceFile = linkedProject.getSourceFileByLinkedFile(packageResolveFile)) == null || this.checkSymbolAndGetFile(sourceFile) == null || processor.process((Object)new JSModuleNameInfo(linkedProject.getPackageName(), importRoot, sourceFile, this.myPlace))) continue;
            return false;
        }
        return this.processHierarchy(importRoot, (PairFunction<? super VirtualFile, ? super VirtualFile, Boolean>)((PairFunction)(candidate, resolvedFile) -> {
            String path;
            if (processor == null) {
                JSImportPathBuilder.$$$reportNull$$$0(60);
            }
            if ((path = linkedProject.getLinkedPath((VirtualFile)candidate)) == null) {
                return true;
            }
            return processor.process((Object)new JSModuleNameInfo(path, (VirtualFile)candidate, (VirtualFile)resolvedFile, this.myPlace));
        }));
    }

    private boolean processModuleFileWithNodeResolution(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(15);
        }
        VirtualFile importDirectory = this.myFileToImport.getParent();
        VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(importDirectory);
        if (VfsUtilCore.isAncestor((VirtualFile)importDirectory, (VirtualFile)this.myPlaceFile, (boolean)true)) {
            return true;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        if (placeDirectory == null) {
            return true;
        }
        return this.iterateParentDirectoriesForNodeResolution(processor, importDirectory, placeDirectory, sourceRoot);
    }

    private boolean iterateParentDirectoriesForNodeResolution(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile toIterateDirectory, @NotNull VirtualFile placeDirectory, @Nullable VirtualFile sourceRoot) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(16);
        }
        if (toIterateDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(17);
        }
        if (placeDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(18);
        }
        while (!(toIterateDirectory == null || sourceRoot != null && sourceRoot.equals(toIterateDirectory) || toIterateDirectory.equals(placeDirectory))) {
            VirtualFile resolvedModuleFile = this.checkSymbolAndGetFile(toIterateDirectory);
            if (resolvedModuleFile != null && !this.processForModuleFile(processor, toIterateDirectory, resolvedModuleFile)) {
                return false;
            }
            toIterateDirectory = toIterateDirectory.getParent();
        }
        return true;
    }

    private boolean processForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, VirtualFile moduleFileOrDirectory, VirtualFile resolvedModuleFile) {
        JSModuleNameInfo rootModuleInfo;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(19);
        }
        if (!this.processContributorsForModuleFile(processor, moduleFileOrDirectory, resolvedModuleFile)) {
            return false;
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(this.myPlace) && (rootModuleInfo = this.processRootPaths(moduleFileOrDirectory, resolvedModuleFile)) != null && !processor.process((Object)rootModuleInfo)) {
            return false;
        }
        String externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)moduleFileOrDirectory, (char)'/');
        if (externalModuleName == null) {
            externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)this.myFileToImport, (char)'/');
            if (externalModuleName == null) {
                externalModuleName = this.myFileToImport.getName();
            }
            moduleFileOrDirectory = this.myFileToImport;
            resolvedModuleFile = this.myFileToImport;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return processor.process((Object)new JSModuleNameInfo(externalModuleName, moduleFileOrDirectory, resolvedModuleFile, this.myPlace));
    }

    private boolean processContributorsForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(20);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(21);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(22);
        }
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            String contributorModulePath;
            if (!contributor.isApplicable(this.myPlace) || StringUtil.isEmpty((String)(contributorModulePath = contributor.getModulePath(this.myPlace, moduleFileOrDirectory, resolvedModuleFile))) || processor.process((Object)new JSModuleNameInfo(contributorModulePath, this.myFileToImport, this.myPlace))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected JSModuleNameInfo getPathForRoot(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull VirtualFile rootFile) {
        String path;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(23);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(24);
        }
        if (rootFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(25);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)moduleFileOrDirectory, (char)'/')) == null) {
            path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)this.myFileToImport, (char)'/');
        }
        JSModuleNameInfo jSModuleNameInfo = new JSModuleNameInfo(path, moduleFileOrDirectory, resolvedModuleFile, this.myPlace);
        if (jSModuleNameInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(26);
        }
        return jSModuleNameInfo;
    }

    protected boolean useNodeResolution() {
        return JSCodeStyleSettings.isUseNodeResolution(this.myPlace);
    }

    public final void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(27);
        }
        if (!this.processExistingImports(processor)) {
            return;
        }
        this.processModuleNamesWithoutExistingImports(processor);
    }

    public void processModuleNamesWithoutExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(28);
        }
        this.processDirectModuleNames(true, processor);
    }

    protected boolean processExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(29);
        }
        if (!this.myUseExistingImports || !(this.myElementToImport instanceof JSElement)) {
            return true;
        }
        VirtualFile elementToExportFile = this.myElementToImport.getContainingFile().getVirtualFile();
        boolean isLibraryFile = JSLibraryUtil.isProbableLibraryFile(elementToExportFile, this.myProject);
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(this.myPlaceModule);
        THashSet visitedModules = ContainerUtil.newTroveSet();
        block0: for (ES6ImportDeclaration declaration : declarations) {
            PsiElement object;
            ES6FromClause clause = declaration.getFromClause();
            Collection<Object> objects = clause == null ? Collections.emptyList() : clause.resolveReferencedElements();
            Iterator<Object> iterator = objects.iterator();
            while (iterator.hasNext() && visitedModules.add(object = (PsiElement)iterator.next())) {
                if (!(object instanceof JSFile)) continue;
                VirtualFile virtualFile = ((JSFile)object).getVirtualFile();
                if (JSLibraryUtil.isProbableLibraryFile(virtualFile, this.myProject) != isLibraryFile) continue block0;
                ResolveResult result2 = ES6CreateImportUtil.resolveSymbolInModule((JSElement)this.myElementToImport, this.myPlace, (JSElement)((JSFile)object));
                if (result2 == null) continue;
                String path = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)clause.getReferenceText()));
                return processor.process((Object)new JSModuleNameInfo(path, virtualFile, virtualFile, this.myPlace));
            }
        }
        return true;
    }

    @NotNull
    public static Processor<JSModuleNameInfo> createSearchProcessor(@NotNull Ref<? super JSModuleNameInfo> ref, @NotNull String[] excludedNames) {
        if (ref == null) {
            JSImportPathBuilder.$$$reportNull$$$0(30);
        }
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(31);
        }
        Processor processor = info -> {
            if (excludedNames == null) {
                JSImportPathBuilder.$$$reportNull$$$0(58);
            }
            if (ref == null) {
                JSImportPathBuilder.$$$reportNull$$$0(59);
            }
            if (info.isValid() && (excludedNames.length == 0 || !ArrayUtil.contains((String)info.getModuleName(), (String[])excludedNames))) {
                if (ref.get() != null) {
                    LOGGER.error("Processor wasn't stop properly. Please make sure that all places use the returned value for stop");
                    return false;
                }
                ref.set(info);
                return false;
            }
            return true;
        };
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(32);
        }
        return processor;
    }

    @Nullable
    protected final VirtualFile checkSymbolAndGetFile(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(33);
        }
        return this.checkSymbolAndGetFile(moduleFileOrDirectory, true);
    }

    @Nullable
    protected final VirtualFile checkSymbolAndGetFile(@NotNull VirtualFile moduleFileOrDirectory, boolean checkSymbol) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(34);
        }
        if (moduleFileOrDirectory.equals(this.myFileToImport)) {
            return moduleFileOrDirectory;
        }
        Collection<VirtualFile> resolvedFiles = Collections.singleton(moduleFileOrDirectory);
        if (moduleFileOrDirectory.isDirectory()) {
            resolvedFiles = this.resolveFileAsNpmPackage(moduleFileOrDirectory);
        }
        if (resolvedFiles.isEmpty()) {
            return null;
        }
        VirtualFile candidate = resolvedFiles.stream().filter(el -> el.equals(this.myFileToImport)).findAny().orElse(null);
        if (candidate != null) {
            return candidate;
        }
        if (this.myElementToImport == null || !checkSymbol) {
            return null;
        }
        for (VirtualFile resolvedFile : resolvedFiles) {
            if (!ES6CreateImportUtil.checkSymbolInFile(this.myProject, resolvedFile, this.myElementToImport, this.myPlace)) continue;
            return resolvedFile;
        }
        return null;
    }

    @NotNull
    protected Collection<VirtualFile> resolveFileAsNpmPackage(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(35);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.resolveAsNpmPackage(moduleFileOrDirectory, this.myElementToImport == null ? this.myPlace : this.myElementToImport));
        if (list == null) {
            JSImportPathBuilder.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    private VirtualFile resolveAsNpmPackage(@NotNull VirtualFile pathFile, @NotNull PsiElement context) {
        if (pathFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(37);
        }
        if (context == null) {
            JSImportPathBuilder.$$$reportNull$$$0(38);
        }
        NodeModuleDirectorySearchProcessor processor = DialectDetector.isTypeScript(context) ? new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(this.myProject) : NodeModuleDirectorySearchProcessor.PROCESSOR;
        return JSExactFileReference.resolveForNpmPackages(pathFile, processor);
    }

    @Nullable
    private String getPathRelativeToRoots(@NotNull VirtualFile moduleFile) {
        String path;
        ModuleRootManager rootManager;
        Object[] sourceRoots;
        String path2;
        WebResourcesPathsConfiguration pathsConfiguration;
        if (moduleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(39);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)this.myProject)) != null && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path2;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPlace);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, ContainerUtil.newArrayList((Object[])sourceRoots), false)) != null) {
            return path;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myPlaceFile);
        return contentRoot != null ? VfsUtilCore.findRelativePath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    @Nullable
    protected final NodeModuleUtil.NodeModuleStructure getNodeModuleStructureForImportedFile() {
        return NodeModuleUtil.getNodeModuleStructure(this.myProject, this.myFileToImport);
    }

    @NotNull
    protected JSModuleNameInfo createNodeModuleNameInfo(@NotNull NodeModuleUtil.NodeModuleStructure structure, @NotNull VirtualFile moduleOrFileToImport, @NotNull VirtualFile resolvedFile) {
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(40);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(41);
        }
        if (resolvedFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(42);
        }
        String path = JSImportPathBuilder.getNodeModulePath(structure.moduleDirectory, structure.directoryToCalcModuleName, moduleOrFileToImport);
        JSModuleNameInfo jSModuleNameInfo = new JSModuleNameInfo(path, moduleOrFileToImport, resolvedFile, this.myPlace);
        if (jSModuleNameInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(43);
        }
        return jSModuleNameInfo;
    }

    protected final boolean processModuleNameUsingNodeModules(@NotNull Processor<JSModuleNameInfo> processor) {
        NodeModuleUtil.NodeModuleStructure nodeModuleStructure;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(44);
        }
        if ((nodeModuleStructure = this.getNodeModuleStructureForImportedFile()) == null) {
            return true;
        }
        return this.processModuleUsingNodeModules(processor, nodeModuleStructure);
    }

    protected abstract boolean processModuleUsingNodeModules(@NotNull Processor<JSModuleNameInfo> var1, @NotNull NodeModuleUtil.NodeModuleStructure var2);

    @Nullable
    protected static String getNodeModulePath(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleOrFileToImport) {
        String path;
        if (moduleDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(45);
        }
        if (directoryToCalcModuleName == null) {
            JSImportPathBuilder.$$$reportNull$$$0(46);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(47);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)directoryToCalcModuleName, (VirtualFile)moduleOrFileToImport, (char)'/')) == null || !"@types".equals(directoryToCalcModuleName.getName())) {
            return path;
        }
        String name = moduleDirectory.getName();
        if (!path.startsWith(name)) {
            return path;
        }
        int separatorIndex = name.indexOf("__");
        if (separatorIndex <= 0) {
            return path;
        }
        String scope = name.substring(0, separatorIndex);
        String module = name.substring(separatorIndex + 2);
        if (scope.isEmpty() || module.isEmpty()) {
            return path;
        }
        String subPath = path.substring(name.length());
        return "@" + scope + "/" + module + subPath;
    }

    protected boolean processHierarchy(@NotNull VirtualFile parentToStop, @NotNull PairFunction<? super VirtualFile, ? super VirtualFile, Boolean> parentFileProcessor) {
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(48);
        }
        if (parentFileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(49);
        }
        return this.processElements(ContainerUtil.reverse(JSImportPathBuilder.collectParents(this.myFileToImport, parentToStop)), parentFileProcessor);
    }

    protected boolean processElements(@NotNull List<VirtualFile> elementsToProcess, @NotNull PairFunction<? super VirtualFile, ? super VirtualFile, Boolean> fileProcessor) {
        if (elementsToProcess == null) {
            JSImportPathBuilder.$$$reportNull$$$0(50);
        }
        if (fileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(51);
        }
        for (VirtualFile current : elementsToProcess) {
            VirtualFile resolved = this.checkSymbolAndGetFile(current);
            if (resolved == null || ((Boolean)fileProcessor.fun((Object)current, (Object)resolved)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile parentToStop) {
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(52);
        }
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(53);
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (parentToStop.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSImportPathBuilder.$$$reportNull$$$0(54);
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            JSImportPathBuilder.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        VirtualFile linkedPackage;
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(56);
        }
        if ((linkedPackage = JSImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName)) == null) {
            return null;
        }
        return new JSSymlinkLinkedProject(importRoot, linkedPackage, packageName);
    }

    @Nullable
    protected static VirtualFile getLinkedPackage(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(57);
        }
        if (packageName == null || nodeModules == null) {
            return null;
        }
        VirtualFile linkedPackage = nodeModules.findFileByRelativePath(packageName);
        if (linkedPackage == null || importRoot.equals(linkedPackage)) {
            return null;
        }
        if (!Objects.equals(linkedPackage.getCanonicalFile(), importRoot)) {
            return null;
        }
        return linkedPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 32: 
            case 36: 
            case 43: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 32: 
            case 36: 
            case 43: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 3: 
            case 8: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 32: 
            case 36: 
            case 43: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 10: 
            case 21: 
            case 23: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 11: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 44: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIterateDirectory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeDirectory";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 30: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 31: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedNames";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToCalcModuleName";
                break;
            }
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToStop";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileProcessor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForRoot";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchProcessor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileAsNpmPackage";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeModuleNameInfo";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 32: 
            case 36: 
            case 43: 
            case 54: 
            case 55: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDirectModuleNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processForNodeResolutionSymlinks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processSymlinkForNodeModules";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processModuleFileWithNodeResolution";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateParentDirectoriesForNodeResolution";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processContributorsForModuleFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPathForRoot";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processExistingImports";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createSearchProcessor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolAndGetFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileAsNpmPackage";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsNpmPackage";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRoots";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createNodeModuleNameInfo";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulePath";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPackage";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSearchProcessor$1";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processSymlinkForNodeModules$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 32: 
            case 36: 
            case 43: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

