/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersHandler
extends MoveHandlerDelegate {
    public static final Key<PsiFile> EXPLICIT_TARGET_FILE_KEY = new Key("ES6MoveModuleMembersHandler.EXPLICIT_TARGET_FILE_KEY");
    public static final Key<Boolean> EXPLICIT_ESCALATE_VISIBILITY_KEY = new Key("ES6MoveModuleMembersHandler.EXPLICIT_ESCALATE_VISIBILITY_KEY");

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        PsiElement firstModule = null;
        for (PsiElement element : elements) {
            PsiElement movableElement = ES6MoveModuleMembersHandler.getMovableElement(element);
            if (movableElement != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)element.getProject(), (PsiElement)movableElement)) {
                return false;
            }
            PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(movableElement);
            if (module == null) {
                return false;
            }
            if (firstModule == null) {
                firstModule = module;
                continue;
            }
            if (firstModule.isEquivalentTo(module)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement getMovableElement(@Nullable PsiElement element) {
        JSVariable[] variables;
        if (!DialectDetector.hasFeature(element, JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return null;
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof JSQualifiedNamedElement || element instanceof ES6ExportDefaultAssignment) {
            return element;
        }
        if (element instanceof JSVarStatement && (variables = ((JSVarStatement)element).getVariables()).length == 1) {
            return variables[0];
        }
        return null;
    }

    @Nullable
    private static PsiElement getModuleOrContainingFile(@Nullable PsiElement element) {
        PsiElement module = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class});
        if (module != null && ES6MoveModuleMembersHandler.isAcceptableFileOrModule(module)) {
            return module;
        }
        return null;
    }

    private static boolean isAcceptableFileOrModule(@Nullable PsiElement element) {
        if (element instanceof JSFile) {
            JSFile.ModuleStatus moduleStatus = ((JSFile)element).getModuleStatus();
            return moduleStatus == JSFile.ModuleStatus.ES6 || moduleStatus == JSFile.ModuleStatus.NONE;
        }
        return ES6PsiUtil.isEmbeddedModule(element);
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        super.doMove(project, elements, targetContainer, callback);
        if (elements.length == 0) {
            return;
        }
        PsiElement sourceModuleOrFile = ES6MoveModuleMembersHandler.getModuleOrContainingFile(elements[0]);
        if (sourceModuleOrFile == null) {
            return;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)sourceModuleOrFile);
        if (file2 == null) {
            return;
        }
        String initialPath = StringUtil.notNullize((String)file2.getPresentableUrl());
        List<JSQualifiedNamedElement> selectedElements = Arrays.stream(elements).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiFile targetFile = (PsiFile)project.getUserData(EXPLICIT_TARGET_FILE_KEY);
            boolean escalateVisibility = (Boolean)ObjectUtils.notNull((Object)project.getUserData(EXPLICIT_ESCALATE_VISIBILITY_KEY));
            assert (targetFile != null);
            new ES6MoveModuleMembersProcessor(selectedElements, (PsiElement)targetFile, sourceModuleOrFile, escalateVisibility, null).run();
        } else {
            ES6MoveModuleMembersDialog dialog = new ES6MoveModuleMembersDialog(project, initialPath, initialPath, selectedElements, sourceModuleOrFile, callback);
            dialog.show();
        }
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiElement movableElement = ES6MoveModuleMembersHandler.getMovableElement(element);
        PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(movableElement);
        if (movableElement != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)movableElement)) {
            return false;
        }
        if (module != null) {
            this.doMove(project, new PsiElement[]{movableElement}, null, null);
            return true;
        }
        return false;
    }
}

